import javax.realtime.RealtimeThread;
import javax.safetycritical.AperiodicEvent;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;


public class MainMission extends Mission {
	
	public long missionMemorySize() {
		return 1000000;
	}
	
	protected void initialize() {
		System.out.println("Initializing main mission");
		
		/*
		 * The Shared Buffer is created in MissionMemory
		 */
		Buffer buffer = new BoundedBuffer();
		
		/*
		 * Get a handle to MissionMemory (actual type is BackingStore)
		 */
		MissionMemory missionMemory = (MissionMemory) RealtimeThread.getCurrentMemoryArea();
		System.out.println("1 MissionMemory : " + missionMemory.toString());
		
		/*
		 * Create Consumer AEH
		 * Pass a reference to the shared buffer
		 * ManagedHandlers register themselves upon creation
		 */
		Consumer consumer = new Consumer(buffer);

	    /* The SCJ event consume releases Consumer. */
	    AperiodicEvent consume = new AperiodicEvent(consumer); 	
		
		/*
		 * Create Producer PEH
		 * Pass a reference to MissionMemory and to the shared buffer
		 * ManagedHandlers register themselves upon creation
		 */
		new Producer(consume, missionMemory, buffer);
	}

}
