package hijac.tools.analysis.tasks;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;

import hijac.tools.analysis.SCJAnalysis;
import hijac.tools.analysis.SCJClassTag;
import hijac.tools.analysis.utils.SCJTreePathScanner;

import java.util.Map;

import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

/**
 * @author Frank Zeyda
 * @version $Revision: 226 $
 */
public class ClassTagsVisitor extends SCJTreePathScanner<
      Map<TypeElement, SCJClassTag>,
      Map<TypeElement, SCJClassTag>> {

   public ClassTagsVisitor(SCJAnalysis analysis) {
      super(analysis);
   }

   @Override
   public Map<TypeElement, SCJClassTag> visitClass(
      ClassTree node, Map<TypeElement, SCJClassTag> class_tags) {
      TypeElement type_element = (TypeElement) getElement();
      assert type_element != null;
      assert !class_tags.containsKey(type_element);
      if (type_element.getKind() == ElementKind.CLASS ||
         type_element.getKind() == ElementKind.ENUM ||
         type_element.getKind() == ElementKind.INTERFACE) {
         class_tags.put(type_element, new SCJClassTag(type_element));
      }
      return super.visitClass(node, class_tags);
   }
}
