package hijac.tools.modelgen.targets;

import hijac.tools.config.Config;
import hijac.tools.modelgen.Target;
import hijac.tools.utils.ModelUtils;

import javax.lang.model.element.TypeElement;

/**
 * Translation target that corresponds to an application class.
 *
 * @author Frank Zeyda
 * @version $Revision: 213 $
 */
public class ClassTarget implements Target {
   /**
    * JDK model element representing the class target.
    */
   protected final TypeElement type_element;

   /**
    * Constructs a new application target object.
    */
   public ClassTarget(TypeElement type_element) {
      assert type_element != null;
      this.type_element = type_element;
   }

   /**
    * Returns the type element associated with the class target.
    *
    * @return Type element associated with the class target.
    */
   public TypeElement getTypeElement() {
      return type_element;
   }

   /**
    * Determines whether the class is an API class of the JDK or
    * SCJ / RTSJ programming interface.
    *
    * @return True if the class is an API class of JDK or SCJ / RTSJ.
    */
   public boolean isAPIClass() {
      String class_name = ModelUtils.getQualifiedName(type_element);
      return class_name.startsWith("java.") ||
         class_name.startsWith("javax.") ||
         class_name.startsWith(Config.getSCJPackagePrefix()) ||
         class_name.startsWith(Config.getRTSJPackagePrefix());
   }
}
