package hijac.tools.analysis;

/**
 * Interface that specifies an SCJ analysis task.
 *
 * @author Frank Zeyda
 * @version $Revision: 198 $
 */
public interface AnalysisTask {
   /**
    * Returns the name of the analysis task.
    *
    * @return Name of the task as a string.
    */
   public String getName();

   /**
    * Returns a short description of what the task computes.
    *
    * @return Description of the task as a string.
    */
   public String getDescription();

   /**
    * Returns the data keys required by this task.
    *
    * @return Array of required data key objects.
    */
   public SCJDataKey[] requires();

   /**
    * Returns the data keys generated by this task.
    *
    * @return Array of generated data key objects.
    */
   public SCJDataKey[] generates();

   /**
    * Invokes the analysis task. This method should not throw an exception
    * in case of analysis errors but instead collate and return them using
    * {@link #getErrors()}.
    *
    * @param analysis SCJAnalysis on which the task is performed.
    *
    * @return Boolean flag that determines whether the invocation was
    * successful.
    */
   public boolean invoke(SCJAnalysis analysis);

   /**
    * Determines whether the last invocation was successful.
    *
    * @return Boolean flag that indicates whether the last invocation was
    * successful.
    */
   public boolean success();

   /**
    * Returns all errors raised by the last invocation of the task.
    *
    * @return Array of analysis errors. May be empty if no errors.
    */
   public AnalysisError[] getErrors();

   /**
    * Equality of analysis tasks.
    *
    * <p>In general, we may expect that tasks are considered equal if they have
    * the same name.</p>
    *
    * @return Determines if this object is equal to another.
    */
   @Override
   public boolean equals(Object o);

   /**
    * Hash code of an analysis tasks. Should be consistent with equals.
    *
    * @return Hash code of this object.
    */
   @Override
   public int hashCode();
}
