package hijac.tools.config;

import javax.lang.model.element.Name;

/**
 * @author Frank Zeyda
 * @version $Revision: 198 $
 */
public class Types {
   public static final String SCJ_PACKAGE_PREFIX =
      Config.getSCJPackagePrefix();

   public static final String RTSJ_PACKAGE_PREFIX =
      Config.getRTSJPackagePrefix();

   public static boolean isSCJType(String name) {
      return name.startsWith(SCJ_PACKAGE_PREFIX + ".");
   }

   public static boolean isRTSJType(String name) {
      return name.startsWith(RTSJ_PACKAGE_PREFIX + ".");
   }

   public static boolean isFrameworkType(String name) {
      return isSCJType(name) || isRTSJType(name);
   }

   public static boolean isJavaType(String name) {
      return
         name.startsWith("java.") ||
         name.startsWith("javax.");
   }

   /* Duplication of the above function for arguments of type Name. */

   public static boolean isSCJType(Name name) {
      return isSCJType(name.toString());
   }

   public static boolean isRTSJType(Name name) {
      return isRTSJType(name.toString());
   }

   public static boolean isFrameworkType(Name name) {
      return isFrameworkType(name.toString());
   }

   public static boolean isJavaType(Name name) {
      return isJavaType(name.toString());
   }
}
