/**
 *  This file is part of miniCDx benchmark of oSCJ.
 *
 *   See: http://sss.cs.purdue.edu/projects/oscj/
 */
package cdx;

/**
 * All of our globally relevant constants.
 * 
 * @author Filip Pizlo
 */
public final class Constants {
    // I have added this so that we can specify the number of planes at runtime
    public static int           NUMBER_OF_PLANES                         = 6;

    public static final float   MIN_X                                    = 0.0f;
    public static final float   MIN_Y                                    = 0.0f;
    public static final float   MAX_X                                    = 1000.0f;
    public static final float   MAX_Y                                    = 1000.0f;
    public static final float   MIN_Z                                    = 0.0f;
    public static final float   MAX_Z                                    = 10.0f;
    public static final float   PROXIMITY_RADIUS                         = 1.0f;
    public static final float   GOOD_VOXEL_SIZE                          = PROXIMITY_RADIUS * 10.0f;

    public static int           DETECTOR_STARTUP_PRIORITY                = 9;
    public static int           DETECTOR_PRIORITY                        = 20;                                       
                                                                                                                     
                                                                                                                     
    public static long          PERSISTENT_DETECTOR_SCOPE_SIZE           = 5*100*1000  * 50;  // the factor 50 may be unnecessarily large
    public static long          DETECTOR_PERIOD                          = 50;
    public static long          TRANSIENT_DETECTOR_SCOPE_SIZE            = 5*100*1000  * 50;  // the factor 50 may be unnecessarily large

    public static int           MAX_FRAMES                               = 8;

    public static boolean       PRESIMULATE                              = false;

    public static final String  DETECTOR_RELEASE_STATS                   = "release.rin";
    public static final boolean PRINT_RESULTS                            = true;


    public static int           DETECTOR_NOISE_REACHABLE_POINTERS        = 1000000;
    public static int           DETECTOR_NOISE_ALLOCATE_POINTERS         = 10000;
    public static int           DETECTOR_NOISE_ALLOCATION_SIZE           = 64;
    public static boolean       DETECTOR_NOISE_VARIABLE_ALLOCATION_SIZE  = false;
    public static int           DETECTOR_NOISE_ALLOCATION_SIZE_INCREMENT = 13;
    public static int           DETECTOR_NOISE_MIN_ALLOCATION_SIZE       = 128;
    public static int           DETECTOR_NOISE_MAX_ALLOCATION_SIZE       = 16384;
    public static int           DETECTOR_STARTUP_OFFSET_MILLIS           = 3000;
    public static boolean       DETECTOR_NOISE                           = false;


    // this is only for debugging of the detector code
    //
    // each frame generated by the simulator is processed exactly once by
    // the detector ; this also turns on some debugging features
    //
    // the results thus should be deterministic
    public static boolean       SYNCHRONOUS_DETECTOR                     = false;

    public static boolean       DUMP_RECEIVED_FRAMES                     = false; 
    public static boolean       DEBUG_DETECTOR                           = false;

}
