/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.X509AttributeName;

public class CRLExtensions {
    private Hashtable map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public CRLExtensions() {
    }

    public CRLExtensions(DerInputStream derInputStream) throws CRLException {
        this.init(derInputStream);
    }

    public void decode(InputStream inputStream) throws CRLException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.isContextSpecific((byte)0)) {
                this.init(derValue.data);
            } else {
                this.init(new DerInputStream(derValue.toByteArray()));
            }
        }
        catch (IOException iOException) {
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    private void init(DerInputStream derInputStream) throws CRLException {
        try {
            Object object;
            DerInputStream derInputStream2 = derInputStream;
            byte by = (byte)derInputStream.peekByte();
            if ((by & 0xC0) == 128 && (by & 0x1F) == 0) {
                object = derInputStream2.getDerValue();
                derInputStream2 = object.data;
            }
            object = derInputStream2.getSequence(5);
            for (int i = 0; i < ((DerValue[])object).length; ++i) {
                Extension extension = new Extension(object[i]);
                this.parseExtension(extension);
            }
        }
        catch (IOException iOException) {
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    private void parseExtension(Extension extension) throws CRLException {
        try {
            Class<?> clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) != null) {
                    throw new CRLException("Duplicate extensions not allowed");
                }
                return;
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CRLExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CRLExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n);
            for (int i = 0; i < n; ++i) {
                Array.setByte(object, i, byArray[i]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), certAttrSet) != null) {
                throw new CRLException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CRLException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    public void encode(OutputStream outputStream, boolean bl) throws CRLException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            Collection collection = this.map.values();
            Object[] objectArray = collection.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof CertAttrSet) {
                    ((CertAttrSet)objectArray[i]).encode((OutputStream)derOutputStream);
                    continue;
                }
                if (objectArray[i] instanceof Extension) {
                    ((Extension)objectArray[i]).encode(derOutputStream);
                    continue;
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (bl) {
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
            } else {
                derOutputStream3 = derOutputStream2;
            }
            outputStream.write(derOutputStream3.toByteArray());
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CRLException("Encoding error: " + certificateException.toString());
        }
    }

    public Extension get(String string) {
        String string2;
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string3 = x509AttributeName.getPrefix();
        if (string3.equalsIgnoreCase("x509")) {
            int n = string.lastIndexOf(".");
            string2 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        return (Extension)this.map.get(string2);
    }

    public void set(String string, Object object) {
        this.map.put(string, object);
    }

    public void delete(String string) {
        this.map.remove(string);
    }

    public Enumeration getElements() {
        return this.map.elements();
    }

    public Collection getAllExtensions() {
        return this.map.values();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CRLExtensions)) {
            return false;
        }
        Collection collection = ((CRLExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        if (n != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            Extension extension;
            if (objectArray[i] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i]).getName();
            }
            Extension extension2 = (Extension)objectArray[i];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)this.map.get(string)) == null) {
                return false;
            }
            if (extension.equals(extension2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

