/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;
import sun.security.util.BigInt;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public AlgIdDSA() {
        super(null);
    }

    AlgIdDSA(DerValue derValue) throws IOException {
        super(derValue.getOID());
    }

    public AlgIdDSA(byte[] byArray) throws IOException {
        super(new DerValue(byArray).getOID());
    }

    public AlgIdDSA(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this(new BigInteger(1, byArray), new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public AlgIdDSA(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(AlgorithmId.DSA_oid);
        try {
            this.p = bigInteger;
            this.q = bigInteger2;
            this.g = bigInteger3;
            this.initializeParams();
        }
        catch (IOException iOException) {
            throw new ProviderException("Construct DSS/DSA Algorithm ID");
        }
    }

    public String getName() {
        return "DSA";
    }

    private void initializeParams() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(new BigInt(this.p.toByteArray()));
        derOutputStream.putInteger(new BigInt(this.q.toByteArray()));
        derOutputStream.putInteger(new BigInt(this.g.toByteArray()));
        this.params = new DerValue(48, derOutputStream.toByteArray());
    }

    protected void decodeParams() throws IOException {
        if (this.params == null || this.params.tag != 48) {
            throw new IOException("DSA alg parsing error");
        }
        this.params.data.reset();
        this.p = this.params.data.getInteger().toBigInteger();
        this.q = this.params.data.getInteger().toBigInteger();
        this.g = this.params.data.getInteger().toBigInteger();
        if (this.params.data.available() != 0) {
            throw new IOException("AlgIdDSA params, extra=" + this.params.data.available());
        }
    }

    public String toString() {
        return this.paramsToString();
    }

    protected String paramsToString() {
        return "\n    p:\n" + new BigInt(this.p).toString() + "\n    q:\n" + new BigInt(this.q).toString() + "\n    g:\n" + new BigInt(this.g).toString() + "\n";
    }
}

