/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.AsyncEventHandler;
import javax.realtime.Clock;
import javax.realtime.HeapMemory;
import javax.realtime.HighResolutionTime;
import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.realtime.SchedRefHolder;
import javax.realtime.Schedulable;
import javax.realtime.SchedulerRefRecycler;

public abstract class ReleaseParameters
implements Cloneable {
    Schedulable checkReversePtr;
    RelativeTime cost;
    long costMillis;
    int costNanos;
    Clock costClock;
    RelativeTime deadline;
    long deadlineMillis;
    int deadlineNanos;
    Clock deadlineClock;
    private RelativeTime blocking;
    long blockingMillis;
    int blockingNanos;
    Clock blockingClock;
    AsyncEventHandler overrunHandler;
    private boolean nonNullOverrunHandler;
    private boolean heapOverrunHandler;
    long overrunHandlerHash;
    AsyncEventHandler missHandler;
    private boolean nonNullMissHandler;
    private boolean heapMissHandler;
    long missHandlerHash;
    private int version = 0;
    SchedulerRefRecycler schedSet = new SchedulerRefRecycler();
    private static final RelativeTime zero = new RelativeTime(0L, 0);
    RelativeTime defaultDeadline = new RelativeTime(Long.MAX_VALUE, 999999);
    static final RelativeTime RELATIVETIME_ZERO = new RelativeTime(0L, 0);
    static final RelativeTime RELATIVETIME_MAXDEADLINE = new RelativeTime(Long.MAX_VALUE, 0);
    static /* synthetic */ Class class$javax$realtime$Scheduler;

    protected ReleaseParameters() {
    }

    final synchronized void bind(RealtimeThread realtimeThread) {
        SchedRefHolder schedRefHolder = this.schedSet.find(realtimeThread);
        if (schedRefHolder == null) {
            this.schedSet.add(realtimeThread);
        } else {
            schedRefHolder.execEnv = realtimeThread.getExecEnv();
        }
    }

    final void unbind(RealtimeThread realtimeThread) {
        this.schedSet.remove(realtimeThread);
    }

    public boolean setAllIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3) {
        return this.privateSetIfFeasible(relativeTime, relativeTime2, relativeTime3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean privateSetIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3) {
        boolean bl = true;
        System.out.println("In RP.privateSetIfFeasible(). SchedSet size is " + this.schedSet.size());
        RelativeTime relativeTime4 = this.internalGetCost();
        RelativeTime relativeTime5 = this.internalGetDeadline();
        RelativeTime relativeTime6 = this.internalGetBlocking();
        this.internalSetCost(relativeTime);
        this.internalSetDeadline(relativeTime2);
        this.internalSetBlocking(relativeTime3);
        Class clazz = class$javax$realtime$Scheduler == null ? (class$javax$realtime$Scheduler = ReleaseParameters.class$("javax.realtime.Scheduler")) : class$javax$realtime$Scheduler;
        synchronized (clazz) {
            for (int i = 0; i < this.schedSet.size(); ++i) {
                SchedRefHolder schedRefHolder = this.schedSet.elementAt(i);
                if (schedRefHolder.sched.setReleaseParametersIfFeasible(this, schedRefHolder.hash)) continue;
                this.internalSetCost(relativeTime4);
                this.internalSetDeadline(relativeTime5);
                this.internalSetBlocking(relativeTime6);
                for (int j = i - 1; j > 0; --j) {
                    schedRefHolder = this.schedSet.elementAt(j);
                    schedRefHolder.sched.setReleaseParametersIfFeasible(this, schedRefHolder.hash);
                }
                bl = false;
                break;
            }
        }
        this.updated();
        return bl;
    }

    public boolean setIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2) {
        return this.privateSetIfFeasible(relativeTime, relativeTime2, this.blocking);
    }

    protected ReleaseParameters(RelativeTime relativeTime, RelativeTime relativeTime2, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this(relativeTime, relativeTime2, null, asyncEventHandler, asyncEventHandler2);
    }

    protected ReleaseParameters(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this.internalSetCostNoCheck(relativeTime);
        this.internalSetDeadlineNoCheck(relativeTime2);
        if (relativeTime3 == null) {
            relativeTime3 = new RelativeTime();
        }
        this.internalSetBlocking(relativeTime3);
        this.internalSetCostOverrunHandler(asyncEventHandler);
        this.internalSetMissHandlerUnchecked(asyncEventHandler2);
    }

    public RelativeTime getCost() {
        return this.internalGetCost();
    }

    final RelativeTime internalGetCost() {
        return this.cost;
    }

    final long getCostMillis() {
        return this.costMillis;
    }

    final int getCostNanos() {
        return this.costNanos;
    }

    final long getCostTotalNanos() {
        return (long)this.getCostNanos() + 1000000L * this.getCostMillis();
    }

    final Clock getCostClock() {
        return this.costClock;
    }

    public RelativeTime getBlockingTime() {
        return this.blocking;
    }

    final RelativeTime internalGetBlocking() {
        return this.blocking;
    }

    public void setBlockingTime(RelativeTime relativeTime) {
        this.internalSetBlocking(relativeTime);
    }

    final void internalSetBlocking(RelativeTime relativeTime) {
        relativeTime = this.checkBlockingTime(relativeTime);
        this.internalSetBlockingNoCheck(relativeTime);
    }

    final RelativeTime checkBlockingTime(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        if (relativeTime.compareToZero() < 0) {
            throw new IllegalArgumentException("Negative blocking time");
        }
        return relativeTime;
    }

    public AsyncEventHandler getCostOverrunHandler() {
        return this.internalGetCostOverrunHandler();
    }

    final AsyncEventHandler internalGetCostOverrunHandler() {
        return this.overrunHandler;
    }

    public RelativeTime getDeadline() {
        return this.internalGetDeadline();
    }

    final RelativeTime internalGetDeadline() {
        return this.deadline;
    }

    final long getDeadlineMillis() {
        return this.deadlineMillis;
    }

    final int getDeadlineNanos() {
        return this.deadlineNanos;
    }

    final Clock getDeadlineClock() {
        return this.deadlineClock;
    }

    public AsyncEventHandler getDeadlineMissHandler() {
        return this.internalGetDeadlineMissHandler();
    }

    AsyncEventHandler internalGetDeadlineMissHandler() {
        return this.missHandler;
    }

    public void setCost(RelativeTime relativeTime) {
        this.internalSetCost(relativeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetCost(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime(0L, 0);
        }
        this.checkCost(relativeTime);
        ReleaseParameters releaseParameters = this;
        synchronized (releaseParameters) {
            this.internalSetCostNoCheck(relativeTime);
            this.updateSchedulables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateSchedulables() {
        ReleaseParameters releaseParameters = this;
        synchronized (releaseParameters) {
            for (int i = 0; i < this.schedSet.size(); ++i) {
                SchedRefHolder schedRefHolder = this.schedSet.elementAt(i);
                schedRefHolder.sched.updateReleaseParameters(this, schedRefHolder.hash);
            }
            this.updated();
        }
    }

    public void setCostOverrunHandler(AsyncEventHandler asyncEventHandler) {
        this.internalSetCostOverrunHandler(asyncEventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetCostOverrunHandler(AsyncEventHandler asyncEventHandler) {
        ReleaseParameters releaseParameters = this;
        synchronized (releaseParameters) {
            this.overrunHandler = asyncEventHandler;
            if (asyncEventHandler == null) {
                this.nonNullOverrunHandler = false;
                this.heapOverrunHandler = false;
                this.overrunHandlerHash = 0L;
            } else {
                this.nonNullOverrunHandler = true;
                this.overrunHandlerHash = asyncEventHandler.hashCode();
                this.heapOverrunHandler = MemoryArea.getMemoryArea(asyncEventHandler) == HeapMemory.instance();
            }
            this.updateSchedulables();
        }
    }

    public void setDeadline(RelativeTime relativeTime) {
        this.internalSetDeadline(relativeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalSetDeadline(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime(this.defaultDeadline);
        }
        this.checkDeadline(relativeTime);
        ReleaseParameters releaseParameters = this;
        synchronized (releaseParameters) {
            this.internalSetDeadlineNoCheck(relativeTime);
            this.updateSchedulables();
        }
    }

    public void setDeadlineMissHandler(AsyncEventHandler asyncEventHandler) {
        this.internalSetDeadlineMissHandler(asyncEventHandler);
    }

    final void internalSetDeadlineMissHandler(AsyncEventHandler asyncEventHandler) {
        this.internalSetMissHandlerUnchecked(asyncEventHandler);
    }

    public synchronized Object clone() {
        ReleaseParameters releaseParameters = null;
        try {
            RelativeTime relativeTime = this.cost;
            RelativeTime relativeTime2 = this.deadline;
            RelativeTime relativeTime3 = this.blocking;
            SchedulerRefRecycler schedulerRefRecycler = this.schedSet;
            this.cost = null;
            this.deadline = null;
            this.schedSet = null;
            this.checkReversePtr = null;
            releaseParameters = (ReleaseParameters)super.clone();
            releaseParameters.cost = relativeTime == null ? null : (RelativeTime)relativeTime.clone();
            releaseParameters.blocking = relativeTime3 == null ? null : (RelativeTime)relativeTime3.clone();
            releaseParameters.deadline = relativeTime2 == null ? null : (RelativeTime)relativeTime2.clone();
            releaseParameters.schedSet = new SchedulerRefRecycler();
            this.cost = relativeTime;
            this.blocking = relativeTime3;
            this.deadline = relativeTime2;
            this.schedSet = schedulerRefRecycler;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
        return releaseParameters;
    }

    final void checkCost(RelativeTime relativeTime) {
        if (relativeTime.compareTo(zero) < 0) {
            throw new IllegalArgumentException("cost less than zero");
        }
    }

    final void checkDeadline(RelativeTime relativeTime) {
        if (relativeTime.compareTo(zero) <= 0) {
            throw new IllegalArgumentException("deadline not greater than zero");
        }
    }

    final void internalSetCostNoCheck(RelativeTime relativeTime) {
        this.cost = relativeTime;
        this.costMillis = relativeTime.getMilliseconds();
        this.costNanos = relativeTime.getNanoseconds();
        this.costClock = relativeTime.getClock();
        this.updated();
    }

    final void internalSetBlockingNoCheck(RelativeTime relativeTime) {
        this.blocking = this.cost;
        this.blockingMillis = this.cost.getMilliseconds();
        this.blockingNanos = this.cost.getNanoseconds();
        this.blockingClock = this.cost.getClock();
        this.updated();
    }

    final void internalSetDeadlineNoCheck(RelativeTime relativeTime) {
        this.deadline = relativeTime;
        this.deadlineMillis = relativeTime.getMilliseconds();
        this.deadlineNanos = relativeTime.getNanoseconds();
        this.deadlineClock = relativeTime.getClock();
        this.updated();
    }

    final boolean hasMissHandler() {
        return this.nonNullMissHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetMissHandlerUnchecked(AsyncEventHandler asyncEventHandler) {
        ReleaseParameters releaseParameters = this;
        synchronized (releaseParameters) {
            this.missHandler = asyncEventHandler;
            if (asyncEventHandler == null) {
                this.nonNullMissHandler = false;
                this.heapMissHandler = false;
                this.missHandlerHash = 0L;
            } else {
                this.nonNullMissHandler = true;
                this.missHandlerHash = asyncEventHandler.hashCode();
                this.heapMissHandler = MemoryArea.getMemoryArea(asyncEventHandler) == HeapMemory.instance();
            }
            this.updateSchedulables();
        }
    }

    final long getMissHandlerHash() {
        return this.missHandlerHash;
    }

    final boolean hasHeapMissHandler() {
        return this.heapMissHandler;
    }

    final void updated() {
        ++this.version;
    }

    final int getVersion() {
        return this.version;
    }

    static final boolean isRealDeadline(HighResolutionTime highResolutionTime) {
        if (highResolutionTime == null) {
            return false;
        }
        if (highResolutionTime instanceof AbsoluteTime) {
            return true;
        }
        return highResolutionTime.compareTo(RELATIVETIME_ZERO) > 0 && highResolutionTime.compareTo(RELATIVETIME_MAXDEADLINE) < 0;
    }

    final boolean hasOverrunHandler() {
        return this.nonNullOverrunHandler;
    }

    final boolean hasHeapOverrunHandler() {
        return this.heapOverrunHandler;
    }

    long getCostOverrunHandlerHash() {
        return this.overrunHandlerHash;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

