/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AEHImpl;
import javax.realtime.AbsoluteTime;
import javax.realtime.AffinitySet;
import javax.realtime.AperiodicParameters;
import javax.realtime.ArrivalElement;
import javax.realtime.ArrivalTimeQueueOverflowException;
import javax.realtime.AsyncDMEvent;
import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.AsynchronouslyInterruptedException;
import javax.realtime.Clock;
import javax.realtime.CpuTimeClock;
import javax.realtime.DeadlineQueue;
import javax.realtime.HeapMemory;
import javax.realtime.HighResolutionTime;
import javax.realtime.LateStartException;
import javax.realtime.Lock;
import javax.realtime.MITViolationException;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.MonitorControl;
import javax.realtime.NoDeadlineParams;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.PeriodicParameters;
import javax.realtime.PeriodicTimer;
import javax.realtime.PhasingPolicy;
import javax.realtime.PriorityInheritance;
import javax.realtime.PriorityParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.ProcessorAffinityException;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThreadCNI;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.Scheduler;
import javax.realtime.SchedulingParameters;
import javax.realtime.ScopedCycleException;
import javax.realtime.ScopedMemory;
import javax.realtime.SporadicParameters;
import javax.realtime.Timer;

public class RealtimeThread
extends Thread
implements Schedulable {
    private long execEnv = 0L;
    private long pthreadHandle;
    private int threadId;
    private int initStackIndex = 0;
    private boolean setParentForInitMA = false;
    boolean thisThreadServesAnAEH;
    private AEHImpl associatedAeh;
    private boolean fireAble = false;
    private long topScopeRef = 0L;
    private int RTPriority = 0;
    Scheduler scheduler = null;
    private SchedulingParameters scheduling = null;
    ReleaseParameters releaseParameters = null;
    private MemoryParameters memoryParameters = null;
    private MemoryArea memoryArea;
    private long memoryAreaInfoPointer = 0L;
    private ProcessingGroupParameters groupParameters = null;
    Runnable logic = null;
    boolean hasMissHandler = false;
    boolean hasOverrunHandler = false;
    private boolean pending = false;
    private long startOfPeriodMicros = 0L;
    private boolean scopeDaemon = false;
    private Object deadlineMissLock = new Object();
    long deadlineMissesProcessed = 0L;
    long deadlineMissCount = 0L;
    int ignoreMissCount = 0;
    private boolean blockedForRelease = false;
    private Object deadlineLock = new Object();
    private Object scheduleLock = new Object();
    long installedMissHandlerHash = 0L;
    long installedOverrunHandlerHash = 0L;
    private boolean lastWFNPtrue = true;
    private boolean lastWFNRtrue = true;
    private PeriodicTimer deadlineTimer = null;
    private AbsoluteTime effectiveStartTime = new AbsoluteTime();
    private AbsoluteTime nextExpectedReleaseTime = new AbsoluteTime();
    private AbsoluteTime lastReleaseTime = new AbsoluteTime();
    private long lastCpuStamp = 0L;
    private long minCpuTime = Long.MAX_VALUE;
    private long maxCpuTime = Long.MIN_VALUE;
    CpuTimeClock cpuTimeClock;
    AsyncEvent costOverrunAE;
    int doInterruptibleDepth = 0;
    private AbsoluteTime absoluteStart = new AbsoluteTime();
    private final AbsoluteTime at = new AbsoluteTime();
    private final AbsoluteTime atForResched = new AbsoluteTime();
    private final RelativeTime rt = new RelativeTime();
    private final RelativeTime rtForResched = new RelativeTime();
    private int sdDepth = 0;
    private AffinitySet affinitySet;
    private AffinitySet effectiveAffinitySet;
    private Object fireLock = new Object();
    private boolean returnedFromRun = false;
    private static RuntimeException quietAehException = new RuntimeException("javax.realtime.quietAEH");
    Object eeLock = new Object();
    private boolean pendingDeschedule = false;
    private boolean descheduled = false;
    private final AbsoluteTime atForSleep = new AbsoluteTime();
    private final RelativeTime rtForSleep = new RelativeTime();
    RelativeTime periodForDMTimer = new RelativeTime();
    private Lock arrival;
    private volatile int arrivalCount = 0;
    private AbsoluteTime nextRelease = new AbsoluteTime();
    private AbsoluteTime arrivalBound = new AbsoluteTime();
    private AbsoluteTime thisArrival = new AbsoluteTime();
    private DeadlineQueue deadlineQueue = new DeadlineQueue();
    private ArrivalElement currentDeadline;
    static RefCountHolder refCountHolder = new RefCountHolder();
    private int soExitingNow = 0;
    AsyncDMEvent deadlineEvent = null;
    private int releaseParametersVersion = -1;
    private PhasingPolicy phasingPolicy = PhasingPolicy.DEFAULT_PHASING;

    public RealtimeThread() {
        this(null, null, null, null, null, null);
    }

    public RealtimeThread(SchedulingParameters schedulingParameters) {
        this(schedulingParameters, null, null, null, null, null);
    }

    public RealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters) {
        this(schedulingParameters, releaseParameters, null, null, null, null);
    }

    public RealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, Runnable runnable) {
        this(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, runnable, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, Runnable runnable, boolean bl, AEHImpl aEHImpl) {
        super(runnable);
        RealtimeThread realtimeThread = null;
        Thread thread = Thread.currentThread();
        this.thisThreadServesAnAEH = aEHImpl != null;
        this.associatedAeh = aEHImpl;
        if (thread instanceof RealtimeThread) {
            realtimeThread = (RealtimeThread)thread;
            this.scheduler = realtimeThread.getScheduler();
        } else {
            this.scheduler = Scheduler.getDefaultScheduler();
        }
        if (schedulingParameters == null && realtimeThread != null) {
            schedulingParameters = (SchedulingParameters)realtimeThread.getSchedulingParameters().clone();
        }
        try {
            this.internalSetSchedulingParameters(schedulingParameters);
            this.internalSetReleaseParameters(releaseParameters);
            this.memoryParameters = memoryParameters;
            this.arrival = new Lock();
            Object object = this.arrival;
            synchronized (object) {
                MonitorControl.setMonitorControl(this.arrival, PriorityInheritance.instance());
            }
            if (this.memoryParameters != null) {
                this.memoryParameters.bind(this);
            }
            if (bl) {
                this.setScopeDaemon(bl);
            }
            if ((object = MemoryArea.getMemoryArea(this)) instanceof ScopedMemory) {
                this.setTopScopeRef(((MemoryArea)object).getNativeInfoRef());
            } else {
                this.setTopScopeRef(0L);
            }
            if (memoryArea == null) {
                this.memoryArea = object;
            } else {
                this.memoryArea = memoryArea;
                this.lockInitMa(memoryArea);
            }
            this.affinitySet = realtimeThread != null && realtimeThread.getAffinity() != null ? realtimeThread.getAffinity() : (this instanceof NoHeapRealtimeThread ? AffinitySet.getNoHeapSoDefaultAffinity() : AffinitySet.getHeapSoDefaultAffinity());
            this.effectiveAffinitySet = this.affinitySet;
            this.internalSetProcessingGroupParameters(processingGroupParameters);
            this.logic = runnable;
        }
        catch (RuntimeException runtimeException) {
            this.unbindParameterObjects();
            throw runtimeException;
        }
    }

    boolean mainScopeIsAllDaemon() {
        MemoryArea memoryArea = MemoryArea.getMemoryArea(this);
        if (memoryArea instanceof ScopedMemory) {
            boolean bl = ((ScopedMemory)memoryArea).getNonDaemonRefCount() == 0;
            return bl;
        }
        return false;
    }

    int setScopeDaemon(boolean bl) {
        this.sdDepth = bl ? ++this.sdDepth : --this.sdDepth;
        if (this.sdDepth < 0) {
            throw new RuntimeException("RTT setScopeDaemon reached count less than zero");
        }
        if (bl && this.sdDepth == 1 || !bl && this.sdDepth == 0) {
            this.changeSDState(bl);
            this.scopeDaemon = bl;
        }
        return this.sdDepth;
    }

    final boolean getScopeDaemon() {
        return this.scopeDaemon;
    }

    final boolean isScopeDaemon() {
        return this.scopeDaemon;
    }

    final boolean isScopeDaemonInThisScope(MemoryArea memoryArea) {
        return this.isScopeDaemon() && memoryArea == MemoryArea.getMemoryArea(this);
    }

    private void changeSDState(boolean bl) {
        MemoryArea memoryArea;
        if (bl && this.isAlive() && Thread.currentThread() != this) {
            throw new RuntimeException("changeSDState(true), must be called by the thread itself");
        }
        if (this.isAlive() && (memoryArea = MemoryArea.getMemoryArea(this)) instanceof ScopedMemory) {
            ((ScopedMemory)memoryArea).residentChangedScopeDaemonState(bl);
        }
    }

    private static boolean isQuietAehException(RuntimeException runtimeException) {
        return runtimeException == quietAehException;
    }

    final boolean hasNonDefaultIma() {
        if (this.thisThreadServesAnAEH) {
            return this.setParentForInitMA;
        }
        throw new RuntimeException("hasNonDefaultIma is only meaningful for AEHs.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setFireable(boolean bl, boolean bl2) {
        if (this.hasMissHandler) {
            this.makeHandlersFireable(bl);
        }
        Object object = this.fireLock;
        synchronized (object) {
            this.fireAble = bl;
            this.fireLock.notifyAll();
        }
        if (this.setParentForInitMA && !bl) {
            if (this.thisThreadServesAnAEH) {
                if (!bl2) {
                    throw quietAehException;
                }
            } else {
                System.err.println("Trying to throw quiet AEH at a regular thread");
                object = new Exception();
                ((Throwable)object).fillInStackTrace();
                ((Throwable)object).printStackTrace();
            }
        }
    }

    private void makeHandlersFireable(boolean bl) {
        if (!bl) {
            if (this.hasMissHandler && this.deadlineEvent != null) {
                this.deadlineEvent.setHandler(null);
                this.installedMissHandlerHash = 0L;
            }
        } else {
            this.updateMissHandlerFromReleaseParameters();
        }
    }

    final boolean isFireable() {
        return this.fireAble && this.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleAehExit(RuntimeException runtimeException) throws InterruptedException {
        if (RealtimeThread.isQuietAehException(runtimeException)) {
            Object object = this.fireLock;
            synchronized (object) {
                this.returnedFromRun = true;
                this.fireLock.notifyAll();
                if (this.isFireable()) {
                    return true;
                }
            }
            this.waitTilFireable();
            object = this.fireLock;
            synchronized (object) {
                this.returnedFromRun = false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitTilFireable() throws InterruptedException {
        if (this.setParentForInitMA) {
            Object object = this.fireLock;
            synchronized (object) {
                while (!this.isFireable()) {
                    this.fireLock.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitTilNotFireable() throws InterruptedException {
        if (this.setParentForInitMA) {
            Object object = this.fireLock;
            synchronized (object) {
                while (this.isAlive() && !this.returnedFromRun) {
                    this.fireLock.wait();
                }
            }
        }
        Object object = this.fireLock;
        synchronized (object) {
            while (this.isFireable()) {
                this.fireLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endAEHandlerThread() {
        Object object = this.fireLock;
        synchronized (object) {
            if (!this.isFireable()) {
                this.interrupt();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long getDeadlinesMissed() {
        Object object = this.deadlineMissLock;
        synchronized (object) {
            return this.deadlineMissCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void incrementDeadlineMissedCount() {
        Object object = this.deadlineMissLock;
        synchronized (object) {
            ++this.deadlineMissCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void decrementDeadlineMissedCount() {
        Object object = this.deadlineMissLock;
        synchronized (object) {
            --this.deadlineMissCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deadlineMissOccurred() {
        Object object = this.deadlineMissLock;
        synchronized (object) {
            return this.deadlineMissCount > this.deadlineMissesProcessed;
        }
    }

    private void resetDeadlineMissesProcessed() {
        long l;
        this.deadlineMissesProcessed = l = this.getDeadlinesMissed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecEnv(int n, long l, int n2) {
        Object object = this.eeLock;
        synchronized (object) {
            if (n == 0) {
                System.err.println("Setting RealtimeThread.ee to 0");
            }
            this.execEnv = n;
            this.pthreadHandle = l;
            this.threadId = n2;
        }
        if (this.scheduling instanceof PriorityParameters) {
            ((PriorityParameters)this.scheduling).bind(this);
        }
        if (this.releaseParameters != null) {
            this.releaseParameters.bind(this);
        }
        if (this.memoryParameters != null) {
            this.memoryParameters.bind(this);
        }
        if (this.groupParameters != null) {
            this.groupParameters.bind(this);
        }
        if (this.deadlineEvent != null) {
            this.deadlineEvent.setEE(n);
        }
    }

    final long getExecEnv() {
        return this.execEnv;
    }

    final long getThreadId() {
        return this.pthreadHandle;
    }

    final int getRTPriority() {
        return this.RTPriority;
    }

    final long getDeadlineMillis() {
        return this.releaseParameters.deadlineMillis;
    }

    final int getDeadlineNanos() {
        return this.releaseParameters.deadlineNanos;
    }

    final long getPeriodMillis() {
        try {
            if (this.releaseParameters != null && this.releaseParameters instanceof PeriodicParameters) {
                return ((PeriodicParameters)this.releaseParameters).periodMillis;
            }
            if (this.releaseParameters instanceof SporadicParameters) {
                return ((SporadicParameters)this.releaseParameters).mitMillis;
            }
            return 0L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    final int getPeriodNanos() {
        try {
            if (this.releaseParameters != null && this.releaseParameters instanceof PeriodicParameters) {
                return ((PeriodicParameters)this.releaseParameters).periodNanos;
            }
            if (this.releaseParameters instanceof SporadicParameters) {
                return ((SporadicParameters)this.releaseParameters).mitNanos;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    void lockInitMa(MemoryArea memoryArea) {
        if (memoryArea != MemoryArea.getMemoryArea(this) && memoryArea instanceof ScopedMemory) {
            long l = this.getTopScopeRef();
            boolean bl = ((ScopedMemory)memoryArea).setParent(l);
            if (bl) {
                this.setParentForInitMA = true;
                this.memoryAreaInfoPointer = memoryArea instanceof ScopedMemory ? memoryArea.getNativeInfoRef() : 0L;
                ((ScopedMemory)memoryArea).setInitialMemoryParentLock(true);
            } else {
                throw new ScopedCycleException("Single parent rule violation for initial memory area");
            }
        }
    }

    private static boolean isRealDeadline(ReleaseParameters releaseParameters) {
        if (releaseParameters == null) {
            return false;
        }
        if (releaseParameters instanceof NoDeadlineParams) {
            return false;
        }
        return RealtimeThread.isRealDeadline(releaseParameters.deadlineMillis, releaseParameters.deadlineNanos);
    }

    private static boolean isRealDeadline(long l, int n) {
        return l >= 0L;
    }

    private AsyncDMEvent createDMEvent() {
        return new AsyncDMEvent(this);
    }

    public boolean addToFeasibility() {
        return this.scheduler.addToFeasibility(this);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.setIfFeasible(this.scheduling, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.setIfFeasible(this.scheduling, releaseParameters, this.memoryParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.setIfFeasible(this.scheduling, releaseParameters, memoryParameters, this.groupParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters, this.groupParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        if (this.scheduler != null) {
            return this.scheduler.setIfFeasible(this, schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
        }
        return false;
    }

    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters processingGroupParameters) {
        return this.setIfFeasible(this.releaseParameters, this.memoryParameters, processingGroupParameters);
    }

    public boolean setSchedulingParametersIfFeasible(SchedulingParameters schedulingParameters) {
        return this.setIfFeasible(schedulingParameters, this.releaseParameters, this.memoryParameters, this.groupParameters);
    }

    public boolean setReleaseParametersIfFeasible(ReleaseParameters releaseParameters) {
        return this.setIfFeasible(releaseParameters, this.memoryParameters, this.groupParameters);
    }

    public boolean setMemoryParametersIfFeasible(MemoryParameters memoryParameters) {
        return this.setIfFeasible(this.releaseParameters, memoryParameters, this.groupParameters);
    }

    public boolean addIfFeasible() {
        return this.internalAddIfFeasible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean internalAddIfFeasible() {
        if (this.scheduler != null) {
            Scheduler scheduler = this.scheduler;
            synchronized (scheduler) {
                this.scheduler.addToFeasibility(this);
                if (!this.scheduler.isFeasible()) {
                    this.scheduler.removeFromFeasibility(this);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static RealtimeThread currentRealtimeThread() throws ClassCastException {
        return (RealtimeThread)Thread.currentThread();
    }

    private void deschedulePending() {
        this.pendingDeschedule = true;
    }

    public void deschedulePeriodic() {
        this.internalDeschedulePeriodic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDeschedulePeriodic() {
        if (this.releaseParameters instanceof PeriodicParameters) {
            Object object = this.scheduleLock;
            synchronized (object) {
                this.descheduled = true;
                this.pendingDeschedule = false;
            }
        }
    }

    public void deschedule() {
        this.internalDeschedule();
    }

    void internalDeschedule() {
        if (this.releaseParameters instanceof AperiodicParameters) {
            this.descheduled = true;
        } else {
            this.internalDeschedulePeriodic();
        }
    }

    private boolean isDescheduled() {
        return this.descheduled;
    }

    public MemoryArea getMemoryArea() {
        return this.internalGetMemoryArea();
    }

    MemoryArea internalGetMemoryArea() {
        return this.memoryArea;
    }

    public MemoryParameters getMemoryParameters() {
        return this.memoryParameters;
    }

    public ProcessingGroupParameters getProcessingGroupParameters() {
        return this.groupParameters;
    }

    public ReleaseParameters getReleaseParameters() {
        return this.releaseParameters;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SchedulingParameters getSchedulingParameters() {
        return this.scheduling;
    }

    public void interrupt() {
        if (this.isAlive()) {
            AsynchronouslyInterruptedException.getGeneric().postAIE(this);
        }
        super.interrupt();
    }

    public boolean removeFromFeasibility() {
        return this.scheduler.removeFromFeasibility(this);
    }

    void finishNativeThread() {
        try {
            AsyncEvent asyncEvent;
            AsyncEventHandler asyncEventHandler = this.getAssociatedAEH();
            if (asyncEventHandler != null) {
                asyncEventHandler.shutdownFromFinishRtt();
            }
            this.scheduler.removeFromFeasibility(this);
            if (this.deadlineTimer != null) {
                asyncEvent = this.deadlineTimer;
                this.deadlineTimer = null;
                ((Timer)asyncEvent).shutdown();
            }
            if (this.deadlineEvent != null) {
                asyncEvent = this.deadlineEvent;
                this.deadlineEvent = null;
                asyncEvent.shutdown();
            }
            if (this.cpuTimeClock != null && this.cpuTimeClock.isArmed()) {
                this.cpuTimeClock.disarmTimer();
            }
            this.unbindParameterObjects();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void unbindParameterObjects() {
        if (this.scheduling instanceof PriorityParameters) {
            ((PriorityParameters)this.scheduling).unbind(this);
        }
        if (this.releaseParameters != null) {
            this.releaseParameters.unbind(this);
        }
        if (this.memoryParameters != null) {
            this.memoryParameters.unbind(this);
        }
        if (this.groupParameters != null) {
            this.groupParameters.unbind(this);
        }
    }

    public void schedulePeriodic() {
        this.internalSchedulePeriodic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSchedulePeriodic() {
        if (this.releaseParameters instanceof PeriodicParameters) {
            if (this.isDescheduled()) {
                this.setStateForReschedule();
                Object object = this.scheduleLock;
                synchronized (object) {
                    this.descheduled = false;
                    this.scheduleLock.notifyAll();
                }
            }
            this.pendingDeschedule = false;
        }
    }

    public void schedule() {
        this.internalSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSchedule() {
        if (this.releaseParameters instanceof AperiodicParameters) {
            Object object = this.scheduleLock;
            synchronized (object) {
                if (this.descheduled) {
                    this.descheduled = false;
                    this.scheduleLock.notifyAll();
                }
            }
        } else {
            this.internalSchedulePeriodic();
        }
    }

    public void setMemoryParameters(MemoryParameters memoryParameters) {
        this.internalSetMemoryParameters(memoryParameters);
    }

    final void internalSetMemoryParameters(MemoryParameters memoryParameters) {
        if (this.memoryParameters != null) {
            this.memoryParameters.unbind(this);
        }
        this.memoryParameters = memoryParameters;
        if (this.memoryParameters != null) {
            this.memoryParameters.bind(this);
        }
    }

    public void setProcessingGroupParameters(ProcessingGroupParameters processingGroupParameters) {
        this.internalSetProcessingGroupParameters(processingGroupParameters);
    }

    final void internalSetProcessingGroupParameters(ProcessingGroupParameters processingGroupParameters) {
        if (this.groupParameters != null) {
            this.groupParameters.unbind(this);
        }
        this.groupParameters = processingGroupParameters;
        if (processingGroupParameters == null) {
            this.effectiveAffinitySet = this.affinitySet;
        } else {
            this.effectiveAffinitySet = processingGroupParameters.getEffectiveAffinity(this);
            processingGroupParameters.bind(this);
        }
        AffinitySet.setAffinity(this, this.effectiveAffinitySet);
    }

    public void setReleaseParameters(ReleaseParameters releaseParameters) {
        this.internalSetReleaseParameters(releaseParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetReleaseParameters(ReleaseParameters releaseParameters) {
        if (releaseParameters == null) {
            long l;
            long l2;
            if (!(this.scheduler instanceof PriorityScheduler)) {
                System.err.println("null ReleaseParameters passed and scheduler is not PriorityScheduler.\nUsing PriorityScheduler defaults, results may be unpredictable.");
            }
            MemoryArea memoryArea = MemoryArea.getMemoryArea(this);
            RealtimeThread realtimeThread = this;
            synchronized (realtimeThread) {
                l2 = memoryArea.executeInAreaBeginWrapper();
                l = memoryArea.getSavedParent();
            }
            try {
                releaseParameters = PriorityScheduler.instance().getDefaultReleaseParameters();
            }
            finally {
                MemoryArea.executeInAreaEndWrapper(l2, l);
            }
        }
        if (!(releaseParameters instanceof NoDeadlineParams)) {
            // empty if block
        }
        if (this.releaseParameters != null) {
            this.releaseParameters.unbind(this);
        }
        this.releaseParameters = releaseParameters;
        this.releaseParameters.bind(this);
    }

    public void setScheduler(Scheduler scheduler, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        this.internalSetScheduler(scheduler, schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetScheduler(Scheduler scheduler, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler must not be null");
        }
        if (scheduler != this.scheduler) {
            RealtimeSystem.getSecurityManager().checkSetScheduler(this, scheduler);
        }
        if (schedulingParameters == null) {
            schedulingParameters = this.scheduling;
        }
        if (releaseParameters == null) {
            releaseParameters = this.releaseParameters;
        }
        if (processingGroupParameters == null) {
            processingGroupParameters = this.groupParameters;
        }
        if (memoryParameters == null) {
            memoryParameters = this.memoryParameters;
        }
        Scheduler scheduler2 = this.scheduler;
        synchronized (scheduler2) {
            this.scheduler.removeFromFeasibility(this);
        }
        scheduler2 = scheduler;
        synchronized (scheduler2) {
            this.scheduler = scheduler;
            this.internalSetSchedulingParameters(schedulingParameters);
            this.internalSetReleaseParameters(releaseParameters);
            this.internalSetMemoryParameters(memoryParameters);
            this.internalSetProcessingGroupParameters(processingGroupParameters);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.internalSetScheduler(scheduler);
    }

    void internalSetScheduler(Scheduler scheduler) {
        this.internalSetScheduler(scheduler, null, null, null, null);
    }

    public void setSchedulingParameters(SchedulingParameters schedulingParameters) {
        this.internalSetSchedulingParameters(schedulingParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetSchedulingParameters(SchedulingParameters schedulingParameters) {
        Object object;
        if (schedulingParameters == null) {
            if (!(this.scheduler instanceof PriorityScheduler)) {
                System.err.println("null SchedulingParameters passed and scheduler is not PriorityScheduler.\nUsing PriorityScheduler defaults, results may be unpredictable.");
            }
            object = MemoryArea.getMemoryArea(this);
            long l = ((MemoryArea)object).executeInAreaBeginWrapper();
            long l2 = ((MemoryArea)object).getSavedParent();
            try {
                schedulingParameters = PriorityScheduler.instance().getDefaultSchedulingParameters();
            }
            finally {
                MemoryArea.executeInAreaEndWrapper(l, l2);
            }
        } else if (PriorityScheduler.getMaxHeapPriorityParameters() != schedulingParameters) {
            // empty if block
        }
        if (this.scheduler instanceof PriorityScheduler && !((PriorityScheduler)this.scheduler).validParameters(schedulingParameters)) {
            throw new IllegalArgumentException("Invalid priority parameters");
        }
        if (this.scheduling instanceof PriorityParameters) {
            ((PriorityParameters)this.scheduling).unbind(this);
        }
        this.scheduling = schedulingParameters;
        if (this.scheduling instanceof PriorityParameters) {
            object = (PriorityParameters)this.scheduling;
            ((PriorityParameters)object).bind(this);
            int n = PriorityScheduler.priorityToRTPriority(((PriorityParameters)object).getPriority());
            if (n >= 0) {
                if (this.isAlive()) {
                    RealtimeThread.setNativeRealtimePriority((int)this.execEnv, n, ((PriorityParameters)object).getPriority());
                } else {
                    this.RTPriority = n;
                }
            } else {
                super.setPriority(((PriorityParameters)object).getPriority());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(Clock clock, HighResolutionTime highResolutionTime) throws InterruptedException, ClassCastException, IllegalArgumentException {
        int n;
        long l;
        RealtimeThread realtimeThread = null;
        RelativeTime relativeTime = null;
        AbsoluteTime absoluteTime = null;
        realtimeThread = RealtimeThread.currentRealtimeThread();
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("time parameter passed is null");
        }
        if (highResolutionTime instanceof RelativeTime && RelativeTime.isNegative((RelativeTime)highResolutionTime)) {
            throw new IllegalArgumentException("Negative sleep time");
        }
        relativeTime = realtimeThread.rtForSleep;
        absoluteTime = realtimeThread.atForSleep;
        clock.getTime(absoluteTime);
        if (highResolutionTime instanceof AbsoluteTime) {
            relativeTime = ((AbsoluteTime)highResolutionTime).subtract(absoluteTime, relativeTime);
            l = relativeTime.getMilliseconds();
            n = relativeTime.getNanoseconds();
            if (RelativeTime.isZero(relativeTime)) {
                return;
            }
        } else {
            l = highResolutionTime.getMilliseconds();
            n = highResolutionTime.getNanoseconds();
        }
        if (l < 0L || l == 0L && n <= 0) {
            return;
        }
        AbsoluteTime absoluteTime2 = absoluteTime;
        synchronized (absoluteTime2) {
            absoluteTime.wait(l, n);
        }
    }

    public static void sleep(HighResolutionTime highResolutionTime) throws InterruptedException {
        RealtimeThread.sleep(Clock.getRealtimeClock(), highResolutionTime);
    }

    private void setStateForReschedule() {
        PeriodicParameters periodicParameters = (PeriodicParameters)this.releaseParameters;
        periodicParameters.periodClock.getTime(this.atForResched);
        if (this.atForResched.compareTo(this.nextExpectedReleaseTime) > 0) {
            this.atForResched.add(periodicParameters.periodMillis, periodicParameters.periodNanos, this.atForResched);
            double d = this.periodsInInterval(this.lastReleaseTime, this.atForResched);
            long l = (long)Math.ceil(d);
            long l2 = periodicParameters.periodMillis * 1000L + (long)(periodicParameters.periodNanos / 1000);
            long l3 = l * l2;
            this.lastReleaseTime.add(l3 / 1000L, (int)(l3 % 1000L * 1000L), this.nextExpectedReleaseTime);
            this.ignoreMissCount = (int)((long)this.ignoreMissCount + l);
            this.resetDeadlineMissesProcessed();
        }
    }

    private double periodsInInterval(AbsoluteTime absoluteTime, AbsoluteTime absoluteTime2) {
        PeriodicParameters periodicParameters = (PeriodicParameters)this.releaseParameters;
        if (absoluteTime2.compareTo(absoluteTime) > 0) {
            absoluteTime2.subtract(absoluteTime, this.rtForResched);
            long l = this.rtForResched.getMilliseconds() * 1000L + (long)(this.rtForResched.getNanoseconds() / 1000);
            long l2 = periodicParameters.periodMillis * 1000L + (long)(periodicParameters.periodNanos / 1000);
            return l / l2;
        }
        return 0.0;
    }

    public static boolean waitForNextPeriodInterruptible() throws IllegalThreadStateException, ClassCastException, InterruptedException {
        return RealtimeThread.currentRealtimeThread().internalWaitForNextPeriodInterruptible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean internalWaitForNextPeriodInterruptible() throws IllegalThreadStateException, ClassCastException, InterruptedException {
        boolean bl;
        boolean bl2 = true;
        if (this.releaseParameters == null || !(this.releaseParameters instanceof PeriodicParameters)) {
            throw new IllegalThreadStateException("waitForNextPeriod called on a non-periodic thread");
        }
        if (this.thisThreadServesAnAEH) {
            throw new IllegalThreadStateException("waitForNextPeriod called from an AEH");
        }
        if (this.pendingDeschedule) {
            this.internalDeschedulePeriodic();
        }
        Object object = this.deadlineLock;
        synchronized (object) {
            if (this.deadlineMissOccurred()) {
                ++this.deadlineMissesProcessed;
                if (this.lastWFNPtrue) {
                    bl = false;
                } else {
                    bl = true;
                    ++this.ignoreMissCount;
                }
                bl2 = false;
            } else {
                ++this.ignoreMissCount;
                bl = true;
            }
        }
        this.endOfReleaseCpuClockHandling();
        if (bl2) {
            object = this.scheduleLock;
            synchronized (object) {
                while (this.isDescheduled()) {
                    try {
                        this.blockedForRelease = true;
                        this.scheduleLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.wfnpReturnProcessing();
                        throw interruptedException;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        this.blockedForRelease = false;
                    }
                }
            }
        }
        object = null;
        if (bl) {
            if (this.nextExpectedReleaseTime == null) {
                throw new RuntimeException("Synchronization error in waitForNextPeriod()");
            }
            object = this.periodicDelay();
            this.wfnpReturnProcessing();
        }
        this.lastWFNPtrue = bl2;
        if (object != null) {
            throw object;
        }
        return bl2;
    }

    private void endOfReleaseCpuClockHandling() {
        this.measureCpuTime();
        if (this.cpuTimeClock.isArmed()) {
            this.cpuTimeClock.disarmTimer();
        }
    }

    private void wfnpReturnProcessing() {
        this.checkForHandlerUpdates();
        if (this.changedReleaseParameters()) {
            if (this.deadlineTimer != null) {
                if (this.nextExpectedReleaseTime.compareTo(this.effectiveStartTime) <= 0) {
                    long l = (long)Math.floor(this.periodsInInterval(this.effectiveStartTime, Clock.getRealtimeClock().getTime(this.at)));
                    this.effectiveStartTime.add(((PeriodicParameters)this.releaseParameters).periodMillis * l, (int)((long)((PeriodicParameters)this.releaseParameters).periodNanos * l), this.nextExpectedReleaseTime);
                }
                this.adjustDeadlineTimer(this.nextExpectedReleaseTime);
            } else {
                throw new RuntimeException("Expecting a deadline timer, but it isn't there");
            }
        }
        this.nextExpectedReleaseTime.add(((PeriodicParameters)this.releaseParameters).periodMillis, ((PeriodicParameters)this.releaseParameters).periodNanos, this.nextExpectedReleaseTime);
    }

    private void adjustDeadlineTimer(AbsoluteTime absoluteTime) {
        absoluteTime.add(this.getDeadlineMillis(), this.getDeadlineNanos(), this.at);
        this.periodForDMTimer.set(this.getPeriodMillis(), this.getPeriodNanos());
        this.deadlineTimer.stop();
        this.ignoreMissCount = 0;
        this.deadlineTimer.reschedule((HighResolutionTime)this.at, this.periodForDMTimer);
        this.deadlineTimer.start();
    }

    protected void checkForHandlerUpdates() {
        if (RealtimeThread.isRealDeadline(this.releaseParameters)) {
            if (this.releaseParameters.hasMissHandler() && this.deadlineEvent == null) {
                this.setupRttTimers();
            } else if (this.installedMissHandlerHash != this.releaseParameters.getMissHandlerHash()) {
                this.updateMissHandlerFromReleaseParameters();
            }
        }
        if (this.releaseParameters.hasOverrunHandler() && this.costOverrunAE == null) {
            this.setupRttTimers();
        } else if (this.installedOverrunHandlerHash != this.releaseParameters.getCostOverrunHandlerHash()) {
            this.updateOverrunHandlerFromReleaseParameters();
        } else if (this.hasOverrunHandler) {
            this.cpuTimeClock.setTimer(this.releaseParameters.getCostTotalNanos(), this.costOverrunAE);
        }
    }

    public static boolean waitForNextPeriod() throws ClassCastException, IllegalThreadStateException {
        while (true) {
            try {
                return RealtimeThread.currentRealtimeThread().internalWaitForNextPeriodInterruptible();
            }
            catch (AsynchronouslyInterruptedException asynchronouslyInterruptedException) {
                asynchronouslyInterruptedException.clear();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static boolean waitForNextRelease() {
        while (true) {
            try {
                return RealtimeThread.currentRealtimeThread().internalWaitForNextReleaseInterruptible();
            }
            catch (AsynchronouslyInterruptedException asynchronouslyInterruptedException) {
                asynchronouslyInterruptedException.clear();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalWaitForNextReleaseInterruptible() throws InterruptedException {
        Object object;
        boolean bl;
        ArrivalElement arrivalElement;
        boolean bl2 = true;
        if (this.releaseParameters instanceof PeriodicParameters) {
            return this.internalWaitForNextPeriodInterruptible();
        }
        if (this.thisThreadServesAnAEH) {
            throw new IllegalThreadStateException("wait for next release may not be invoked from an AEH");
        }
        if (this.cpuTimeClock.isArmed()) {
            this.cpuTimeClock.disarmTimer();
        }
        if ((arrivalElement = this.deadlineQueue.workingDeadline) != null) {
            if (this.currentDeadline == arrivalElement) {
                this.deadlineTimer.stop();
            }
            if (this.currentDeadline != null) {
                this.currentDeadline = this.currentDeadline.next;
            }
            if (this.currentDeadline != null) {
                this.deadlineTimer.reschedule(this.currentDeadline.time);
                this.deadlineTimer.start();
            }
        }
        while ((bl = this.deadlineMissOccurred()) || this.isDescheduled()) {
            if (bl) {
                ++this.deadlineMissesProcessed;
                if (!this.hasMissHandler) {
                    bl2 = false;
                    break;
                }
            }
            object = this.scheduleLock;
            synchronized (object) {
                if (this.isDescheduled()) {
                    try {
                        this.scheduleLock.wait();
                    }
                    catch (AsynchronouslyInterruptedException asynchronouslyInterruptedException) {
                        asynchronouslyInterruptedException.fillInStackTrace();
                        throw asynchronouslyInterruptedException;
                    }
                    catch (InterruptedException interruptedException) {
                        throw interruptedException;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        object = null;
        if (bl2 || !this.lastWFNRtrue) {
            object = this.waitForArrival();
            if (this.deadlineQueue.workingDeadline == null) {
                this.deadlineQueue.moveHeadToWorking();
            }
            this.checkForHandlerUpdates();
            this.aperiodicSetNextOverrun();
        }
        this.lastWFNRtrue = bl2;
        if (object != null) {
            throw object;
        }
        return bl2;
    }

    private void aperiodicSetNextOverrun() {
        if (this.releaseParameters.hasOverrunHandler()) {
            if (this.costOverrunAE == null) {
                this.setupRttTimers();
            } else if (this.installedOverrunHandlerHash != this.releaseParameters.getCostOverrunHandlerHash()) {
                this.updateOverrunHandlerFromReleaseParameters();
            } else {
                this.cpuTimeClock.setTimer(this.releaseParameters.getCostTotalNanos(), this.costOverrunAE);
            }
        }
    }

    public static boolean waitForNextReleaseInterruptible() throws InterruptedException {
        return RealtimeThread.currentRealtimeThread().internalWaitForNextReleaseInterruptible();
    }

    private void setupRttTimers() {
        if (this.cpuTimeClock == null) {
            this.cpuTimeClock = new CpuTimeClock(this);
        }
        this.hasMissHandler = this.releaseParameters == null ? false : this.releaseParameters.hasMissHandler();
        if (this.releaseParameters.hasOverrunHandler() && this.costOverrunAE == null) {
            this.costOverrunAE = new AsyncEvent();
            this.costOverrunAE.setHandler(this.releaseParameters.getCostOverrunHandler());
            this.updateOverrunHandlerFromReleaseParameters();
        }
        if (this.releaseParameters != null && RealtimeThread.isRealDeadline(this.releaseParameters)) {
            if (this.deadlineEvent == null) {
                this.deadlineEvent = this.createDMEvent();
                this.updateMissHandlerFromReleaseParameters();
            }
            if (this.deadlineTimer == null && this.associatedAeh == null) {
                AbsoluteTime absoluteTime = this.getDeadlineMillis() == Long.MAX_VALUE ? new AbsoluteTime(Long.MAX_VALUE, 999999) : this.effectiveStartTime.add(this.getDeadlineMillis(), this.getDeadlineNanos(), null);
                this.createDeadlineTimer(absoluteTime);
                this.deadlineTimer.lockAsScopeDaemon(true);
                if (!AperiodicParameters.isDefaultDeadline(absoluteTime)) {
                    try {
                        this.deadlineTimer.startNoCheck(false, this.phasingPolicy);
                    }
                    catch (LateStartException lateStartException) {
                        throw new RuntimeException("Logic error");
                    }
                }
            }
        }
    }

    final void maskTimers(boolean bl) {
        if (this.deadlineTimer != null) {
            this.deadlineTimer.setEnabled(!bl);
        }
        if (this.cpuTimeClock != null && this.cpuTimeClock.isArmed()) {
            this.cpuTimeClock.disarmTimer();
        }
    }

    private void createDeadlineTimer(HighResolutionTime highResolutionTime) {
        if (this.deadlineEvent == null) {
            this.deadlineEvent = this.createDMEvent();
            this.updateMissHandlerFromReleaseParameters();
        }
        if (this.thisThreadServesAnAEH) {
            return;
        }
        if (this.releaseParameters instanceof PeriodicParameters) {
            this.periodForDMTimer.set(((PeriodicParameters)this.releaseParameters).periodMillis, ((PeriodicParameters)this.releaseParameters).periodNanos, null);
        }
        this.deadlineTimer = new PeriodicTimer(highResolutionTime, this.releaseParameters instanceof PeriodicParameters ? this.periodForDMTimer : null, null){
            private boolean enabled = true;

            public String toString() {
                return "RTT_deadlineTimer " + super.toString();
            }

            public void enable() {
                this.enabled = true;
            }

            public void disable() {
                this.enabled = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Throwable internalFire(Object object, int n, boolean bl) {
                Throwable throwable = null;
                if (!RelativeTime.isZero(this.getInterval())) {
                    Object object2 = RealtimeThread.this.scheduleLock;
                    synchronized (object2) {
                        if (RealtimeThread.this.blockedForRelease && RealtimeThread.this.isDescheduled()) {
                            return throwable;
                        }
                    }
                    object2 = RealtimeThread.this.deadlineLock;
                    synchronized (object2) {
                        if (RealtimeThread.this.ignoreMissCount-- > 0) {
                            return throwable;
                        }
                    }
                    if (RealtimeThread.this.hasMissHandler) {
                        RealtimeThread.this.deschedulePending();
                        RealtimeThread.this.deadlineEvent.fire();
                        while (RealtimeThread.this.deadlineMissOccurred()) {
                            RealtimeThread.this.decrementDeadlineMissedCount();
                            RealtimeThread.this.deadlineEvent.fire();
                        }
                    } else {
                        RealtimeThread.this.incrementDeadlineMissedCount();
                    }
                } else {
                    if (this.enabled) {
                        if (RealtimeThread.this.hasMissHandler) {
                            RealtimeThread.this.internalDeschedule();
                            RealtimeThread.this.deadlineEvent.fire();
                            while (RealtimeThread.this.deadlineMissOccurred()) {
                                ++RealtimeThread.this.deadlineMissesProcessed;
                                RealtimeThread.this.deadlineEvent.fire();
                            }
                        } else {
                            RealtimeThread.this.incrementDeadlineMissedCount();
                        }
                    }
                    if (RealtimeThread.this.currentDeadline != null) {
                        1 var5_6 = this;
                        synchronized (var5_6) {
                            RealtimeThread.this.currentDeadline = ((RealtimeThread)RealtimeThread.this).currentDeadline.next;
                        }
                        if (RealtimeThread.this.currentDeadline != null) {
                            this.reschedule(((RealtimeThread)RealtimeThread.this).currentDeadline.time);
                            this.start();
                        }
                    }
                }
                return throwable;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareFirstRelease() {
        if (this.releaseParameters instanceof AperiodicParameters) {
            this.effectiveStartTime = Clock.getRealtimeClock().getTime(this.effectiveStartTime);
            return;
        }
        if (!((PeriodicParameters)this.releaseParameters).startAbsolute) {
            this.rt.set(((PeriodicParameters)this.releaseParameters).startMillis, ((PeriodicParameters)this.releaseParameters).startNanos, ((PeriodicParameters)this.releaseParameters).startClock);
            this.rt.absolute(((PeriodicParameters)this.releaseParameters).startClock, this.absoluteStart);
            try {
                RealtimeThread.sleep(this.rt);
            }
            catch (Exception exception) {
                System.err.println(" prepareFirstRelease: sleep interrupted: " + exception);
            }
            this.effectiveStartTime = ((PeriodicParameters)this.releaseParameters).startClock.getTime(this.effectiveStartTime);
        } else {
            this.absoluteStart.set(((PeriodicParameters)this.releaseParameters).startMillis, ((PeriodicParameters)this.releaseParameters).startNanos, ((PeriodicParameters)this.releaseParameters).startClock);
            Clock.getRealtimeClock().getTime(this.at);
            if (this.absoluteStart.compareTo(this.at) <= 0) {
                if (this.phasingPolicy == PhasingPolicy.ADJUST_FORWARD_PHASING) {
                    PeriodicParameters periodicParameters = (PeriodicParameters)this.releaseParameters;
                    this.at.subtract(this.absoluteStart, this.rt);
                    long l = this.rt.getMilliseconds() * 1000L + (long)(this.rt.getNanoseconds() / 1000);
                    long l2 = periodicParameters.periodMillis * 1000L + (long)(periodicParameters.periodNanos / 1000);
                    long l3 = (l + l2 - 1L) / l2;
                    long l4 = l3 * l2;
                    this.absoluteStart.add(l4 / 1000L, (int)(l4 % 1000L * 1000L), this.absoluteStart);
                    try {
                        RealtimeThread.sleep(this.absoluteStart);
                    }
                    catch (Exception exception) {
                        System.err.println("prepareFirstRelease: hrStartTime sleep interrupted: " + exception);
                    }
                    this.effectiveStartTime.set(this.absoluteStart);
                } else if (this.phasingPolicy == PhasingPolicy.ADJUST_BACKWARD_PHASING) {
                    PeriodicParameters periodicParameters = (PeriodicParameters)this.releaseParameters;
                    this.at.subtract(this.absoluteStart, this.rt);
                    long l = this.rt.divideBy(periodicParameters.periodMillis, periodicParameters.periodNanos);
                    this.rt.set(periodicParameters.periodMillis * l, (int)((long)periodicParameters.periodNanos * l));
                    this.absoluteStart.add(this.rt, this.effectiveStartTime);
                } else if (this.phasingPolicy == PhasingPolicy.DEFAULT_PHASING) {
                    this.effectiveStartTime = ((PeriodicParameters)this.releaseParameters).startClock.getTime(this.effectiveStartTime);
                } else {
                    if (this.phasingPolicy != PhasingPolicy.STRICT_PHASING) throw new RuntimeException("Logic error in RealtimeThread.prepareFirstRelease. Illegal value of phasing policy");
                    this.effectiveStartTime.set(this.absoluteStart);
                }
            } else {
                try {
                    RealtimeThread.sleep(this.absoluteStart);
                }
                catch (Exception exception) {
                    System.err.println("prepareFirstRelease: hrStartTime sleep interrupted: " + exception);
                }
                this.effectiveStartTime.set(this.absoluteStart);
            }
        }
        this.lastReleaseTime.set(this.effectiveStartTime);
        this.nextExpectedReleaseTime = this.effectiveStartTime.add(((PeriodicParameters)this.releaseParameters).periodMillis, ((PeriodicParameters)this.releaseParameters).periodNanos, this.nextExpectedReleaseTime);
        try {
            RealtimeThread.setAffinity(this, this.effectiveAffinitySet);
            return;
        }
        catch (ProcessorAffinityException processorAffinityException) {
            throw new RuntimeException("Logic error. Unexpected exception throw when setting initial processor affinity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterruptedException periodicDelay() {
        InterruptedException interruptedException = null;
        Object object = this.scheduleLock;
        synchronized (object) {
            try {
                this.blockedForRelease = true;
                this.lastReleaseTime.set(this.nextExpectedReleaseTime);
                HighResolutionTime.waitForObject(this.scheduleLock, this.nextExpectedReleaseTime);
                this.blockedForRelease = false;
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
            }
            catch (Exception exception) {
                System.err.println("internalWaitForNextPeriod: exception from sleep: " + exception);
            }
        }
        return interruptedException;
    }

    void updateMissHandlerFromReleaseParameters() {
        if (this.deadlineEvent != null) {
            this.deadlineEvent.setHandler(this.releaseParameters.getDeadlineMissHandler());
        }
        this.hasMissHandler = this.releaseParameters.hasMissHandler();
        this.installedMissHandlerHash = this.releaseParameters.getMissHandlerHash();
    }

    void updateOverrunHandlerFromReleaseParameters() {
        this.hasOverrunHandler = this.releaseParameters.hasOverrunHandler();
        if (this.hasOverrunHandler) {
            this.cpuTimeClock.setTimer(this.releaseParameters.getCostTotalNanos(), this.costOverrunAE);
            if (this.installedOverrunHandlerHash != this.releaseParameters.getCostOverrunHandlerHash()) {
                this.installedOverrunHandlerHash = this.releaseParameters.getCostOverrunHandlerHash();
            }
        }
    }

    private void preparePeriodic() {
        if (this.getReleaseParameters() != null && this.getReleaseParameters() instanceof PeriodicParameters) {
            this.prepareFirstRelease();
            this.setupRttTimers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterruptedException waitForArrival() throws InterruptedException {
        Object object = this.arrival;
        synchronized (object) {
            while (this.arrivalCount == 0) {
                try {
                    this.arrival.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.fillInStackTrace();
                    return interruptedException;
                }
            }
            --this.arrivalCount;
        }
        if (this.releaseParameters instanceof SporadicParameters) {
            object = (SporadicParameters)this.releaseParameters;
            RealtimeThread.sleep(this.nextRelease);
            Clock.getRealtimeClock().getTime(this.nextRelease);
            this.nextRelease.add(((SporadicParameters)object).getMitMillis(), ((SporadicParameters)object).getMitNanos(), this.nextRelease);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean bl = false;
        ArrivalElement arrivalElement = null;
        if (this.releaseParameters instanceof PeriodicParameters) {
            throw new IllegalThreadStateException("release() called on a periodic real-time thread");
        }
        if (this.isDescheduled()) {
            return;
        }
        AperiodicParameters aperiodicParameters = (AperiodicParameters)this.releaseParameters;
        Lock lock = this.arrival;
        synchronized (lock) {
            Object object;
            this.thisArrival = Clock.getRealtimeClock().getTime(this.thisArrival);
            if (this.releaseParameters instanceof SporadicParameters) {
                object = (SporadicParameters)this.releaseParameters;
                if (this.arrivalBound.compareTo(this.thisArrival) > 0) {
                    String string = ((SporadicParameters)object).getMitViolationBehavior();
                    if (SporadicParameters.mitViolationExcept == string) {
                        throw new MITViolationException();
                    }
                    if (SporadicParameters.mitViolationIgnore == string) {
                        return;
                    }
                    if (SporadicParameters.mitViolationReplace == string) {
                        bl = true;
                    } else if (SporadicParameters.mitViolationSave != string) {
                        throw new RuntimeException("Invalid MIT violation policy in sporadic parameters instance");
                    }
                }
                this.thisArrival.add(((SporadicParameters)object).getMitMillis(), ((SporadicParameters)object).getMitNanos(), this.arrivalBound);
            }
            if (RealtimeThread.isRealDeadline(aperiodicParameters) && !aperiodicParameters.isMaxDeadline()) {
                this.thisArrival.add(aperiodicParameters.getDeadlineMillis(), aperiodicParameters.getDeadlineNanos(), this.thisArrival);
            } else {
                this.thisArrival.set(Long.MAX_VALUE, 999999);
            }
            if (bl) {
                arrivalElement = this.deadlineQueue.getTail();
                arrivalElement.time.set(this.thisArrival);
            } else {
                object = aperiodicParameters.getArrivalTimeQueueOverflowBehavior();
                if (AperiodicParameters.arrivalTimeQueueOverflowExcept == object) {
                    if (this.deadlineQueue.size() >= aperiodicParameters.getInitialArrivalTimeQueueLength()) {
                        throw new ArrivalTimeQueueOverflowException("Arrival time queue overflowed in rtt.release()");
                    }
                    arrivalElement = this.deadlineQueue.newElement();
                    arrivalElement.time.set(this.thisArrival);
                    this.deadlineQueue.insert(arrivalElement);
                } else if (AperiodicParameters.arrivalTimeQueueOverflowIgnore == object) {
                    if (this.deadlineQueue.size() >= aperiodicParameters.getInitialArrivalTimeQueueLength()) {
                        return;
                    }
                    arrivalElement = this.deadlineQueue.newElement();
                    arrivalElement.time.set(this.thisArrival);
                    this.deadlineQueue.insert(arrivalElement);
                } else if (AperiodicParameters.arrivalTimeQueueOverflowReplace == object) {
                    if (this.deadlineQueue.size() >= aperiodicParameters.getInitialArrivalTimeQueueLength()) {
                        arrivalElement = this.deadlineQueue.getTail();
                        arrivalElement.time.set(this.thisArrival);
                    } else {
                        arrivalElement = this.deadlineQueue.newElement();
                        arrivalElement.time.set(this.thisArrival);
                        this.deadlineQueue.insert(arrivalElement);
                    }
                } else if (AperiodicParameters.arrivalTimeQueueOverflowSave == object) {
                    arrivalElement = this.deadlineQueue.newElement();
                    arrivalElement.time.set(this.thisArrival);
                    this.deadlineQueue.insert(arrivalElement);
                } else {
                    throw new RuntimeException("Aperiodic parameters contains an unrecognized arrival time overflow policy");
                }
            }
            if (this.currentDeadline == null) {
                this.currentDeadline = arrivalElement;
                if (this.deadlineTimer != null) {
                    this.deadlineTimer.reschedule(this.currentDeadline.time);
                    this.deadlineTimer.start();
                }
            }
            ++this.arrivalCount;
            this.arrival.notify();
        }
    }

    private void installDeadline(AbsoluteTime absoluteTime) {
        if (this.deadlineTimer == null || !this.deadlineTimer.isRunning) {
            if (this.deadlineTimer == null) {
                this.createDeadlineTimer(absoluteTime);
                this.deadlineTimer.lockAsScopeDaemon(true);
                this.deadlineTimer.start();
            } else if (AperiodicParameters.isDefaultDeadline(absoluteTime)) {
                this.deadlineTimer.stop();
            } else {
                this.deadlineTimer.reschedule(absoluteTime);
                this.deadlineTimer.start();
            }
        }
    }

    final long getTopScopeRef() {
        return this.topScopeRef;
    }

    final void setTopScopeRef(long l) {
        this.topScopeRef = l;
    }

    private RefCountHolder refCountsAfterExit(MemoryArea memoryArea) {
        RealtimeThread.refCountHolder.refCount = this.getToSsRefCount0() - 1;
        if (RealtimeThread.refCountHolder.refCount < 0) {
            System.err.println("Top of stack ref count <= 0 in RTT.shutdown");
        }
        RealtimeThread.refCountHolder.sdRefCount = this.getToSsDaemonRefCount0();
        if (memoryArea instanceof ScopedMemory && this.isScopeDaemon() && this.isHomeScopeAtTos0(memoryArea)) {
            --RealtimeThread.refCountHolder.sdRefCount;
        }
        return refCountHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        int n = 0;
        MemoryArea memoryArea = null;
        try {
            Object object;
            this.finishNativeThread();
            if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
                return;
            }
            memoryArea = MemoryArea.getMemoryArea(this);
            if (memoryArea instanceof ScopedMemory) {
                this.incrementSOExitingNow();
            }
            while (RealtimeThread.getMemoryAreaStackDepth0() > 1) {
                if (this.isToSsScoped0()) {
                    object = this.getToSsRefCountLock0();
                    RefCountHolder refCountHolder = this.refCountsAfterExit(memoryArea);
                    boolean bl = this.getToSsIsPinned0();
                    if (ScopedMemory.readyToClear(refCountHolder.refCount, refCountHolder.sdRefCount, bl) && !this.testAndSetToSsFinalizingFlag0(true)) {
                        if (this.isScopeDaemon() && !this.thisThreadServesAnAEH) {
                            System.err.println("A scoped daemon thread, " + this + " wants to execute scope finalization for " + RealtimeThread.getCurrentMemoryArea() + " " + RealtimeThread.getCurrentMemoryArea().getStatus());
                            throw new RuntimeException("Logic error");
                        }
                        do {
                            try {
                                if (this.toSsRunAllFinalizers0()) {
                                    refCountHolder = this.refCountsAfterExit(memoryArea);
                                    bl = this.getToSsIsPinned0();
                                    if (ScopedMemory.readyToClear(refCountHolder.refCount, refCountHolder.sdRefCount, bl)) {
                                        boolean bl2 = this.toSsRunAEShutdowns0();
                                        refCountHolder = this.refCountsAfterExit(memoryArea);
                                        bl = this.getToSsIsPinned0();
                                        if (bl2) {
                                            if (!ScopedMemory.readyToClear(refCountHolder.refCount, refCountHolder.sdRefCount, bl)) break;
                                            this.toSsRunAEShutdowns0();
                                            this.runEeShutdowns0();
                                            this.toSsRunAllFinalizers0();
                                            break;
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            refCountHolder = this.refCountsAfterExit(memoryArea);
                        } while (ScopedMemory.readyToClear(refCountHolder.refCount, refCountHolder.sdRefCount, bl = this.getToSsIsPinned0()));
                        this.testAndSetToSsFinalizingFlag0(false);
                    }
                    Object object2 = object;
                    synchronized (object2) {
                        int n2 = this.getToSsRefCount0();
                        if (n2 <= 0) {
                            System.err.println("Scope at depth " + n + " has reference count of " + n2 + " and daemon count of " + this.getToSsDaemonRefCount0() + " in termination of " + this);
                            System.err.println("Scope is " + RealtimeThread.getCurrentMemoryArea());
                        }
                        this.decToSsRefCount0();
                        if (this.isScopeDaemon() && this.isHomeScopeAtTos0(memoryArea)) {
                            this.decToSsDaemonRefCount0();
                            this.scopeDaemon = false;
                        }
                        object.notifyAll();
                    }
                }
                RealtimeThreadCNI.popAnyMemoryArea();
                ++n;
            }
            object = this.eeLock;
            synchronized (object) {
                if (memoryArea instanceof ScopedMemory) {
                    this.decrementSOExitingNow();
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Exception during thread exit: " + throwable);
            throwable.printStackTrace();
        }
    }

    final synchronized void incrementSOExitingNow() {
        ++this.soExitingNow;
    }

    final synchronized void decrementSOExitingNow() {
        if (this.soExitingNow <= 0) {
            throw new RuntimeException("ScopedMemory.decrementSOExitingNow with count less than zero");
        }
        --this.soExitingNow;
    }

    final synchronized boolean isSOExitingNow() {
        return this.soExitingNow > 0;
    }

    private native boolean isHomeScopeAtTos0(MemoryArea var1);

    private native int getToSsRefCount0();

    private native int getToSsDaemonRefCount0();

    private native void decToSsRefCount0();

    private native void decToSsDaemonRefCount0();

    private native boolean getToSsIsPinned0();

    private native Object getToSsRefCountLock0();

    private native boolean isToSsScoped0();

    native boolean testAndSetToSsFinalizingFlag0(boolean var1);

    private native boolean toSsRunAllFinalizers0();

    private native boolean toSsRunAEShutdowns0();

    private native void runEeShutdowns0();

    final void setPendingFalse() {
        this.pending = false;
    }

    final boolean getPending() {
        return this.pending;
    }

    private boolean changedReleaseParameters() {
        if (this.releaseParameters == null) {
            return false;
        }
        if (this.releaseParameters.getVersion() != this.releaseParametersVersion) {
            this.releaseParametersVersion = this.releaseParameters.getVersion();
            return true;
        }
        return false;
    }

    public static MemoryArea getCurrentMemoryArea() {
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea0();
        return memoryArea == null ? HeapMemory.instance() : memoryArea;
    }

    private static native MemoryArea getCurrentMemoryArea0();

    public String toString() {
        return "RealtimeThread[" + this.getName() + "," + this.getPriority() + "]";
    }

    public static int getInitialMemoryAreaIndex() {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        int n = realtimeThread.getInitialMemoryAreaIndexOfThisThread();
        if (n > RealtimeThread.getMemoryAreaStackDepth()) {
            throw new IllegalStateException("Scope stack is too small to include initial memory area index");
        }
        if (!realtimeThread.getMemoryArea().equals(RealtimeThread.getOuterMemoryArea(n))) {
            throw new IllegalStateException("Initial Memory area not at expected location on stack " + n + ", " + RealtimeThread.getMemoryAreaLocation(realtimeThread.internalGetMemoryArea()));
        }
        return n;
    }

    private int getInitialMemoryAreaIndexOfThisThread() {
        return this.initStackIndex;
    }

    private long getStartupMemEstimate() {
        if (this.releaseParameters != null && !(this.releaseParameters instanceof NoDeadlineParams)) {
            return 5000L;
        }
        return 0L;
    }

    public void start(PhasingPolicy phasingPolicy) throws LateStartException {
        PeriodicParameters periodicParameters;
        if (!(this.releaseParameters instanceof PeriodicParameters)) {
            throw new IllegalArgumentException("Release parameters are not periodic.");
        }
        if (!((PeriodicParameters)this.releaseParameters).isAbsoluteStartTime()) {
            throw new IllegalArgumentException("Assigned start time is not absolute");
        }
        this.phasingPolicy = phasingPolicy;
        if (phasingPolicy == PhasingPolicy.STRICT_PHASING) {
            Clock.getRealtimeClock().getTime(this.at);
        }
        if ((periodicParameters = (PeriodicParameters)this.releaseParameters).getStartMs() < this.at.getMilliseconds() || periodicParameters.getStartMs() == this.at.getMilliseconds() && periodicParameters.getStartNs() < this.at.getNanoseconds()) {
            throw new LateStartException();
        }
        this.internalStart();
    }

    public void start() {
        this.internalStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalStart() {
        long l;
        if (this.memoryParameters != null && (l = this.memoryParameters.getMaxMemoryArea()) != -1L && l < this.getStartupMemEstimate()) {
            throw new OutOfMemoryError("The max allocation limit in the initial memory area is insufficient to start the thread.");
        }
        if (this.releaseParameters != null && this.releaseParameters.hasOverrunHandler() && this.releaseParameters.getCostTotalNanos() == 0L) {
            throw new RuntimeException("Starting a rtt with a overrun handler and zero cost");
        }
        MemoryArea memoryArea = MemoryArea.getMemoryArea(this);
        if (memoryArea instanceof ScopedMemory) {
            this.initStackIndex = RealtimeThread.getMemoryAreaLocation(memoryArea);
            this.incStackRefs0(memoryArea, this.isScopeDaemon());
        }
        if (this.internalGetMemoryArea() instanceof ScopedMemory && this.internalGetMemoryArea() != memoryArea) {
            ++this.initStackIndex;
            if (!this.thisThreadServesAnAEH) {
                ((ScopedMemory)this.internalGetMemoryArea()).setInitialMemoryParentLock(false);
                this.setParentForInitMA = false;
            }
        }
        if (this.scheduling instanceof PriorityParameters) {
            this.RTPriority = PriorityScheduler.priorityToRTPriority(((PriorityParameters)this.scheduling).getPriority());
            if (this.scheduling != PriorityScheduler.getMaxHeapPriorityParameters()) {
                this.updateThresholdPriority(((PriorityParameters)this.scheduling).getPriority());
            }
        }
        this.releaseParametersVersion = this.releaseParameters.getVersion();
        try {
            super.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (memoryArea instanceof ScopedMemory) {
                this.decStackRefs0(memoryArea, this.isScopeDaemon());
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
        }
    }

    private native void incStackRefs0(MemoryArea var1, boolean var2);

    private native void decStackRefs0(MemoryArea var1, boolean var2);

    public static MemoryArea getOuterMemoryArea(int n) {
        int n2 = RealtimeThread.getMemoryAreaStackDepth();
        if (n2 == 0) {
            return null;
        }
        if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            return HeapMemory.instance();
        }
        if (n >= 0 && n < n2) {
            return RealtimeThread.getOuterMemoryArea0(n);
        }
        return null;
    }

    public static int getMemoryAreaStackDepth() {
        if (Thread.currentThread() instanceof RealtimeThread) {
            if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
                return 1;
            }
            return RealtimeThread.getMemoryAreaStackDepth0();
        }
        throw new ClassCastException();
    }

    public AbsoluteTime getLastReleaseTime() {
        return this.internalGetLastReleaseTime(null);
    }

    public AbsoluteTime getLastReleaseTime(AbsoluteTime absoluteTime) {
        return this.internalGetLastReleaseTime(absoluteTime);
    }

    public AbsoluteTime getEffectiveStartTime() {
        return this.internalGetEffectiveStartTime(null);
    }

    public AbsoluteTime getEffectiveStartTime(AbsoluteTime absoluteTime) {
        return this.internalGetEffectiveStartTime(absoluteTime);
    }

    public static RelativeTime getCurrentConsumption(RelativeTime relativeTime) {
        return RealtimeThread.internalGetCurrentConsumption(relativeTime);
    }

    static final RelativeTime internalGetCurrentConsumption(RelativeTime relativeTime) {
        RealtimeThread realtimeThread = (RealtimeThread)Thread.currentThread();
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        realtimeThread.cpuTimeClock.internalGetTime(relativeTime);
        long l = relativeTime.getTotalNanoseconds();
        relativeTime.set((l -= realtimeThread.lastCpuStamp) / 1000000L, (int)(l % 1000000L), Clock.getRealtimeClock(), false);
        return relativeTime;
    }

    public static RelativeTime getCurrentConsumption() {
        return RealtimeThread.internalGetCurrentConsumption(null);
    }

    public RelativeTime getMinConsumption(RelativeTime relativeTime) {
        return this.internalGetMinConsumption(relativeTime);
    }

    final RelativeTime internalGetMinConsumption(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        if (this.minCpuTime == Long.MAX_VALUE) {
            relativeTime.set(0L, 0, Clock.getRealtimeClock());
            return relativeTime;
        }
        relativeTime.set(this.minCpuTime / 1000000L, (int)(this.minCpuTime % 1000000L), Clock.getRealtimeClock());
        return relativeTime;
    }

    public RelativeTime getMinConsumption() {
        return this.internalGetMinConsumption(null);
    }

    public RelativeTime getMaxConsumption(RelativeTime relativeTime) {
        return this.internalGetMaxConsumption(relativeTime);
    }

    final RelativeTime internalGetMaxConsumption(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        if (this.maxCpuTime == Long.MIN_VALUE) {
            relativeTime.set(0L, 0, Clock.getRealtimeClock());
            return relativeTime;
        }
        relativeTime.set(this.maxCpuTime / 1000000L, (int)(this.maxCpuTime % 1000000L), Clock.getRealtimeClock());
        return relativeTime;
    }

    public RelativeTime getMaxConsumption() {
        return this.internalGetMaxConsumption(null);
    }

    final AbsoluteTime internalGetLastReleaseTime(AbsoluteTime absoluteTime) {
        if (!this.isAlive()) {
            throw new IllegalStateException("Thread not started");
        }
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        absoluteTime.set(this.lastReleaseTime);
        return absoluteTime;
    }

    final AbsoluteTime internalGetEffectiveStartTime(AbsoluteTime absoluteTime) {
        if (this.effectiveStartTime == null || this.effectiveStartTime.isZero()) {
            throw new IllegalStateException("Thread not started");
        }
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        absoluteTime.set(this.effectiveStartTime);
        return absoluteTime;
    }

    static final void setAffinity(Thread thread, AffinitySet affinitySet) throws ProcessorAffinityException {
        if (affinitySet == null) {
            throw new NullPointerException("Null affinity set");
        }
        if (thread == null) {
            throw new NullPointerException("Null thread");
        }
        if (thread instanceof RealtimeThread) {
            RealtimeThread realtimeThread = (RealtimeThread)thread;
            if (affinitySet.equals(realtimeThread.affinitySet)) {
                return;
            }
            if (realtimeThread.groupParameters == null) {
                realtimeThread.affinitySet = affinitySet;
                realtimeThread.effectiveAffinitySet = affinitySet;
            } else {
                realtimeThread.affinitySet = affinitySet;
                realtimeThread.effectiveAffinitySet = realtimeThread.groupParameters.getEffectiveAffinity(realtimeThread);
            }
            AffinitySet.setAffinity(realtimeThread, realtimeThread.effectiveAffinitySet);
        } else {
            AffinitySet.setAffinity(thread, affinitySet);
        }
    }

    final AffinitySet getAffinity() {
        return this.affinitySet;
    }

    final AsyncEventHandler getAssociatedAEH() {
        if (this.associatedAeh == null) {
            return null;
        }
        return this.associatedAeh.getPeer();
    }

    void measureCpuTime() {
        long l = this.cpuTimeClock.internalGetNanos();
        long l2 = l - this.lastCpuStamp;
        if (l2 < this.minCpuTime) {
            this.minCpuTime = l2;
        }
        if (l2 > this.maxCpuTime) {
            this.maxCpuTime = l2;
        }
        this.lastCpuStamp = l;
    }

    void updateThresholdPriority(int n) {
        if (this.scheduler instanceof PriorityScheduler) {
            ((PriorityScheduler)this.scheduler).updateHeapSOThreshold(n);
        }
    }

    private void preStartupInitialization() {
    }

    private void setPriorityFromThread(int n) {
        if (this.scheduling == null) {
            return;
        }
        if (!(this.scheduling instanceof PriorityParameters)) {
            throw new ClassCastException("RealtimeThread not scheduled with PriorityParameters");
        }
        PriorityParameters priorityParameters = (PriorityParameters)this.scheduling;
        if (priorityParameters.boundThreadCount() == 1) {
            priorityParameters.setPriority(n);
        } else {
            this.internalSetSchedulingParameters(new PriorityParameters(n));
        }
    }

    protected void finalize() throws Exception {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            System.err.println("RTT.finalize caught an exception from Thread.finalize()");
        }
        if (this.setParentForInitMA && !this.thisThreadServesAnAEH) {
            RealtimeThread.decrementInitialMemoryParentLock0(this.memoryAreaInfoPointer);
            this.setParentForInitMA = false;
        }
    }

    private native boolean canChangeScheduler0(int var1);

    private static native void decrementInitialMemoryParentLock0(long var0);

    static native void setNativeRealtimePriority(int var0, int var1, int var2);

    private static native int getMemoryAreaStackDepth0();

    private native int getMemoryAreaStackDepth1(long var1);

    private static native MemoryArea getOuterMemoryArea0(int var0);

    private native MemoryArea getOuterMemoryArea1(long var1, int var3);

    private static native void getMemoryAreaStack(MemoryArea[] var0);

    static native int getMemoryAreaLocation(MemoryArea var0);

    native boolean memoryAreaOnStack(MemoryArea var1);

    static native long getPThreadIdOfThread0(Thread var0);

    static class RefCountHolder {
        int sdRefCount;
        int refCount;

        RefCountHolder() {
        }
    }
}

