/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.UnknownHappeningException;

public final class POSIXSignalHandler {
    public static final int SIGHUP = 1;
    public static final int SIGINT = 2;
    public static final int SIGQUIT = 3;
    public static final int SIGILL = 4;
    public static final int SIGTRAP = 5;
    public static final int SIGIOT = 6;
    public static final int SIGABRT = 6;
    public static final int SIGEMT;
    public static final int SIGFPE;
    public static final int SIGKILL;
    public static final int SIGBUS;
    public static final int SIGSEGV;
    public static final int SIGSYS;
    public static final int SIGPIPE;
    public static final int SIGALRM;
    public static final int SIGTERM;
    public static final int SIGUSR1;
    public static final int SIGUSR2;
    public static final int SIGCLD;
    public static final int SIGCHLD;
    public static final int SIGPWR;
    public static final int SIGWINCH;
    public static final int SIGURG;
    public static final int SIGPOLL;
    public static final int SIGIO;
    public static final int SIGSTOP;
    public static final int SIGTSTP;
    public static final int SIGCONT;
    public static final int SIGTTIN;
    public static final int SIGTTOU;
    public static final int SIGVTALRM;
    public static final int SIGPROF;
    public static final int SIGXCPU;
    public static final int SIGXFSZ;
    public static final int SIGWAITING;
    public static final int SIGLWP;
    public static final int SIGFREEZE;
    public static final int SIGTHAW;
    public static final int SIGCANCEL;
    public static final int SIGLOST;
    private static final String[] sigCodes;
    private static final int total_signal = 32;
    private static AsyncEvent[] aeArr;
    private static AsyncEventHandler handleSigInt;
    private static AsyncEventHandler handleSigQuit;

    POSIXSignalHandler() {
    }

    public static void addHandler(int n, AsyncEventHandler asyncEventHandler) {
        POSIXSignalHandler.sigCheck(n);
        if (aeArr[n] == null) {
            throw new UnsupportedOperationException(sigCodes[n]);
        }
        if (asyncEventHandler == null) {
            throw new IllegalArgumentException("Null handler argument");
        }
        aeArr[n].internalBindTo(sigCodes[n]);
        aeArr[n].internalAddHandler(asyncEventHandler);
    }

    public static void removeHandler(int n, AsyncEventHandler asyncEventHandler) {
        POSIXSignalHandler.sigCheck(n);
        if (aeArr[n] == null) {
            throw new UnsupportedOperationException(sigCodes[n]);
        }
        if (aeArr[n].internalRemoveHandler(asyncEventHandler)) {
            aeArr[n].internalUnbindTo(sigCodes[n]);
        }
    }

    public static void setHandler(int n, AsyncEventHandler asyncEventHandler) {
        POSIXSignalHandler.sigCheck(n);
        if (aeArr[n] == null) {
            throw new UnsupportedOperationException(sigCodes[n]);
        }
        aeArr[n].internalSetHandler(asyncEventHandler);
        if (aeArr[n].isBound(sigCodes[n])) {
            if (asyncEventHandler == null) {
                aeArr[n].internalUnbindTo(sigCodes[n]);
            }
        } else if (asyncEventHandler != null) {
            aeArr[n].internalBindTo(sigCodes[n]);
        }
    }

    private static void sigCheck(int n) {
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Unknown signal number");
        }
        if (n == 16) {
            throw new IllegalArgumentException("Linux defines signal 16 as SIGSTKFLT, which is not defined for POSIX.");
        }
    }

    static {
        SIGBUS = 7;
        SIGFPE = 8;
        SIGKILL = 9;
        SIGUSR1 = 10;
        SIGSEGV = 11;
        SIGUSR2 = 12;
        SIGPIPE = 13;
        SIGALRM = 14;
        SIGTERM = 15;
        SIGCLD = 17;
        SIGCHLD = 17;
        SIGCONT = 18;
        SIGSTOP = 19;
        SIGTSTP = 20;
        SIGTTIN = 21;
        SIGTTOU = 22;
        SIGURG = 23;
        SIGXCPU = 24;
        SIGXFSZ = 25;
        SIGVTALRM = 26;
        SIGPROF = 27;
        SIGWINCH = 28;
        SIGPOLL = SIGIO = 29;
        SIGPWR = 30;
        SIGSYS = 31;
        SIGEMT = 32;
        SIGWAITING = 32;
        SIGLWP = 32;
        SIGFREEZE = 32;
        SIGTHAW = 32;
        SIGCANCEL = 32;
        SIGLOST = 32;
        aeArr = new AsyncEvent[33];
        handleSigInt = new AsyncEventHandler(){

            public void handleAsyncEvent() {
                System.exit(SIGINT);
            }
        };
        handleSigQuit = new AsyncEventHandler(){

            public void handleAsyncEvent() {
                System.exit(SIGQUIT);
            }
        };
        sigCodes = new String[33];
        for (int i = 1; i <= 32; ++i) {
            if (i == 16) {
                POSIXSignalHandler.aeArr[i] = null;
                POSIXSignalHandler.sigCodes[i] = "Linux defines signal 16 as SIGSTKFLT, which is not defined for POSIX.";
                continue;
            }
            POSIXSignalHandler.aeArr[i] = new AsyncEvent();
            POSIXSignalHandler.sigCodes[i] = Integer.toString(i);
            try {
                aeArr[i].internalBindTo(sigCodes[i]);
                aeArr[i].internalUnbindTo(sigCodes[i]);
                continue;
            }
            catch (UnknownHappeningException unknownHappeningException) {
                POSIXSignalHandler.sigCodes[i] = unknownHappeningException.getMessage();
                POSIXSignalHandler.aeArr[i] = null;
            }
        }
        POSIXSignalHandler.setHandler(SIGINT, handleSigInt);
        POSIXSignalHandler.setHandler(SIGQUIT, handleSigQuit);
    }
}

