/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.RealtimeThread;
import javax.realtime.SchedRefHolder;
import javax.realtime.Schedulable;
import javax.realtime.SchedulerRefRecycler;

public class MemoryParameters
implements Cloneable {
    Schedulable checkReversePtr;
    private long maxMemoryArea = -1L;
    private long maxImmortal = -1L;
    private long allocationRate = -1L;
    public static final long NO_MAX = -1L;
    private SchedulerRefRecycler associatedThreads = new SchedulerRefRecycler();

    public MemoryParameters(long l, long l2) throws IllegalArgumentException {
        this(l, l2, -1L);
    }

    public MemoryParameters(long l, long l2, long l3) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Illegal maxMemoryArea parameter");
        }
        if (l2 < 0L && l2 != -1L) {
            throw new IllegalArgumentException("Illegal maxImmortal parameter");
        }
        if (l3 < 0L && l3 != -1L) {
            throw new IllegalArgumentException("Illegal allocationRate parameter");
        }
        this.maxMemoryArea = l;
        this.maxImmortal = l2;
        this.allocationRate = l3;
    }

    public long getAllocationRate() {
        return this.allocationRate;
    }

    public long getMaxImmortal() {
        return this.maxImmortal;
    }

    public long getMaxMemoryArea() {
        return this.maxMemoryArea;
    }

    public void setAllocationRate(long l) {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Illegal allocationRate parameter");
        }
        this.allocationRate = l;
    }

    public boolean setMaxImmortalIfFeasible(long l) {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Illegal maximum parameter");
        }
        int n = this.associatedThreads.size();
        for (int i = 0; i < n; ++i) {
            long l2 = this.associatedThreads.elementAt((int)i).execEnv;
            if (MemoryParameters.getImmortalUsed0(l2) <= l) continue;
            return false;
        }
        this.maxImmortal = l;
        return true;
    }

    public boolean setMaxMemoryAreaIfFeasible(long l) {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Illegal maximum parameter");
        }
        int n = this.associatedThreads.size();
        for (int i = 0; i < n; ++i) {
            long l2 = this.associatedThreads.elementAt((int)i).execEnv;
            if (MemoryParameters.getMemoryUsed0(l2) <= l) continue;
            return false;
        }
        this.maxMemoryArea = l;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAllocationRateIfFeasible(long l) {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Illegal allocationRate parameter");
        }
        MemoryParameters memoryParameters = this;
        synchronized (memoryParameters) {
            int n = this.associatedThreads.size();
            for (int i = 0; i < n; ++i) {
                long l2;
                long l3 = this.associatedThreads.elementAt((int)i).execEnv;
                long l4 = MemoryParameters.getHeapUsed0(l3);
                if (l4 / (l2 = MemoryParameters.getStartTime0(l3)) <= l) continue;
                return false;
            }
            this.allocationRate = l;
        }
        return true;
    }

    final synchronized void bind(RealtimeThread realtimeThread) {
        SchedRefHolder schedRefHolder = this.associatedThreads.find(realtimeThread);
        if (schedRefHolder == null) {
            this.associatedThreads.add(realtimeThread);
        } else {
            schedRefHolder.execEnv = realtimeThread.getExecEnv();
        }
    }

    final void unbind(RealtimeThread realtimeThread) {
        this.associatedThreads.remove(realtimeThread);
    }

    public synchronized Object clone() {
        try {
            SchedulerRefRecycler schedulerRefRecycler = this.associatedThreads;
            this.associatedThreads = null;
            MemoryParameters memoryParameters = (MemoryParameters)super.clone();
            memoryParameters.associatedThreads = new SchedulerRefRecycler();
            this.associatedThreads = schedulerRefRecycler;
            return memoryParameters;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    static native long getImmortalUsed0(long var0);

    static native long getMemoryUsed0(long var0);

    static native long getHeapUsed0(long var0);

    static native long getStartTime0(long var0);
}

