/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.ImmortalMemory;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.realtime.ScopedCycleException;

public final class HeapMemory
extends MemoryArea {
    private static HeapMemory heap = MemoryArea.isSoftSubsetLExcludeNhOn0() ? null : HeapMemory.initHeap();

    private HeapMemory() {
        super(0x400000L);
        if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            this.initHeap2();
        }
    }

    private void init2() {
    }

    public static HeapMemory instance() {
        if (heap == null) {
            heap = new HeapMemory();
        }
        return heap;
    }

    public long memoryRemaining() {
        return Runtime.getRuntime().freeMemory();
    }

    public long memoryConsumed() {
        return this.size() - this.memoryRemaining();
    }

    public long size() {
        return Runtime.getRuntime().totalMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Runnable runnable) throws ScopedCycleException {
        this.checkNHRTHeapAccess();
        if (runnable == null) {
            throw new IllegalArgumentException("null Runnable");
        }
        if (Thread.currentThread() instanceof RealtimeThread) {
            MemoryArea memoryArea = MemoryArea.getMemoryArea(runnable);
            if (!(memoryArea instanceof ImmortalMemory || memoryArea instanceof HeapMemory || memoryArea == this || memoryArea.reachableMemory())) {
                throw new InaccessibleAreaException("Memory area containing logic is inaccessible from this scope stack.");
            }
            this.pushMemoryArea();
            try {
                runnable.run();
            }
            finally {
                this.popMemoryArea();
            }
        } else {
            throw new IllegalThreadStateException("enter() invoked from a Java Thread");
        }
    }

    public void executeInArea(Runnable runnable) throws InaccessibleAreaException {
        this.checkNHRTHeapAccess();
        super.executeInArea(runnable);
    }

    boolean reachableMemory() {
        return true;
    }

    private static native HeapMemory initHeap();

    private native HeapMemory initHeap2();
}

