/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;

public abstract class Authenticator {
    private static Authenticator theAuthenticator;
    private InetAddress requestingSite;
    private int requestingPort;
    private String requestingProtocol;
    private String requestingPrompt;
    private String requestingScheme;

    private void reset() {
        this.requestingSite = null;
        this.requestingPort = -1;
        this.requestingProtocol = null;
        this.requestingPrompt = null;
        this.requestingScheme = null;
    }

    public static synchronized void setDefault(Authenticator authenticator) {
        NetPermission netPermission = new NetPermission("setDefaultAuthenticator");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(netPermission);
        }
        if (theAuthenticator != null) {
            return;
        }
        theAuthenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) {
        Authenticator authenticator;
        NetPermission netPermission = new NetPermission("requestPasswordAuthentication");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(netPermission);
        }
        if ((authenticator = theAuthenticator) == null) {
            return null;
        }
        Authenticator authenticator2 = authenticator;
        synchronized (authenticator2) {
            authenticator.reset();
            authenticator.requestingSite = inetAddress;
            authenticator.requestingPort = n;
            authenticator.requestingProtocol = string;
            authenticator.requestingPrompt = string2;
            authenticator.requestingScheme = string3;
            return authenticator.getPasswordAuthentication();
        }
    }

    protected final InetAddress getRequestingSite() {
        return this.requestingSite;
    }

    protected final int getRequestingPort() {
        return this.requestingPort;
    }

    protected final String getRequestingProtocol() {
        return this.requestingProtocol;
    }

    protected final String getRequestingPrompt() {
        return this.requestingPrompt;
    }

    protected final String getRequestingScheme() {
        return this.requestingScheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }
}

