/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.MemoryArea;
import javax.realtime.PriorityParameters;
import javax.realtime.RealtimeThread;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public abstract class MissionSequencer
extends BoundAsyncEventHandler {
    private MissionMemory _mem = new MissionMemory(0L);
    private MissionWrapper _wrapper = new MissionWrapper();
    private Mission _mission;

    @SCJAllowed
    public MissionSequencer(PriorityParameters priorityParameters, StorageParameters storageParameters) {
        super(priorityParameters, null, null, null, null, true, null);
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
    }

    @SCJAllowed(value=Level.LEVEL_2)
    public final void start() {
        this.handleAsyncEvent();
    }

    @SCJAllowed
    public final void handleAsyncEvent() {
        this._mission = this.getInitialMission();
        while (this._mission != null) {
            this._wrapper.setMission(this._mission);
            this._mem.resize(this._mission.missionMemorySize());
            this._mem.enter(this._wrapper);
            if (this._mission._terminateAll) break;
            this._mission = this.getNextMission();
        }
    }

    @SCJAllowed(value=Level.LEVEL_2)
    public final void requestSequenceTermination() {
        this._mission.requestSequenceTermination();
    }

    @SCJAllowed
    protected abstract Mission getInitialMission();

    @SCJAllowed
    protected abstract Mission getNextMission();

    class MissionWrapper
    implements Runnable {
        private Mission _mission;

        MissionWrapper() {
        }

        void setMission(Mission mission) {
            this._mission = mission;
        }

        public void run() {
            this._mission.run();
        }
    }
}

