/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.MissionManager;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public abstract class Mission {
    boolean _terminateAll;
    volatile int _phase = -1;

    @SCJAllowed
    public static Mission getCurrentMission() {
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
        if (!(memoryArea instanceof ManagedMemory)) {
            throw new Error("Cannot get current mission in non-managed memory");
        }
        return ((ManagedMemory)memoryArea).getManager().getMission();
    }

    @SCJAllowed
    public void requestTermination() {
        if (this._phase != -2) {
            this._phase = -2;
        }
    }

    @SCJAllowed
    public void requestSequenceTermination() {
        this._terminateAll = true;
        this.requestTermination();
    }

    @SCJAllowed
    public abstract long missionMemorySize();

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    final void run() {
        this._terminateAll = false;
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
        if (!(memoryArea instanceof MissionMemory)) {
            // empty if block
        }
        MissionManager missionManager = new MissionManager(this);
        ((MissionMemory)memoryArea).setManager(missionManager);
        this._phase = 0;
        this.initialize();
        this._phase = 1;
        this.exec(missionManager);
        this._phase = 2;
        this.cleanUp();
        this._phase = -1;
    }

    protected void exec(MissionManager missionManager) {
    }

    @SCJAllowed
    protected abstract void initialize();

    @SCJAllowed(value=Level.LEVEL_1)
    protected void cleanUp() {
    }

    @SCJAllowed
    public final boolean terminationPending() {
        return false;
    }

    @SCJAllowed
    public final boolean sequenceTerminationPending() {
        return false;
    }

    public static class Phase {
        public static final int INITIAL = 0;
        public static final int EXECUTE = 1;
        public static final int CLEANUP = 2;
        public static final int INACTIVE = -1;
        public static final int TERMINATED = -2;
    }
}

