/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.fiji.fivm.r1.NoScopeChecks;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.realtime.ScopedAllocationContext;
import javax.realtime.SizeEstimator;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

public abstract class ScopedMemory
extends MemoryArea
implements ScopedAllocationContext {
    static final ScopedMemory _primordialScope = new ScopedMemory(0L){

        public String toString() {
            return "PrimordialScope";
        }

        public void resize(long l) throws IllegalStateException {
        }
    };
    ScopedMemory _parent;
    private Object _portal;

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public ScopedMemory(long l) {
        super(l);
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public ScopedMemory(SizeEstimator sizeEstimator) {
        super(sizeEstimator.getEstimate());
    }

    public void enter(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("null logic not permitted");
        }
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        this.enterImpl(realtimeThread, runnable);
    }

    public void executeInArea(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("null logic not permitted");
        }
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        this.checkAccessible(realtimeThread);
        this.execInAreaImpl(realtimeThread, runnable);
    }

    public Object newArray(Class clazz, int n) throws NegativeArraySizeException, IllegalAccessException {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        this.checkAccessible(realtimeThread);
        return this.newArrayImpl(realtimeThread, clazz, n);
    }

    public Object newInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        this.checkAccessible(realtimeThread);
        return this.newInstanceImpl(realtimeThread, clazz);
    }

    public void join() throws InterruptedException {
    }

    public Object getPortal() {
        return this.doGetPortal();
    }

    public void setPortal(Object object) {
        this.doSetPortal(object);
    }

    @NoScopeChecks
    Object doGetPortal() {
        return this._portal;
    }

    @NoScopeChecks
    void doSetPortal(Object object) {
        this._portal = object;
    }

    private void checkAccessible(RealtimeThread realtimeThread) {
        if (realtimeThread.getScopeStack().getIndex(this, true) < 0) {
            throw new InaccessibleAreaException();
        }
    }

    protected void preScopeEnter(RealtimeThread realtimeThread) {
        this._parent = RealtimeThread.currentRealtimeThread().getScopeStack().getTopScopedMemory(true);
    }

    protected void postScopeEnter() {
        this._parent = null;
    }
}

