/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public class RelativeTime
extends HighResolutionTime {
    public RelativeTime() {
        this(0L, 0);
    }

    @SCJAllowed
    public RelativeTime(long l, int n) {
        super(l, n, null);
    }

    @SCJAllowed
    public RelativeTime(RelativeTime relativeTime) {
        this(RelativeTime.getMillisNonNull(relativeTime), relativeTime._nanoseconds);
    }

    RelativeTime(long l, int n, Clock clock) {
        super(l, n, clock);
    }

    @SCJAllowed
    @SCJRestricted
    public RelativeTime add(long l, int n) {
        return (RelativeTime)super.add(l, n, new RelativeTime(0L, 0, this._clock));
    }

    @SCJAllowed
    @SCJRestricted
    public RelativeTime add(RelativeTime relativeTime) {
        if (relativeTime == null || relativeTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        return this.add(relativeTime._milliseconds, relativeTime._nanoseconds);
    }

    public RelativeTime relative(Clock clock) {
        return new RelativeTime(this._milliseconds, this._nanoseconds, clock);
    }

    @SCJAllowed
    @SCJRestricted
    public RelativeTime subtract(RelativeTime relativeTime) {
        if (relativeTime == null || relativeTime._clock != this._clock) {
            throw new IllegalArgumentException("null arg or different clock");
        }
        return this.add(-relativeTime._milliseconds, -relativeTime._nanoseconds);
    }

    private static long getMillisNonNull(RelativeTime relativeTime) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("null parameter");
        }
        return relativeTime._milliseconds;
    }
}

