/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import edu.purdue.scj.VMSupport;
import javax.realtime.PhysicalMemoryManager;
import javax.realtime.PhysicalMemoryName;
import javax.realtime.RawIntegralAccess;
import javax.realtime.RawMemoryName;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.LEVEL_0)
public class RawMemoryAccess
implements RawIntegralAccess {
    private static final int LENGTH_OF_BYTE = 1;
    private static final int LENGTH_OF_SHORT = 2;
    private static final int LENGTH_OF_INT = 4;
    private static final int LENGTH_OF_LONG = 8;
    private static final long NOT_MAPPED = -1L;
    private long physicalBase;
    private final long physicalSize;
    private long mappedBase = -1L;
    private long mappedSize;
    private final Object type;
    @SCJAllowed(value=Level.LEVEL_0)
    public static final RawMemoryName IO_ACCESS = null;
    @SCJAllowed(value=Level.LEVEL_0)
    public static final RawMemoryName MEM_ACCESS = null;

    @SCJAllowed(value=Level.LEVEL_0)
    public RawMemoryAccess(PhysicalMemoryName physicalMemoryName, long l) {
        this.type = physicalMemoryName;
        this.physicalSize = l;
        this.physicalBase = -1L;
        this.map();
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public RawMemoryAccess(PhysicalMemoryName physicalMemoryName, long l, long l2) {
        this.physicalSize = l2;
        this.type = physicalMemoryName;
        this.physicalBase = l;
        this.map();
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public static RawIntegralAccess createRmaInstance(RawMemoryName rawMemoryName, long l, long l2) {
        return null;
    }

    public long map() {
        if (this.mappedBase != -1L) {
            return this.mappedBase;
        }
        this.mappedBase = PhysicalMemoryManager.map(this.type, this.physicalBase, this.physicalSize);
        this.mappedSize = this.physicalSize;
        return this.mappedBase;
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public byte getByte(long l) {
        return VMSupport.getByteAtomic(this.checkOffset(l, 1L));
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void getBytes(long l, byte[] byArray, int n, int n2) {
        this.checkOffset(l, n2 * 1);
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = this.getByte(l);
            ++n3;
            ++l;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public int getInt(long l) {
        return VMSupport.getIntAtomic(this.checkOffset(l, 4L));
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void getInts(long l, int[] nArray, int n, int n2) {
        this.checkOffset(l, n2 * 4);
        int n3 = 0;
        while (n3 < n2) {
            nArray[n + n3] = this.getInt(l);
            ++n3;
            l += 4L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public long getLong(long l) {
        return VMSupport.getLong(this.checkOffset(l, 8L));
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void getLongs(long l, long[] lArray, int n, int n2) {
        this.checkOffset(l, n2 * 8);
        int n3 = 0;
        while (n3 < n2) {
            lArray[n + n3] = this.getLong(l);
            ++n3;
            l += 8L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public short getShort(long l) {
        return VMSupport.getShortAtomic(this.checkOffset(l, 2L));
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void getShorts(long l, short[] sArray, int n, int n2) {
        this.checkOffset(l, n2 * 2);
        int n3 = 0;
        while (n3 < n2) {
            sArray[n + n3] = this.getShort(l);
            ++n3;
            l += 2L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setByte(long l, byte by) {
        VMSupport.setByteAtomic(this.checkOffset(l, 1L), by);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setBytes(long l, byte[] byArray, int n, int n2) {
        this.checkOffset(l, n2 * 1);
        int n3 = 0;
        while (n3 < n2) {
            this.setByte(l, byArray[n + n3]);
            ++n3;
            ++l;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setInt(long l, int n) {
        VMSupport.setIntAtomic(this.checkOffset(l, 4L), n);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setInts(long l, int[] nArray, int n, int n2) {
        this.checkOffset(l, n2 * 4);
        int n3 = 0;
        while (n3 < n2) {
            this.setInt(l, nArray[n + n3]);
            ++n3;
            l += 4L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setByte(long l, long l2) {
        VMSupport.setByteAtomic(this.checkOffset(l, 1L), l2);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setLong(long l, long l2) {
        VMSupport.setLong(this.checkOffset(l, 8L), l2);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setLongs(long l, long[] lArray, int n, int n2) {
        this.checkOffset(l, n2 * 8);
        int n3 = 0;
        while (n3 < n2) {
            this.setLong(l, lArray[n + n3]);
            ++n3;
            l += 8L;
        }
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setShort(long l, short s) {
        VMSupport.setShortAtomic(this.checkOffset(l, 2L), s);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public void setShorts(long l, short[] sArray, int n, int n2) {
        this.checkOffset(l, n2 * 2);
        int n3 = 0;
        while (n3 < n2) {
            this.setShort(l, sArray[n + n3]);
            ++n3;
            l += 2L;
        }
    }

    long checkOffset(long l, long l2) {
        long l3 = this.mappedBase;
        return l3 + l;
    }
}

