/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import edu.purdue.scj.VMSupport;
import javax.realtime.AbsoluteTime;
import javax.realtime.ClockCallBack;
import javax.realtime.RelativeTime;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;

@SCJAllowed
public abstract class Clock {
    static final RealtimeClock rtc = RealtimeClock.access$000();

    @SCJAllowed
    public Clock() {
    }

    @SCJAllowed
    @SCJRestricted
    public static Clock getRealtimeClock() {
        return rtc;
    }

    @SCJAllowed
    @SCJRestricted
    public abstract RelativeTime getResolution();

    @SCJAllowed
    @SCJRestricted
    public abstract RelativeTime getResolution(RelativeTime var1);

    @SCJAllowed
    @SCJRestricted
    public abstract AbsoluteTime getTime();

    @SCJAllowed
    @SCJRestricted
    public abstract AbsoluteTime getTime(AbsoluteTime var1);

    @SCJAllowed
    @SCJRestricted
    protected abstract boolean drivesEvents();

    @SCJAllowed(value=Level.LEVEL_1)
    @SCJRestricted
    protected abstract void registerCallBack(AbsoluteTime var1, ClockCallBack var2);

    @SCJAllowed(value=Level.LEVEL_1)
    @SCJRestricted
    protected abstract boolean resetTargetTime(AbsoluteTime var1);

    @SCJAllowed(value=Level.LEVEL_1)
    protected abstract void setResolution(RelativeTime var1);

    @SCJAllowed
    @SCJRestricted
    public abstract RelativeTime getEpochOffset();

    static class RealtimeClock
    extends Clock {
        static RelativeTime resolution = null;

        private RealtimeClock() {
        }

        static long getCurrentTimeNanos() {
            return VMSupport.getCurrentTime();
        }

        static long getResolutionNanos() {
            return resolution.toNanos();
        }

        private static RealtimeClock instance() {
            long l = VMSupport.getClockResolution();
            long l2 = l / 1000000L;
            int n = (int)(l % 1000000L);
            RealtimeClock realtimeClock = new RealtimeClock();
            resolution = new RelativeTime(l2, n, (Clock)realtimeClock);
            return realtimeClock;
        }

        public RelativeTime getResolution() {
            return new RelativeTime(resolution);
        }

        public AbsoluteTime getTime() {
            return this.getTime(new AbsoluteTime(0L, 0, (Clock)this));
        }

        public void setResolution(RelativeTime relativeTime) {
            throw new UnsupportedOperationException();
        }

        public AbsoluteTime getTime(AbsoluteTime absoluteTime) {
            if (absoluteTime != null) {
                long l = RealtimeClock.getCurrentTimeNanos();
                long l2 = l / 1000000L;
                absoluteTime.setDirect(l2, (int)(l %= 1000000L));
                absoluteTime.setClock(this);
            }
            return absoluteTime;
        }

        public RelativeTime getEpochOffset() {
            RelativeTime relativeTime = new RelativeTime(0L, 0);
            relativeTime.setClock(this);
            return relativeTime;
        }

        @SCJAllowed
        protected boolean drivesEvents() {
            return false;
        }

        @SCJAllowed(value=Level.LEVEL_1)
        protected void registerCallBack(AbsoluteTime absoluteTime, ClockCallBack clockCallBack) {
        }

        @SCJAllowed(value=Level.LEVEL_1)
        protected boolean resetTargetTime(AbsoluteTime absoluteTime) {
            return false;
        }

        public RelativeTime getResolution(RelativeTime relativeTime) {
            return null;
        }

        static /* synthetic */ RealtimeClock access$000() {
            return RealtimeClock.instance();
        }
    }
}

