/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.util.Iterator;
import javax.realtime.AsyncEventHandler;
import javax.realtime.IdentityArraySet;
import javax.realtime.UnknownHappeningException;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed(value=Level.LEVEL_1)
public class AsyncEvent {
    final IdentityArraySet handlers = new IdentityArraySet();
    final Object lock = this.handlers;

    public void addHandler(AsyncEventHandler asyncEventHandler) {
        if (asyncEventHandler != null) {
            this.handlers.add(asyncEventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(AsyncEventHandler asyncEventHandler) {
        Object object = this.lock;
        synchronized (object) {
            this.handlers.remove(asyncEventHandler);
        }
    }

    public boolean handledBy(AsyncEventHandler asyncEventHandler) {
        return this.handlers.contains(asyncEventHandler);
    }

    public void setHandler(AsyncEventHandler asyncEventHandler) {
        this.handlers.clear();
        if (asyncEventHandler != null) {
            this.handlers.add(asyncEventHandler);
        }
    }

    public void bindTo(String string) throws UnknownHappeningException {
        throw new UnknownHappeningException("Unsupported happening");
    }

    public void unbindTo(String string) throws UnknownHappeningException {
        throw new UnknownHappeningException("AsyncEvent not bound to this happening");
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public void fire() {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            ((AsyncEventHandler)iterator.next()).releaseHandler();
        }
    }
}

