/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import sun.misc.HexDumpEncoder;
import sun.security.util.BigInt;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CRLExtensions;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;

public class X509CRLImpl
extends X509CRL {
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId = null;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer = null;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private Hashtable revokedCerts = new Hashtable(11);
    private CRLExtensions extensions = null;
    private static final boolean isExplicit = true;
    private static final long YR_2050 = 2524636800000L;
    private boolean readOnly = false;

    private X509CRLImpl() {
    }

    public X509CRLImpl(byte[] byArray) throws CRLException {
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(DerValue derValue) throws CRLException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(InputStream inputStream) throws CRLException {
        try {
            this.parse(new DerValue(inputStream));
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2) {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray) throws CRLException {
        this.issuer = x500Name;
        this.thisUpdate = date;
        this.nextUpdate = date2;
        if (x509CRLEntryArray != null) {
            for (int i = 0; i < x509CRLEntryArray.length; ++i) {
                if (x509CRLEntryArray[i] == null) continue;
                this.revokedCerts.put(x509CRLEntryArray[i].getSerialNumber(), x509CRLEntryArray[i]);
                if (!x509CRLEntryArray[i].hasExtensions()) continue;
                this.version = 1;
            }
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray, CRLExtensions cRLExtensions) throws CRLException {
        this(x500Name, date, date2, x509CRLEntryArray);
        if (cRLExtensions != null) {
            this.extensions = cRLExtensions;
            this.version = 1;
        }
    }

    public byte[] getEncoded() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        byte[] byArray = new byte[this.signedCRL.length];
        System.arraycopy(this.signedCRL, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void encodeInfo(OutputStream outputStream) throws CRLException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (this.version != 0) {
                derOutputStream.putInteger(new BigInt(this.version));
            }
            this.infoSigAlgId.encode(derOutputStream);
            if (this.version == 0 && this.issuer.toString() == null) {
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(derOutputStream);
            if (this.thisUpdate.getTime() < 2524636800000L) {
                derOutputStream.putUTCTime(this.thisUpdate);
            } else {
                derOutputStream.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524636800000L) {
                    derOutputStream.putUTCTime(this.nextUpdate);
                } else {
                    derOutputStream.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedCerts.isEmpty()) {
                Enumeration enumeration = this.revokedCerts.elements();
                while (enumeration.hasMoreElements()) {
                    ((X509CRLEntryImpl)enumeration.nextElement()).encode(derOutputStream2);
                }
                derOutputStream.write((byte)48, derOutputStream2);
            }
            if (this.extensions != null) {
                this.extensions.encode(derOutputStream, true);
            }
            derOutputStream3.write((byte)48, derOutputStream);
            this.tbsCertList = derOutputStream3.toByteArray();
            outputStream.write(this.tbsCertList);
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.getMessage());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, null);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature signature = null;
        signature = string == null || string.length() == 0 ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), string);
        signature.initVerify(publicKey);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        signature.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!signature.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
    }

    public void sign(PrivateKey privateKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(privateKey, string, null);
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw new CRLException("cannot over-write existing CRL");
            }
            Signature signature = null;
            signature = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            signature.initSign(privateKey);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(signature.getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encodeInfo(derOutputStream2);
            this.sigAlgId.encode(derOutputStream2);
            signature.update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = signature.sign();
            derOutputStream2.putBitString(this.signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCRL = derOutputStream.toByteArray();
            this.readOnly = true;
        }
        catch (IOException iOException) {
            throw new CRLException("Error while encoding data: " + iOException.getMessage());
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X.509 CRL v" + (this.version + 1) + "\n");
        if (this.sigAlgId != null) {
            stringBuffer.append("Signature Algorithm: " + this.sigAlgId.toString() + ", OID=" + this.sigAlgId.getOID().toString() + "\n");
        }
        if (this.issuer != null) {
            stringBuffer.append("Issuer: " + this.issuer.toString() + "\n");
        }
        if (this.thisUpdate != null) {
            stringBuffer.append("\nThis Update: " + this.thisUpdate.toString() + "\n");
        }
        if (this.nextUpdate != null) {
            stringBuffer.append("Next Update: " + this.nextUpdate.toString() + "\n");
        }
        if (this.revokedCerts.isEmpty()) {
            stringBuffer.append("\nNO certificates have been revoked\n");
        } else {
            stringBuffer.append("\nRevoked Certificates: " + this.revokedCerts.size());
            int n = 1;
            object = this.revokedCerts.elements();
            while (object.hasMoreElements()) {
                stringBuffer.append("\n[" + n + "] " + ((X509CRLEntry)object.nextElement()).toString());
                ++n;
            }
        }
        if (this.extensions != null) {
            Collection collection = this.extensions.getAllExtensions();
            object = collection.toArray();
            stringBuffer.append("\nCRL Extensions: " + ((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuffer.append("\n[" + (i + 1) + "]: ");
                Extension extension = (Extension)object[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuffer.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuffer.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer(byArray) + "\n");
                        continue;
                    }
                    stringBuffer.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuffer.append(", Error parsing this extension");
                }
            }
        }
        if (this.signature != null) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuffer.append("\nSignature:\n" + hexDumpEncoder.encodeBuffer(this.signature) + "\n");
        } else {
            stringBuffer.append("NOT signed yet\n");
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return false;
        }
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        return this.revokedCerts.containsKey(bigInteger);
    }

    public int getVersion() {
        return this.version + 1;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public Date getThisUpdate() {
        return new Date(this.thisUpdate.getTime());
    }

    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        return new Date(this.nextUpdate.getTime());
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return null;
        }
        return (X509CRLEntry)this.revokedCerts.get(bigInteger);
    }

    public Set getRevokedCertificates() {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>(11);
        Collection collection = this.revokedCerts.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            hashSet.add(objectArray[i]);
        }
        return hashSet;
    }

    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        byte[] byArray = new byte[this.tbsCertList.length];
        System.arraycopy(this.tbsCertList, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        byte[] byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public String getSigAlgName() {
        if (this.sigAlgId == null) {
            return null;
        }
        return this.sigAlgId.getName();
    }

    public String getSigAlgOID() {
        if (this.sigAlgId == null) {
            return null;
        }
        ObjectIdentifier objectIdentifier = this.sigAlgId.getOID();
        return objectIdentifier.toString();
    }

    public byte[] getSigAlgParams() {
        if (this.sigAlgId == null) {
            return null;
        }
        try {
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.extensions == null) {
            return false;
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(11);
        Enumeration enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        if (this.extensions == null) {
            return null;
        }
        try {
            DerEncoder derEncoder;
            Object object;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            DerEncoder derEncoder2 = null;
            if (string2 == null) {
                object = new ObjectIdentifier(string);
                derEncoder = null;
                Enumeration enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    derEncoder = (Extension)enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = ((Extension)derEncoder).getExtensionId();
                    if (!objectIdentifier.equals((ObjectIdentifier)object)) continue;
                    derEncoder2 = derEncoder;
                    break;
                }
            } else {
                derEncoder2 = this.extensions.get(string2);
            }
            if (derEncoder2 == null) {
                return null;
            }
            object = derEncoder2.getExtensionValue();
            if (object == null) {
                return null;
            }
            derEncoder = new DerOutputStream();
            derEncoder.putOctetString((byte[])object);
            return ((ByteArrayOutputStream)((Object)derEncoder)).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        DerValue derValue2;
        AlgorithmId algorithmId;
        if (this.readOnly) {
            throw new CRLException("cannot over-write existing CRL");
        }
        this.signedCRL = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new CRLException("signed overrun, bytes = " + derValue.data.available());
        }
        if (derValueArray[0].tag != 48) {
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].data.available() != 0) {
            throw new CRLException("AlgorithmId field overrun");
        }
        if (derValueArray[2].data.available() != 0) {
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = derValueArray[0].toByteArray();
        DerInputStream derInputStream = derValueArray[0].data;
        this.version = 0;
        byte by = (byte)derInputStream.peekByte();
        if (by == 2) {
            this.version = derInputStream.getInteger().toInt();
            if (this.version != 1) {
                throw new CRLException("Invalid version");
            }
        }
        if (!(algorithmId = AlgorithmId.parse(derValue2 = derInputStream.getDerValue())).equals(this.sigAlgId)) {
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = algorithmId;
        this.issuer = new X500Name(derInputStream);
        if (this.issuer.toString() == null && this.version == 0) {
            throw new CRLException("Null Issuer DN allowed only in v2 CRL");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.thisUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.thisUpdate = derInputStream.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + by + ")");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.nextUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.nextUpdate = derInputStream.getGeneralizedTime();
        }
        if (derInputStream.available() == 0) {
            return;
        }
        by = (byte)derInputStream.peekByte();
        if (by == 48 && (by & 0xC0) != 128) {
            DerValue[] derValueArray2 = derInputStream.getSequence(4);
            for (int i = 0; i < derValueArray2.length; ++i) {
                X509CRLEntryImpl x509CRLEntryImpl = new X509CRLEntryImpl(derValueArray2[i]);
                if (x509CRLEntryImpl.hasExtensions() && this.version == 0) {
                    throw new CRLException("Invalid encoding, extensions not supported in CRL v1 entries.");
                }
                this.revokedCerts.put(x509CRLEntryImpl.getSerialNumber(), x509CRLEntryImpl);
            }
        }
        if (derInputStream.available() == 0) {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)0)) {
            if (this.version == 0) {
                throw new CRLException("Invalid encoding, extensions not supported in CRL v1.");
            }
            this.extensions = new CRLExtensions(derValue2.data);
        }
        this.readOnly = true;
    }
}

