/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import sun.misc.SystemThread;

class SeedGenerator
implements Runnable {
    private static SeedGenerator myself = new SeedGenerator();
    private byte[] pool = new byte[20];
    private int start = 0;
    private int end = 0;
    private int count;
    ThreadGroup seedGroup;
    private static byte[] rndTab = new byte[]{56, 30, -107, -6, -86, 25, -83, 75, -12, -64, 5, -128, 78, 21, 16, 32, 70, -81, 37, -51, -43, -46, -108, 87, 29, 17, -55, 22, -11, -111, -115, 84, -100, 108, -45, -15, -98, 72, -33, -28, 31, -52, -37, -117, -97, -27, 93, -123, 47, 126, -80, -62, -93, -79, 61, -96, -65, -5, -47, -119, 14, 89, 81, -118, -88, 20, 67, -126, -113, 60, -102, 55, 110, 28, 85, 121, 122, -58, 2, 45, 43, 24, -9, 103, -13, 102, -68, -54, -101, -104, 19, 13, -39, -26, -103, 62, 77, 51, 44, 111, 73, 18, -127, -82, 4, -30, 11, -99, -74, 40, -89, 42, -76, -77, -94, -35, -69, 35, 120, 76, 33, -73, -7, 82, -25, -10, 88, 125, -112, 58, 83, 95, 6, 10, 98, -34, 80, 15, -91, 86, -19, 52, -17, 117, 49, -63, 118, -90, 36, -116, -40, -71, 97, -53, -109, -85, 109, -16, -3, 104, -95, 68, 54, 34, 26, 114, -1, 106, -121, 3, 66, 0, 100, -84, 57, 107, 119, -42, 112, -61, 1, 48, 38, 12, -56, -57, 39, -106, -72, 41, 7, 71, -29, -59, -8, -38, 79, -31, 124, -124, 8, 91, 116, 99, -4, 9, -36, -78, 63, -49, -67, -87, 59, 101, -32, 92, 94, 53, -41, 115, -66, -70, -122, 50, -50, -22, -20, -18, -21, 23, -2, -48, 96, 65, -105, 123, -14, -110, 69, -24, -120, -75, 74, 127, -60, 113, 90, -114, 105, 46, 27, -125, -23, -44, 64};

    private SeedGenerator() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        final ThreadGroup[] threadGroupArray = new ThreadGroup[1];
        Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
                while ((threadGroup = threadGroup2.getParent()) != null) {
                    threadGroup2 = threadGroup;
                }
                threadGroupArray[0] = new ThreadGroup(threadGroup2, "SeedGenerator ThreadGroup");
                Thread thread = new Thread(threadGroupArray[0], SeedGenerator.this, "SeedGenerator Thread");
                thread.setPriority(1);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.seedGroup = threadGroupArray[0];
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void run() {
        try {
            while (!SystemThread.exitRequested()) {
                int n;
                SeedGenerator seedGenerator = this;
                // MONITORENTER : seedGenerator
                while (this.count >= this.pool.length) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!SystemThread.exitRequested()) throw interruptedException;
                        // MONITOREXIT : seedGenerator
                        return;
                    }
                }
                // MONITOREXIT : seedGenerator
                byte by = 0;
                int n2 = 0;
                for (int i = 0; i < 64000 && n2 < 6; i += n, ++n2) {
                    try {
                        BogusThread bogusThread = new BogusThread();
                        Thread thread = new Thread(this.seedGroup, bogusThread, "SeedGenerator Thread");
                        thread.start();
                    }
                    catch (Exception exception) {
                        throw new InternalError("internal error: SeedGenerator thread creation error.");
                    }
                    n = 0;
                    n = 0;
                    long l = System.currentTimeMillis() + 250L;
                    while (System.currentTimeMillis() < l) {
                        SeedGenerator seedGenerator2 = this;
                        // MONITORENTER : seedGenerator2
                        // MONITOREXIT : seedGenerator2
                        ++n;
                    }
                    by = (byte)(by ^ rndTab[n % 255]);
                }
                SeedGenerator seedGenerator3 = this;
                // MONITORENTER : seedGenerator3
                this.pool[this.end] = by;
                ++this.end;
                ++this.count;
                if (this.end >= this.pool.length) {
                    this.end = 0;
                }
                this.notifyAll();
                // MONITOREXIT : seedGenerator3
            }
            return;
        }
        catch (Exception exception) {
            throw new InternalError("internal error: SeedGenerator thread generated an exception.");
        }
    }

    public static byte getByte() {
        return myself._getByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte _getByte() {
        SeedGenerator seedGenerator;
        byte by;
        block10: {
            by = 0;
            try {
                seedGenerator = this;
                synchronized (seedGenerator) {
                    while (this.count <= 0) {
                        this.wait();
                    }
                }
            }
            catch (Exception exception) {
                if (this.count > 0) break block10;
                throw new InternalError("internal error: SeedGenerator thread generated an exception.");
            }
        }
        seedGenerator = this;
        synchronized (seedGenerator) {
            by = this.pool[this.start];
            this.pool[this.start] = 0;
            ++this.start;
            --this.count;
            if (this.start == this.pool.length) {
                this.start = 0;
            }
            this.notifyAll();
        }
        return by;
    }

    static byte[] getSystemEntropy() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        byte by = (byte)System.currentTimeMillis();
        messageDigest.update(by);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                Object object2;
                try {
                    object2 = System.getProperties();
                    Enumeration<?> enumeration = ((Properties)object2).propertyNames();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        messageDigest.update(((String)object).getBytes());
                        messageDigest.update(((Properties)object2).getProperty((String)object).getBytes());
                    }
                    messageDigest.update(InetAddress.getLocalHost().toString().getBytes());
                    File file = new File(((Properties)object2).getProperty("java.io.tmpdir"));
                    String[] stringArray = file.list();
                    for (int i = 0; i < stringArray.length; ++i) {
                        messageDigest.update(stringArray[i].getBytes());
                    }
                }
                catch (Exception exception) {
                    messageDigest.update((byte)exception.hashCode());
                }
                object = Runtime.getRuntime();
                object2 = SeedGenerator.longToByteArray(((Runtime)object).totalMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                object2 = SeedGenerator.longToByteArray(((Runtime)object).freeMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                return null;
            }
        });
        return messageDigest.digest();
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    private class BogusThread
    implements Runnable {
        private BogusThread() {
        }

        public final void run() {
            try {
                for (int i = 0; i < 5; ++i) {
                    Thread.sleep(50L);
                }
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

