/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveKey;
import sun.security.action.GetIntegerAction;

public class KeepAliveCache
extends Hashtable {
    static final int LIFETIME = 5000;
    static final int PROXY_LIFETIME = 10000;

    static int getMaxConnections() {
        int n = AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 2));
        if (n <= 0) {
            return 2;
        }
        return n;
    }

    public synchronized void put(final URL uRL, HttpClient httpClient) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            clientVector = new ClientVector(this, keepAliveKey, httpClient.usingProxy ? 10000 : 5000);
            clientVector.put(httpClient);
            super.put(keepAliveKey, clientVector);
            final ClientVector clientVector2 = clientVector;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = null;
                    thread = new Thread((Runnable)clientVector2, "Keep-Alive-Timer:" + uRL.getHost());
                    thread.setDaemon(true);
                    thread.setPriority(8);
                    thread.start();
                    return null;
                }
            });
        } else {
            clientVector.put(httpClient);
        }
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public Object get(URL uRL) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

