/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.File;
import java.util.BitSet;

public class ParseUtil {
    static BitSet encodedInPath = new BitSet(256);

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String canonizeString(String string) {
        int n = 0;
        int n2 = string.length();
        while ((n = string.indexOf("/../")) >= 0) {
            n2 = string.lastIndexOf(47, n - 1);
            if (n2 >= 0) {
                string = string.substring(0, n2) + string.substring(n + 3);
                continue;
            }
            string = string.substring(n + 3);
        }
        while ((n = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while (string.endsWith("/..")) {
            n = string.indexOf("/..");
            n2 = string.lastIndexOf(47, n - 1);
            if (n2 >= 0) {
                string = string.substring(0, n2 + 1);
                continue;
            }
            string = string.substring(0, n);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String encodePath(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    ParseUtil.escape(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u07ff') {
                ParseUtil.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                ParseUtil.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                ParseUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            ParseUtil.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
            ParseUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
        }
        string = stringBuffer.toString();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && bl) {
            string = string + "/";
        }
        return string;
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c & 0xF, 16));
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
    }
}

