/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.ScopedMemory;
import javax.realtime.SizeEstimator;

public class VTMemory
extends ScopedMemory {
    long initialSize;
    long maximumSize;
    private boolean memoryInitialized = false;

    public VTMemory(long l) {
        this(l, l);
    }

    public VTMemory(long l, Runnable runnable) {
        this(l, l, runnable);
    }

    public VTMemory(SizeEstimator sizeEstimator) {
        this(sizeEstimator, sizeEstimator);
    }

    public VTMemory(SizeEstimator sizeEstimator, Runnable runnable) {
        this(sizeEstimator, sizeEstimator, runnable);
    }

    public VTMemory(long l, long l2) {
        this(l, l2, null);
    }

    public VTMemory(long l, long l2, Runnable runnable) {
        super(l, runnable);
        this.init(l, l2, runnable);
        this.memoryInitialized = true;
    }

    private void init(long l, long l2, Runnable runnable) {
        if (l > l2) {
            throw new IllegalArgumentException("Initial memory size is greater than Maximum memory size");
        }
        this.initialSize = l;
        this.maximumSize = l2;
        this.memorySize = l2;
        this.initScoped(this.memorySize);
        this.memoryInitialized = true;
    }

    public VTMemory(SizeEstimator sizeEstimator, SizeEstimator sizeEstimator2) {
        this(sizeEstimator, sizeEstimator2, null);
    }

    public VTMemory(SizeEstimator sizeEstimator, SizeEstimator sizeEstimator2, Runnable runnable) {
        super(sizeEstimator, runnable);
        if (sizeEstimator2 == null) {
            throw new IllegalArgumentException("Null maximum size");
        }
        this.init(sizeEstimator.getEstimate(), sizeEstimator2.getEstimate(), runnable);
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    void internalResize(long l, long l2) {
        super.internalResize(l, l2);
        this.maximumSize = l2;
    }

    public String toString() {
        return new String("(VTMemory) " + super.toString());
    }

    protected void finalize() throws Throwable {
        if (this.memoryInitialized) {
            super.finalize();
        }
    }
}

