/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.AsynchronouslyInterruptedException;
import javax.realtime.HighResolutionTime;
import javax.realtime.Interruptible;
import javax.realtime.OneShotTimer;
import javax.realtime.RationalTime;
import javax.realtime.RelativeTime;

public class Timed
extends AsynchronouslyInterruptedException {
    private static final long serialVersionUID = 1L;
    private Timed target;
    private OneShotTimer fireTimer;
    private AbsoluteTime aTimeout = new AbsoluteTime();
    private RelativeTime rTimeout = new RelativeTime();
    private RationalTime raTimeout = new RationalTime(1);
    private HighResolutionTime timeout = null;

    public Timed(HighResolutionTime highResolutionTime) throws IllegalArgumentException {
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("HighResolutionTime is null");
        }
        this.setTimeout(highResolutionTime);
        this.target = this;
        this.fireTimer = new OneShotTimer(highResolutionTime, null){

            Throwable internalFire(Object object, int n, boolean bl) {
                Timed.this.target.fire();
                return null;
            }
        };
        this.fireTimer.lockAsScopeDaemon(true);
    }

    private void setTimeout(HighResolutionTime highResolutionTime) {
        if (highResolutionTime instanceof RationalTime) {
            this.raTimeout.set(highResolutionTime);
            this.timeout = this.raTimeout;
        } else if (highResolutionTime instanceof RelativeTime) {
            this.rTimeout.set(highResolutionTime);
            this.timeout = this.rTimeout;
        } else {
            this.aTimeout.set(highResolutionTime);
            this.timeout = this.aTimeout;
        }
    }

    public void resetTime(HighResolutionTime highResolutionTime) {
        if (highResolutionTime != null) {
            this.setTimeout(highResolutionTime);
        }
    }

    public void restart(HighResolutionTime highResolutionTime) {
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("Null time value");
        }
        if (highResolutionTime instanceof RelativeTime && ((RelativeTime)highResolutionTime).compareToZero() < 0) {
            throw new IllegalArgumentException("Negative relative time value for time");
        }
        this.setTimeout(highResolutionTime);
        boolean bl = this.fireTimer.stop();
        if (bl) {
            this.fireTimer.reschedule(this.timeout);
            this.fireTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callRun(Interruptible interruptible) throws AsynchronouslyInterruptedException {
        this.fireTimer.reschedule(this.timeout);
        this.fireTimer.start();
        super.callRun(interruptible);
        this.fireTimer.stop();
    }
}

