/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.realtime.AbsoluteTime;
import javax.realtime.HeapMemory;
import javax.realtime.HighResolutionTime;
import javax.realtime.IllegalAssignmentError;
import javax.realtime.ImmortalMemory;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryInUseException;
import javax.realtime.PinnableRegion;
import javax.realtime.RealtimeThread;
import javax.realtime.RealtimeThreadCNI;
import javax.realtime.RecycleBin;
import javax.realtime.RelativeTime;
import javax.realtime.ScopedCycleException;
import javax.realtime.ScopedRegion;
import javax.realtime.SizeEstimator;
import javax.realtime.ThrowBoundaryError;

public abstract class ScopedMemory
extends MemoryArea
implements ScopedRegion {
    static RecycleBin bin = new RecycleBin();
    static final Class objectClass = class$java$lang$Object == null ? (class$java$lang$Object = ScopedMemory.class$("java.lang.Object")) : class$java$lang$Object;
    private Object refCountLock;
    private static long PRIMORDIAL_PARENT = -1L;
    private static long NO_PARENT = 0L;
    private long parentInfoPtr = NO_PARENT;
    private Object parentLockLock;
    private static int idTracker = 1;
    private int myID = -1;
    private Runnable attachedRunnable = null;
    private AbsoluteTime atForJoinTimeout = new AbsoluteTime();
    private AbsoluteTime currentTimeForJoin = new AbsoluteTime();
    static /* synthetic */ Class class$java$lang$Object;

    public ScopedMemory(long l) {
        this(l, null);
    }

    public ScopedMemory(long l, Runnable runnable) {
        super(l);
        if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalStateException("Scoped memory cannot be created in heap-only mode.");
        }
        this.attachedRunnable = runnable;
        this.myID = idTracker++;
        this.initLocks();
    }

    private void initLocks() {
        try {
            this.refCountLock = bin.newInstance(objectClass);
            this.parentLockLock = bin.newInstance(objectClass);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Logic error 1 in Scoped memory constructor.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Logic error 2 in Scoped memory constructor.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInitialMemoryParentLock(boolean bl) {
        Object object = this.parentLockLock;
        synchronized (object) {
            if (bl) {
                this.incParentLocks0();
            } else if (this.decParentLocks0() == 0 && this.getReferenceCount0() == 0) {
                this.clearParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setParent(long l) {
        if (l == 0L) {
            l = PRIMORDIAL_PARENT;
        }
        Object object = this.parentLockLock;
        synchronized (object) {
            if (!this.checkParent(l)) {
                return false;
            }
            this.parentInfoPtr = l;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkParent(long l) {
        if (l == 0L) {
            l = PRIMORDIAL_PARENT;
        }
        Object object = this.parentLockLock;
        synchronized (object) {
            if (this.getParentLocks0() == 0) {
                return true;
            }
            if (this.parentInfoPtr == NO_PARENT) {
                return true;
            }
            return this.parentInfoPtr == l;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearParent() {
        Object object = this.parentLockLock;
        synchronized (object) {
            if (this.getReferenceCount0() != 0) {
                throw new RuntimeException("ScopedMemory.clearParent() called with ref count == " + this.getReferenceCount0());
            }
            this.parentInfoPtr = NO_PARENT;
        }
    }

    public ScopedMemory(SizeEstimator sizeEstimator) {
        this(sizeEstimator, null);
    }

    public ScopedMemory(SizeEstimator sizeEstimator, Runnable runnable) {
        super(sizeEstimator);
        this.attachedRunnable = runnable;
        this.myID = idTracker++;
        this.initLocks();
    }

    public void enter() throws ScopedCycleException {
        this.enter(this.attachedRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Runnable runnable) throws ScopedCycleException {
        RealtimeThread realtimeThread = this.getCurrentThread();
        long l = realtimeThread.getTopScopeRef();
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable passed was null or no Runnable associated with this ScopedMemory");
        }
        if (realtimeThread.isSOExitingNow() && MemoryArea.getMemoryArea(realtimeThread) == this) {
            throw new IllegalThreadStateException("Thread is attempting to illegally re-enter its own scope.");
        }
        this.pushMemoryArea();
        if (l != 0L && this instanceof PinnableRegion) {
            this.addToChildList0(l);
        }
        try {
            this.runRunnable(runnable);
        }
        finally {
            if (l != 0L && this instanceof PinnableRegion && !this.getPinned0()) {
                this.removeFromChildList0(l);
            }
            this.popMemoryArea();
            realtimeThread.setTopScopeRef(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(Constructor constructor, Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        long l;
        long l2;
        this.checkNHRTHeapAccess();
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor object passed is null");
        }
        Object var3_3 = null;
        ScopedMemory scopedMemory = this;
        synchronized (scopedMemory) {
            l2 = this.executeInAreaBeginWrapper();
            l = this.getSavedParent();
        }
        try {
            var3_3 = constructor.newInstance(objectArray);
        }
        finally {
            MemoryArea.executeInAreaEndWrapper(l2, l);
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pushMemoryArea() {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        if (realtimeThread.isScopeDaemon() && this != realtimeThread.internalGetMemoryArea()) {
            System.err.println("Scoped daemon thread entering a scope other than its init memory");
            throw new RuntimeException("Scoped daemon thread entering a scope other than its init memory");
        }
        ScopedMemory scopedMemory = this;
        synchronized (scopedMemory) {
            if (!this.checkParent(realtimeThread.getTopScopeRef())) {
                throw new ScopedCycleException("Attempt to enter scope " + this + " which has a parent because it's a pending initial memory area.");
            }
            this.innerpushMemoryArea(realtimeThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerpushMemoryArea(RealtimeThread realtimeThread) {
        if (realtimeThread.internalGetMemoryArea() == this) {
            realtimeThread.maskTimers(false);
        }
        Object object = this.refCountLock;
        synchronized (object) {
            RealtimeThreadCNI.pushScopedMemoryArea(this, this.getReferenceCount0());
            realtimeThread.setTopScopeRef(this.getNativeInfoRef());
            this.incrementReferenceCount();
        }
    }

    final void popMemoryArea() {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        if (realtimeThread.internalGetMemoryArea() == this) {
            realtimeThread.maskTimers(true);
        }
        this.decrementReferenceCount(realtimeThread.isScopeDaemonInThisScope(this));
        RealtimeThreadCNI.popScopedMemoryArea(this.getReferenceCount0());
    }

    private void runFinalizersIfNecessary(boolean bl, int n) {
        boolean bl2;
        int n2;
        int n3 = this.getReferenceCount0() - n;
        if (ScopedMemory.readyToClear(n3, n2 = bl ? this.getReferenceCountDaemon0() - n : this.getReferenceCountDaemon0(), bl2 = this.getPinned0())) {
            if (this.testAndSetFinalizingFlag0(true)) {
                return;
            }
            do {
                if (this.runAllFinalizers()) {
                    n3 = this.getReferenceCount0() - n;
                    if (!ScopedMemory.readyToClear(n3, n2 = bl ? this.getReferenceCountDaemon0() - n : this.getReferenceCountDaemon0(), bl2 = this.getPinned0())) break;
                    boolean bl3 = this.runAEShutdowns0();
                    n3 = this.getReferenceCount0() - n;
                    n2 = bl ? this.getReferenceCountDaemon0() - n : this.getReferenceCountDaemon0();
                    bl2 = this.getPinned0();
                    if (!bl3) continue;
                    if (!ScopedMemory.readyToClear(n3, n2, bl2)) break;
                    boolean bl4 = this.runAEShutdowns0();
                    if (!bl4) {
                        System.err.println("Logic error 1 in ScopedMemory.runFinalizersIfNecessary()");
                        continue;
                    }
                    this.runEeShutdowns0();
                    this.runAllFinalizers();
                    break;
                }
                n3 = this.getReferenceCount0() - n;
                n2 = bl ? this.getReferenceCountDaemon0() - n : this.getReferenceCountDaemon0();
                bl2 = this.getPinned0();
            } while (ScopedMemory.readyToClear(n3, n2, bl2));
            this.testAndSetFinalizingFlag0(false);
        }
    }

    static boolean readyToClear(int n, int n2, boolean bl) {
        if (bl) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        return n == n2;
    }

    private void runRunnable(Runnable runnable) {
        block10: {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                MemoryArea memoryArea = MemoryArea.getMemoryArea(throwable);
                if (memoryArea.equals(this)) {
                    System.err.println("Trying to propagate the following exception beyond my scope. The VM will now throw a ThrowBoundaryError");
                    throwable.printStackTrace();
                    ThrowBoundaryError throwBoundaryError = null;
                    try {
                        throwBoundaryError = (ThrowBoundaryError)ImmortalMemory.instance().newInstance(Class.forName("javax.realtime.ThrowBoundaryError"));
                        throwBoundaryError.setMessage(throwable.toString().intern());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("ThrowBoundaryError class not found");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("IllegalAccessException while trying to throw ThrowBoundaryError");
                    }
                    catch (InstantiationException instantiationException) {
                        System.err.println("InstantiationException while trying to throw ThrowBoundaryError");
                    }
                    if (throwBoundaryError != null) {
                        throw throwBoundaryError;
                    }
                    throw new OutOfMemoryError();
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof Error)) break block10;
                throw (Error)throwable;
            }
        }
    }

    public long getMaximumSize() {
        return this.memorySize;
    }

    public synchronized Object getPortal() {
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("getPortal may not be called from a java.lang.Thread");
        }
        Object object = this.getPortal0();
        for (int i = 0; i < RealtimeThread.getMemoryAreaStackDepth(); ++i) {
            if (RealtimeThread.getOuterMemoryArea(i) != this) continue;
            return object;
        }
        throw new IllegalAssignmentError("Target scope is not on the caller's scope stack.");
    }

    public synchronized void setPortal(Object object) {
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("setPortal() may not be invoked from a java.lang.Thread");
        }
        if (object == null) {
            return;
        }
        if (!MemoryArea.getMemoryArea(object).equals(this)) {
            throw new IllegalAssignmentError("Portal object not allocated in this ScopedMemory");
        }
        this.setPortal0(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            this.incReferenceCount0();
            if (this.getReferenceCount0() == 1 && !this.getPinned0()) {
                this.reclaimMemoryAllocated();
            }
        }
    }

    final void residentChangedScopeDaemonState(boolean bl) {
        if (bl) {
            this.incReferenceCountDaemon0();
            this.runFinalizersIfNecessary(false, 0);
        } else {
            if (this.getReferenceCount0() <= this.getReferenceCountDaemon0()) {
                throw new RuntimeException("Attempting to make more SD members than total members");
            }
            this.decReferenceCountDaemon0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementReferenceCount(boolean bl) {
        if (this.getReferenceCount0() <= 0) {
            throw new RuntimeException("scoped memory decrementRef count called with ref count <= 0");
        }
        if (!bl) {
            this.runFinalizersIfNecessary(bl, 1);
        }
        Object object = this.refCountLock;
        synchronized (object) {
            this.decReferenceCount0();
            if (this.getReferenceCount0() == 0 && !this.getPinned0()) {
                this.refCountLock.notifyAll();
            }
        }
    }

    public void executeInArea(Runnable runnable) throws InaccessibleAreaException {
        if (!(Thread.currentThread() instanceof RealtimeThread)) {
            throw new IllegalStateException("MemoryArea.executeInArea() should be called from a RealtimeThread");
        }
        super.executeInArea(runnable);
    }

    public int getReferenceCount() {
        return this.getReferenceCount0();
    }

    final int getNonDaemonRefCount() {
        return this.getReferenceCount0() - this.getReferenceCountDaemon0();
    }

    public String toString() {
        return "ScopedMemory#" + this.myID;
    }

    public void join(HighResolutionTime highResolutionTime) throws InterruptedException {
        this.joinPinned(true, highResolutionTime);
    }

    final void joinPinned(boolean bl) throws InterruptedException {
        this.joinPinned(bl, RelativeTime.zero);
    }

    final void joinPinned(boolean bl, HighResolutionTime highResolutionTime) throws InterruptedException {
        if (!(this.getCurrentThread() instanceof RealtimeThread)) {
            throw new IllegalThreadStateException("join may only be used by Schedulable Objects");
        }
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("The HighResolutionTime parameter passed was null");
        }
        this.timedJoinInternals(bl, highResolutionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timedJoinInternals(boolean bl, HighResolutionTime highResolutionTime) throws InterruptedException {
        if (highResolutionTime.getMilliseconds() == 0L && highResolutionTime.getNanoseconds() == 0) {
            Object object = this.refCountLock;
            synchronized (object) {
                while (this.getReferenceCount0() > 0 || bl && this.getPinned0()) {
                    HighResolutionTime.waitForObject(this.refCountLock, highResolutionTime);
                }
            }
        }
        highResolutionTime.absolute(highResolutionTime.getClock(), this.atForJoinTimeout);
        Object object = this.refCountLock;
        synchronized (object) {
            while (this.getReferenceCount0() > 0 || bl && this.getPinned0()) {
                highResolutionTime.getClock().getTime(this.currentTimeForJoin);
                if (this.currentTimeForJoin.compareTo(this.atForJoinTimeout) > 0) break;
                HighResolutionTime.waitForObject(this.refCountLock, highResolutionTime);
            }
        }
    }

    final void joinPinnedAndEnter(boolean bl, Runnable runnable) throws InterruptedException, ScopedCycleException {
        this.joinPinnedAndEnter(bl, runnable, RelativeTime.zero);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void joinPinnedAndEnter(boolean bl, Runnable runnable, HighResolutionTime highResolutionTime) throws InterruptedException, ScopedCycleException {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable passed was null or no Runnable associated with this ScopedMemory");
        }
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("The HighResolutionTime parameter passed was null");
        }
        RealtimeThread realtimeThread = this.getCurrentThread();
        long l = realtimeThread.getTopScopeRef();
        Object object = this.refCountLock;
        synchronized (object) {
            this.timedJoinInternals(bl, highResolutionTime);
            this.pushMemoryArea();
        }
        try {
            this.runRunnable(runnable);
        }
        finally {
            this.popMemoryArea();
            realtimeThread.setTopScopeRef(l);
        }
    }

    public void join() throws InterruptedException {
        this.join(RelativeTime.zero);
    }

    public void joinAndEnter() throws InterruptedException {
        this.joinAndEnter(this.attachedRunnable);
    }

    public void joinAndEnter(HighResolutionTime highResolutionTime) throws InterruptedException, ScopedCycleException {
        this.joinAndEnter(this.attachedRunnable, highResolutionTime);
    }

    public void joinAndEnter(Runnable runnable) throws InterruptedException {
        this.joinAndEnter(runnable, new RelativeTime(0L, 0));
    }

    public void resize(long l, long l2) {
        this.internalResize(l, l2);
    }

    public void resize(long l) {
        this.internalResize(l, l);
    }

    void internalResize(long l, long l2) {
        if (this.getReferenceCount0() > 0) {
            throw new MemoryInUseException("Cannot resize a scope that's in use");
        }
        if (this.getPinned0()) {
            throw new MemoryInUseException("Cannot resize a pinned scope");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Cannot resize a scope to a size < 0");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Cannot resize a scope to a maxSize < 0");
        }
        if (l2 < l) {
            throw new IllegalArgumentException("Cannot resize a scope to a maxSize < size");
        }
        this.resize0(l2);
        this.setSizeField(l2);
    }

    public ScopedRegion getParent() {
        if (this.getReferenceCount0() == 0 && !this.getPinned0()) {
            return null;
        }
        return this.getParent0();
    }

    public void joinAndEnter(Runnable runnable, HighResolutionTime highResolutionTime) throws InterruptedException, ScopedCycleException {
        this.joinPinnedAndEnter(true, runnable, highResolutionTime);
    }

    void pin() {
        if (RealtimeThread.getCurrentMemoryArea() != this) {
            throw new InaccessibleAreaException("Attempt to pin a scope that is not the current memory area");
        }
        this.setPinned0(true);
    }

    void unpin() {
        this.internalUnpin();
    }

    final void internalUnpin() {
        if (RealtimeThread.getCurrentMemoryArea() != this) {
            throw new InaccessibleAreaException("Attempt to unpin a scope that is not the current memory area");
        }
        this.setPinned0(false);
        this.runFinalizersIfNecessary(false, 0);
    }

    boolean isPinned() {
        return this.getPinned0();
    }

    final long executeInAreaBeginWrapper() {
        long l;
        Thread thread = Thread.currentThread();
        if (thread instanceof RealtimeThread) {
            RealtimeThread realtimeThread = (RealtimeThread)thread;
            this.setSavedParent(realtimeThread.getTopScopeRef());
            l = MemoryArea.executeInAreaBegin(this);
            realtimeThread.setTopScopeRef(this.getNativeInfoRef());
        } else {
            l = MemoryArea.executeInAreaBegin(this);
        }
        return l;
    }

    final boolean reachableMemory() {
        Thread thread = Thread.currentThread();
        if (thread instanceof RealtimeThread) {
            return ((RealtimeThread)thread).memoryAreaOnStack(this);
        }
        return false;
    }

    private RealtimeThread getCurrentThread() {
        Thread thread = Thread.currentThread();
        if (thread instanceof RealtimeThread) {
            return (RealtimeThread)thread;
        }
        throw new IllegalThreadStateException("Current thread is not a RealtimeThread");
    }

    void initScoped(long l) {
        this.initScoped0(l, this.refCountLock, this.parentLockLock);
    }

    private native void initScoped0(long var1, Object var3, Object var4);

    private native void reclaimMemoryAllocated();

    private native Object getPortal0();

    private native void setPortal0(Object var1);

    private native int getReferenceCount0();

    private native int getReferenceCountDaemon0();

    private native int incReferenceCount0();

    private native int decReferenceCount0();

    private native int incReferenceCountDaemon0();

    private native int decReferenceCountDaemon0();

    private native int getParentLocks0();

    private native int decParentLocks0();

    private native int incParentLocks0();

    private native boolean getPinned0();

    private native void setPinned0(boolean var1);

    private native boolean testAndSetFinalizingFlag0(boolean var1);

    private native void addToChildList0(long var1);

    private native void removeFromChildList0(long var1);

    private native void resize0(long var1);

    private native ScopedMemory getParent0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.getReferenceCount0() > 0) {
            System.err.println("PANIC: My reference count is " + this.getReferenceCount0() + " " + this.getReferenceCountDaemon0() + " and finalize has been called: " + this + " in " + MemoryArea.getMemoryArea(this));
            throw new RuntimeException("PANIC: My reference count is " + this.getReferenceCount0() + " " + this.getReferenceCountDaemon0() + " and finalize has been called: " + this);
        }
        if (MemoryArea.getMemoryArea(this) instanceof HeapMemory) {
            Object object = this.refCountLock;
            synchronized (object) {
                this.setPinned0(false);
                this.reclaimMemoryAllocated();
            }
            this.freeRefcountLock();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (this.getReferenceCount0() > 0) {
            System.err.println("PANIC: My reference count is " + this.getReferenceCount0() + " " + this.getReferenceCountDaemon0() + " and shutdown has been called: " + this + " in " + MemoryArea.getMemoryArea(this));
            throw new RuntimeException("PANIC: My reference count is " + this.getReferenceCount0() + " " + this.getReferenceCountDaemon0() + " and shutdown has been called: " + this);
        }
        if (this.getPinned0()) {
            RealtimeThread realtimeThread = this.getCurrentThread();
            long l = realtimeThread.getTopScopeRef();
            this.innerpushMemoryArea(realtimeThread);
            this.internalUnpin();
            this.popMemoryArea();
            realtimeThread.setTopScopeRef(l);
        } else {
            Object object = this.refCountLock;
            synchronized (object) {
                this.reclaimMemoryAllocated();
            }
            this.freeRefcountLock();
        }
    }

    private void freeRefcountLock() {
        if (this.refCountLock != null) {
            bin.recycleObject(this.refCountLock);
            this.refCountLock = null;
        }
    }

    String getStatus() {
        return "Ref count " + this.getReferenceCount0() + " daemon ref count " + this.getReferenceCountDaemon0();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

