/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.timesys.HighPriorityScheduler;
import javax.realtime.AperiodicParameters;
import javax.realtime.AsyncEventHandler;
import javax.realtime.MemoryParameters;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityParameters;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.Schedulable;
import javax.realtime.Scheduler;
import javax.realtime.SchedulingParameters;

public class PriorityScheduler
extends Scheduler {
    public static final int MIN_PRIORITY = 11;
    public static final int MAX_PRIORITY = HighPriorityScheduler.getMaxRtPriority();
    static String policyName = new String("Fixed Priority");
    static PriorityScheduler defaultPrioScheduler = PriorityScheduler.instance();
    private int heapPriorityThreshold = 0;
    private static PriorityParameters maxHeapPP = new PriorityParameters(MIN_PRIORITY);
    private static RelativeTime defaultCost = new RelativeTime(0L, 0);
    private static RelativeTime defaultDeadline = new RelativeTime(Long.MAX_VALUE, 999999);
    private static Class defaultRPClass = class$javax$realtime$AperiodicParameters == null ? (class$javax$realtime$AperiodicParameters = PriorityScheduler.class$("javax.realtime.AperiodicParameters")) : class$javax$realtime$AperiodicParameters;
    static /* synthetic */ Class class$javax$realtime$AperiodicParameters;

    protected PriorityScheduler() {
    }

    boolean validParameters(SchedulingParameters schedulingParameters) {
        if (schedulingParameters instanceof PriorityParameters) {
            int n = ((PriorityParameters)schedulingParameters).getPriority();
            return this.validPriority(n);
        }
        return false;
    }

    boolean validPriority(int n) {
        return n >= this.getMinPriority() && n <= this.getMaxPriority();
    }

    boolean validParameters(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        boolean bl = true;
        boolean bl2 = true;
        if (releaseParameters == null) {
            bl = true;
        } else if (releaseParameters.getCostMillis() < 0L || releaseParameters.getCostNanos() < 0) {
            bl = false;
        } else if (releaseParameters.getDeadlineMillis() < 0L || releaseParameters.getDeadlineNanos() < 0 || releaseParameters.getDeadlineMillis() == 0L && releaseParameters.getDeadlineNanos() == 0) {
            bl = false;
        } else if (releaseParameters instanceof PeriodicParameters) {
            PeriodicParameters periodicParameters = (PeriodicParameters)releaseParameters;
            if (periodicParameters.getPeriodMillis() < 0L || periodicParameters.getPeriodNanos() < 0 || periodicParameters.getPeriodMillis() == 0L && periodicParameters.getPeriodNanos() == 0) {
                bl = false;
            }
            if (periodicParameters.getPeriodMillis() < periodicParameters.getDeadlineMillis() || periodicParameters.getPeriodMillis() == periodicParameters.getDeadlineMillis() && periodicParameters.getPeriodNanos() < periodicParameters.getDeadlineNanos()) {
                bl = false;
            }
        } else {
            bl = true;
        }
        if (processingGroupParameters == null) {
            bl2 = true;
        } else {
            try {
                if (processingGroupParameters.getCostMillis() < 0L || processingGroupParameters.getCostNanos() < 0 || processingGroupParameters.getCostMillis() == 0L && processingGroupParameters.getCostNanos() == 0) {
                    bl2 = false;
                } else if (processingGroupParameters.getDeadlineMillis() < 0L || processingGroupParameters.getDeadlineNanos() < 0 || processingGroupParameters.getDeadlineMillis() == 0L && processingGroupParameters.getDeadlineNanos() == 0) {
                    bl2 = false;
                } else if (processingGroupParameters.getPeriodMillis() < 0L || processingGroupParameters.getPeriodNanos() < 0 || processingGroupParameters.getPeriodMillis() == 0L && processingGroupParameters.getPeriodNanos() == 0) {
                    bl2 = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl && bl2;
    }

    boolean validParameters(ReleaseParameters releaseParameters) {
        return this.validParameters(releaseParameters, null);
    }

    public boolean isFeasible() {
        return this.getLoad() <= 1.0f;
    }

    public static PriorityScheduler instance() {
        if (defaultPrioScheduler == null) {
            defaultPrioScheduler = new PriorityScheduler();
        }
        return defaultPrioScheduler;
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.internalSetIfFeasible(schedulable, releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(Schedulable schedulable, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.internalSetIfFeasible(schedulable, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(Schedulable schedulable, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.internalSetIfFeasible(schedulable, schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    protected boolean addToFeasibility(Schedulable schedulable) {
        return this.internalAddToFeasibility(schedulable);
    }

    protected boolean removeFromFeasibility(Schedulable schedulable) {
        return this.internalRemoveFromFeasibility(schedulable);
    }

    public void fireSchedulable(Schedulable schedulable) {
        throw new UnsupportedOperationException("The PriorityScheduler does not support fireSchedulable()");
    }

    public int getMaxPriority() {
        return MAX_PRIORITY;
    }

    public static int getMaxPriority(Thread thread) {
        if (thread == null) {
            return MAX_PRIORITY;
        }
        if (thread instanceof RealtimeThread) {
            RealtimeThread realtimeThread = (RealtimeThread)thread;
            Scheduler scheduler = realtimeThread.getScheduler();
            if (scheduler instanceof PriorityScheduler) {
                return ((PriorityScheduler)scheduler).getMaxPriority();
            }
            throw new IllegalArgumentException("Thread is not scheduled by PriorityScheduler");
        }
        return thread.getThreadGroup().getMaxPriority();
    }

    public int getMinPriority() {
        return MIN_PRIORITY;
    }

    public static int getMinPriority(Thread thread) {
        if (thread == null) {
            return MIN_PRIORITY;
        }
        if (thread instanceof RealtimeThread) {
            RealtimeThread realtimeThread = (RealtimeThread)thread;
            Scheduler scheduler = realtimeThread.getScheduler();
            if (scheduler instanceof PriorityScheduler) {
                return ((PriorityScheduler)scheduler).getMinPriority();
            }
            throw new IllegalArgumentException("Thread is not scheduled by PriorityScheduler");
        }
        return 1;
    }

    public int getNormPriority() {
        return (this.getMaxPriority() - this.getMinPriority()) / 3 + this.getMinPriority();
    }

    SchedulingParameters getDefaultSchedulingParameters() {
        return new PriorityParameters(this.getNormPriority());
    }

    ReleaseParameters getDefaultReleaseParameters() {
        return new AperiodicParameters(new RelativeTime(0L, 0), new RelativeTime(Long.MAX_VALUE, 999999), null, null);
    }

    public static int getNormPriority(Thread thread) {
        if (thread == null || thread instanceof RealtimeThread) {
            return (PriorityScheduler.getMaxPriority(thread) - PriorityScheduler.getMinPriority(thread)) / 3 + PriorityScheduler.getMinPriority(thread);
        }
        return 5;
    }

    public String getPolicyName() {
        return new String("Fixed Priority");
    }

    static RelativeTime getDefaultCost() {
        return defaultCost;
    }

    static RelativeTime getDefaultDeadline() {
        return defaultDeadline;
    }

    static AsyncEventHandler getDefaultMissHandler() {
        return null;
    }

    static AsyncEventHandler getDefaultOverrunHandler() {
        return null;
    }

    static Class getDefaultReleaseParametersClass() {
        return defaultRPClass;
    }

    static int priorityToRTPriority(int n) {
        return n - PriorityScheduler.instance().getMinPriority() + 1;
    }

    void updateHeapSOThreshold(int n) {
        if (n + 1 > this.heapPriorityThreshold && n < MAX_PRIORITY) {
            this.heapPriorityThreshold = n + 1;
            maxHeapPP.setPriority(this.heapPriorityThreshold);
        }
    }

    void updateNoHeapSOThreshold(int n) {
        if (n < this.heapPriorityThreshold) {
            // empty if block
        }
    }

    int getHeapPriorityThreshold() {
        return this.heapPriorityThreshold;
    }

    static PriorityParameters getMaxHeapPriorityParameters() {
        return maxHeapPP;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

