/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.DuplicateFilterException;
import javax.realtime.ImmortalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryInUseException;
import javax.realtime.MemoryTypeConflictException;
import javax.realtime.OffsetOutOfBoundsException;
import javax.realtime.PhysicalMemoryName;
import javax.realtime.PhysicalMemoryNameType;
import javax.realtime.PhysicalMemoryTypeFilter;
import javax.realtime.RealtimeSystem;
import javax.realtime.ResourceLimitError;
import javax.realtime.SizeOutOfBoundsException;
import javax.realtime.UnsupportedPhysicalMemoryException;

public final class PhysicalMemoryManager {
    private static long pagesize;
    private static Filter[] filterArray;
    private static Filter[] filterSubset;
    private static Object defaultType;
    private static AddressList addrInUse;
    private static Object addrLock;
    public static final PhysicalMemoryName DMA;
    public static final PhysicalMemoryName SHARED;
    public static final PhysicalMemoryName ALIGNED;
    public static final PhysicalMemoryName BYTESWAP;
    public static final PhysicalMemoryName IO_PAGE;
    public static final PhysicalMemoryName DEVICE;
    static final int PROT_READ = 1;
    static final int PROT_WRITE = 2;
    static final int PROT_EXEC = 4;
    static final int PROT_NONE = 0;
    static final int MAP_SHARED = 1;
    static final int MAP_PRIVATE = 2;
    static final int MAP_FIXED = 16;

    private PhysicalMemoryManager() {
    }

    private static void checkParameters(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (l2 < 0L) {
            throw new SizeOutOfBoundsException("size < 0");
        }
        if (l < 0L) {
            throw new OffsetOutOfBoundsException();
        }
        if (l > 0xFFFFFFFFL || l2 > 0xFFFFFFFFL || l + l2 > 0xFFFFFFFFL) {
            throw new SizeOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized long create(Object object, long l, long l2) throws MemoryTypeConflictException, MemoryInUseException, OffsetOutOfBoundsException, SizeOutOfBoundsException, UnsupportedPhysicalMemoryException {
        long l3 = -1L;
        boolean bl = false;
        if (l == 0L) {
            return PhysicalMemoryManager.create(object, l2);
        }
        RealtimeSystem.getSecurityManager().checkAccessPhysicalRange(l, l2);
        PhysicalMemoryManager.checkParameters(l, l2);
        PhysicalMemoryManager.addrCheckIfInUse(l, l2);
        if (object == null || object instanceof Object[] && ((Object[])object).length == 0) {
            object = defaultType;
            bl = true;
        }
        Filter[] filterArray = filterSubset;
        synchronized (filterSubset) {
            long l4;
            PhysicalMemoryTypeFilter physicalMemoryTypeFilter;
            int n;
            PhysicalMemoryManager.updateFilterSubset(object);
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            for (n = 0; n < filterSubset.length; ++n) {
                if (filterSubset[n].isEmpty()) continue;
                physicalMemoryTypeFilter = PhysicalMemoryManager.filterSubset[n].filter;
                l4 = physicalMemoryTypeFilter.find(l, l2);
                if (l4 == l) {
                    n2 |= physicalMemoryTypeFilter.getVMAttributes();
                    n3 |= physicalMemoryTypeFilter.getVMFlags();
                    bl2 = true;
                    continue;
                }
                if (bl) continue;
                throw new MemoryTypeConflictException("Requested base/size pair cannot be the given type. Nearest possible match to requested address, " + l + " is " + l4);
            }
            if (bl && !bl2) {
                throw new OutOfMemoryError("No free memory can be found at the requested address");
            }
            l3 = PhysicalMemoryManager.mmap(l, l2, n2, n3);
            for (n = 0; n < filterSubset.length; ++n) {
                if (filterSubset[n].isEmpty() || (l4 = (physicalMemoryTypeFilter = PhysicalMemoryManager.filterSubset[n].filter).vFind(l3, l2)) == l3) continue;
                PhysicalMemoryManager.unmap(l3, l2);
                throw new MemoryTypeConflictException("Requested base/size pair cannot be the given type (Virtual address failed)");
            }
            PhysicalMemoryManager.addrAddToList(l, l2, l3, n2, n3);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            return l3;
        }
    }

    private static void markReferencedFilters(Filter filter, Filter[] filterArray) {
        int n = PhysicalMemoryManager.findFilterIndex(filter);
        filterArray[n].copy(filter);
        if (filter.composedFilter != null) {
            PhysicalMemoryManager.markReferencedFilters(filter.composedFilter, filterArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized long create(Object object, long l) throws MemoryTypeConflictException, OffsetOutOfBoundsException, SizeOutOfBoundsException {
        boolean bl = false;
        PhysicalMemoryManager.checkParameters(0L, l);
        RealtimeSystem.getSecurityManager().checkAccessPhysical();
        long l2 = -1L;
        if (object == null || object instanceof Object[] && ((Object[])object).length == 0) {
            object = defaultType;
            bl = true;
        }
        Filter[] filterArray = filterSubset;
        synchronized (filterSubset) {
            PhysicalMemoryTypeFilter physicalMemoryTypeFilter;
            int n;
            long l3;
            int n2;
            boolean bl2;
            int n3;
            int n4;
            block22: {
                PhysicalMemoryManager.updateFilterSubset(object);
                n4 = 0;
                n3 = 0;
                bl2 = false;
                n2 = filterSubset.length;
                l3 = -1L;
                if (bl) {
                    for (n = 0; n < n2; ++n) {
                        if (filterSubset[n].isEmpty()) continue;
                        physicalMemoryTypeFilter = PhysicalMemoryManager.filterSubset[n].filter;
                        if ((l3 = PhysicalMemoryManager.findFreeSlot(physicalMemoryTypeFilter, l, l3 == -1L ? 0L : l3)) == -1L) continue;
                        n4 = physicalMemoryTypeFilter.getVMAttributes();
                        n3 = physicalMemoryTypeFilter.getVMFlags();
                        bl2 = true;
                        break;
                    }
                } else {
                    for (n = 0; n < n2; ++n) {
                        if (filterSubset[n].isEmpty()) {
                            continue;
                        }
                        physicalMemoryTypeFilter = PhysicalMemoryManager.filterSubset[n].filter;
                        do {
                            if ((l3 = PhysicalMemoryManager.findFreeSlot(physicalMemoryTypeFilter, l, l3 == -1L ? 0L : l3)) == -1L) {
                                bl2 = false;
                            } else {
                                int n5;
                                n4 = physicalMemoryTypeFilter.getVMAttributes();
                                n3 = physicalMemoryTypeFilter.getVMFlags();
                                for (n5 = n + 1; n5 < filterSubset.length; ++n5) {
                                    if (filterSubset[n5].isEmpty()) continue;
                                    PhysicalMemoryTypeFilter physicalMemoryTypeFilter2 = PhysicalMemoryManager.filterSubset[n5].filter;
                                    long l4 = physicalMemoryTypeFilter2.find(l3, l);
                                    if (l4 != l3) {
                                        l3 = l4;
                                        break;
                                    }
                                    n4 |= physicalMemoryTypeFilter2.getVMAttributes();
                                    n3 |= physicalMemoryTypeFilter2.getVMFlags();
                                }
                                if (n5 != filterSubset.length) continue;
                                bl2 = true;
                            }
                            break block22;
                        } while (l3 != -1L);
                    }
                }
            }
            if (!bl2) {
                if (bl) {
                    throw new OutOfMemoryError(l + " bytes of free memory cannot be found");
                }
                throw new MemoryTypeConflictException("Requested memory cannot be the given type (Physical address failed)");
            }
            l2 = PhysicalMemoryManager.mmap(l3, l, n4, n3);
            if (bl) {
                physicalMemoryTypeFilter = PhysicalMemoryManager.filterSubset[n].filter;
                long l5 = physicalMemoryTypeFilter.vFind(l2, l);
                if (l5 != l2) {
                    PhysicalMemoryManager.unmap(l2, l);
                    throw new MemoryTypeConflictException("Requested memory cannot be the given type (Virtual address failed)");
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    PhysicalMemoryTypeFilter physicalMemoryTypeFilter3;
                    long l6;
                    if (filterSubset[i].isEmpty() || (l6 = (physicalMemoryTypeFilter3 = PhysicalMemoryManager.filterSubset[i].filter).vFind(l2, l)) == l2) continue;
                    PhysicalMemoryManager.unmap(l2, l);
                    throw new MemoryTypeConflictException("Requested memory cannot be the given type (Virtual address failed)");
                }
            }
            try {
                RealtimeSystem.getSecurityManager().checkAccessPhysicalRange(l3, l);
            }
            catch (SecurityException securityException) {
                PhysicalMemoryManager.unmap(l2, l);
                throw securityException;
            }
            PhysicalMemoryManager.addrAddToList(l3, l, l2, n4, n3);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return l2;
        }
    }

    private static void updateFilterSubset(Object object) {
        if (object == defaultType) {
            for (int i = 0; i < filterArray.length; ++i) {
                filterSubset[i].copy(filterArray[i]);
            }
        } else {
            int n;
            for (n = 0; n < filterSubset.length; ++n) {
                filterSubset[n].empty();
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    Filter filter = PhysicalMemoryManager.findFilterEntry(objectArray[n]);
                    if (filter == null) {
                        throw new UnsupportedPhysicalMemoryException("Requested type of memory, " + objectArray[n] + ", could not be found");
                    }
                    PhysicalMemoryManager.markReferencedFilters(filter, filterSubset);
                }
            } else {
                Filter filter = PhysicalMemoryManager.findFilterEntry(object);
                if (filter == null) {
                    throw new UnsupportedPhysicalMemoryException("Requested type of memory, " + object + ", could not be found");
                }
                PhysicalMemoryManager.markReferencedFilters(filter, filterSubset);
            }
        }
    }

    static long getPhysical(long l) {
        PhysicalMemoryManager.checkParameters(l, 0L);
        if (addrInUse == null) {
            throw new IllegalArgumentException("No corresponding physical address -- no mappings are known to the physical memory mapper.");
        }
        AddressList addressList = addrInUse;
        while (addressList != null) {
            long l2;
            if (addressList.virtualAddress == l) {
                return addressList.base;
            }
            if (addressList.virtualAddress <= l && (l2 = l - addressList.virtualAddress) <= addressList.size) {
                return addressList.base + l2;
            }
            addressList = addressList.next;
        }
        throw new IllegalArgumentException("The virtual address does not correspond to a mapped address");
    }

    static void free(long l, long l2) {
        Object object = addrLock;
        synchronized (object) {
            if (PhysicalMemoryManager.addrInUse.virtualAddress == l) {
                PhysicalMemoryManager.unmap(PhysicalMemoryManager.addrInUse.virtualAddress, PhysicalMemoryManager.addrInUse.size);
                addrInUse = PhysicalMemoryManager.addrInUse.next;
                return;
            }
            AddressList addressList = addrInUse;
            AddressList addressList2 = PhysicalMemoryManager.addrInUse.next;
            while (addressList2 != null) {
                if (addressList2.virtualAddress == l) {
                    PhysicalMemoryManager.unmap(addressList2.virtualAddress, addressList2.size);
                    addressList.next = addressList2.next;
                    return;
                }
                addressList = addressList2;
                addressList2 = addressList2.next;
            }
            throw new RuntimeException("Unable to remove base/size node from list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void temporaryUnmap(long l) {
        AddressList addressList = null;
        Object object = addrLock;
        synchronized (object) {
            AddressList addressList2 = addrInUse;
            while (addressList2 != null) {
                if (addressList2.base == l) {
                    addressList = addressList2;
                    break;
                }
                addressList2 = addressList2.next;
            }
            if (addressList == null) {
                throw new RuntimeException("Attempting to unmap an address that was not mapped");
            }
            PhysicalMemoryManager.unmap(addressList.virtualAddress, addressList.size);
        }
    }

    static long remap(long l, long l2, long l3) {
        AddressList addressList = null;
        Object object = addrLock;
        synchronized (object) {
            if (addrInUse == null) {
                throw new RuntimeException("Attempting to remap an unknown address");
            }
            if (PhysicalMemoryManager.addrInUse.base == l) {
                addressList = addrInUse;
                addrInUse = PhysicalMemoryManager.addrInUse.next;
            } else {
                AddressList addressList2 = addrInUse;
                AddressList addressList3 = PhysicalMemoryManager.addrInUse.next;
                while (addressList3 != null) {
                    if (addressList3.base == l) {
                        addressList = addressList3;
                        addressList2.next = addressList.next;
                        break;
                    }
                    addressList2 = addressList3;
                    addressList3 = addressList3.next;
                }
            }
            if (addressList != null) {
                long l4;
                addressList.virtualAddress = l4 = PhysicalMemoryManager.mmap(l, l2, l3, addressList.protection, addressList.flags);
                PhysicalMemoryManager.addrAddToList(addressList);
                return l4;
            }
            throw new RuntimeException("Attempting to remap an unknown address");
        }
    }

    public static final void registerFilter(PhysicalMemoryName physicalMemoryName, PhysicalMemoryTypeFilter physicalMemoryTypeFilter) throws DuplicateFilterException, IllegalArgumentException {
        RealtimeSystem.getSecurityManager().checkSetFilter();
        PhysicalMemoryManager.registerFilter((Object)physicalMemoryName, physicalMemoryTypeFilter);
    }

    public static final void registerFilter(PhysicalMemoryName physicalMemoryName, PhysicalMemoryName physicalMemoryName2, PhysicalMemoryTypeFilter physicalMemoryTypeFilter) throws DuplicateFilterException {
        Filter filter;
        PhysicalMemoryManager.checkArgs(physicalMemoryName, physicalMemoryTypeFilter);
        if (physicalMemoryName2 == null) {
            throw new IllegalArgumentException("Component name is null");
        }
        RealtimeSystem.getSecurityManager().checkSetFilter();
        if (PhysicalMemoryManager.findFilter(physicalMemoryName2) == null) {
            throw new IllegalArgumentException("componentName is not a registered filter");
        }
        Filter filter2 = PhysicalMemoryManager.addFilter(physicalMemoryName, physicalMemoryTypeFilter);
        filter2.composedFilter = filter = PhysicalMemoryManager.dupFilter(physicalMemoryName2, filter2);
    }

    public static void registerFilter(PhysicalMemoryName physicalMemoryName, PhysicalMemoryName physicalMemoryName2, PhysicalMemoryTypeFilter physicalMemoryTypeFilter, PhysicalMemoryTypeFilter physicalMemoryTypeFilter2) throws DuplicateFilterException {
        PhysicalMemoryManager.checkArgs(physicalMemoryName, physicalMemoryTypeFilter);
        if (physicalMemoryTypeFilter2 == null) {
            throw new IllegalArgumentException("filterTwo is null");
        }
        if (!(MemoryArea.getMemoryArea(physicalMemoryTypeFilter2) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("filterTwo is not in immortal memory");
        }
        if (physicalMemoryTypeFilter == physicalMemoryTypeFilter2) {
            throw new IllegalArgumentException("filterOne == filterTwo");
        }
        if (physicalMemoryName2 == null) {
            PhysicalMemoryManager.registerFilter(physicalMemoryName, physicalMemoryTypeFilter);
        } else {
            PhysicalMemoryManager.registerFilter(physicalMemoryName, physicalMemoryName2, physicalMemoryTypeFilter);
        }
        Filter filter = PhysicalMemoryManager.findFilterEntry(physicalMemoryName);
        Filter filter2 = PhysicalMemoryManager.addFilter(filter, physicalMemoryTypeFilter2);
        filter2.composedFilter = filter.composedFilter;
        filter.composedFilter = filter2;
    }

    public static void registerFilter(PhysicalMemoryName physicalMemoryName, PhysicalMemoryName physicalMemoryName2, PhysicalMemoryTypeFilter[] physicalMemoryTypeFilterArray) throws DuplicateFilterException {
        PhysicalMemoryManager.checkArgs(physicalMemoryName, physicalMemoryTypeFilterArray);
        if (physicalMemoryName2 == null) {
            PhysicalMemoryManager.registerFilter(physicalMemoryName, physicalMemoryTypeFilterArray[0]);
        } else {
            PhysicalMemoryManager.registerFilter(physicalMemoryName, physicalMemoryName2, physicalMemoryTypeFilterArray[0]);
        }
        Filter filter = PhysicalMemoryManager.findFilterEntry(physicalMemoryName);
        try {
            for (int i = 1; i < physicalMemoryTypeFilterArray.length; ++i) {
                Filter filter2 = PhysicalMemoryManager.addFilter(filter, physicalMemoryTypeFilterArray[i]);
                filter2.composedFilter = filter.composedFilter;
                filter.composedFilter = filter2;
            }
        }
        catch (DuplicateFilterException duplicateFilterException) {
            PhysicalMemoryManager.removeFilter(physicalMemoryName);
            throw duplicateFilterException;
        }
    }

    public static final void registerFilter(Object object, PhysicalMemoryTypeFilter physicalMemoryTypeFilter) throws DuplicateFilterException, IllegalArgumentException {
        PhysicalMemoryManager.checkArgs(object, physicalMemoryTypeFilter);
        RealtimeSystem.getSecurityManager().checkSetFilter();
        PhysicalMemoryManager.addFilter(object, physicalMemoryTypeFilter);
    }

    private static void checkArgs(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            if (objectArray.length == 0) {
                throw new IllegalArgumentException("filters is a zero-length array");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new IllegalArgumentException("An entry in filters is null");
                }
                if (MemoryArea.getMemoryArea(objectArray[i]) instanceof ImmortalMemory || MemoryArea.isSoftSubsetLExcludeNhOn0()) continue;
                throw new IllegalArgumentException("An entry in filters is not in immortal");
            }
        } else if (!(MemoryArea.getMemoryArea(object2) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("Filter must be in immortal memory");
        }
        if (!(MemoryArea.getMemoryArea(object) instanceof ImmortalMemory) && !MemoryArea.isSoftSubsetLExcludeNhOn0()) {
            throw new IllegalArgumentException("Name must be in immortal memory");
        }
        if (object instanceof Object[]) {
            throw new IllegalArgumentException("The name argument of addFilter must not be an array.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter addFilter(Object object, PhysicalMemoryTypeFilter physicalMemoryTypeFilter) throws DuplicateFilterException {
        Filter[] filterArray = PhysicalMemoryManager.filterArray;
        synchronized (PhysicalMemoryManager.filterArray) {
            if (PhysicalMemoryManager.findFilterIndex(object) >= 0) {
                throw new DuplicateFilterException();
            }
            Filter filter = PhysicalMemoryManager.addAnonymousFilter(physicalMemoryTypeFilter);
            filter.typeName = object;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter addAnonymousFilter(PhysicalMemoryTypeFilter physicalMemoryTypeFilter) throws DuplicateFilterException {
        Filter[] filterArray = PhysicalMemoryManager.filterArray;
        synchronized (PhysicalMemoryManager.filterArray) {
            int n = PhysicalMemoryManager.findEmpty();
            if (n >= PhysicalMemoryManager.filterArray.length || n < 0) {
                throw new ResourceLimitError("System is not configured for more than " + PhysicalMemoryManager.filterArray.length + " types of memory.");
            }
            PhysicalMemoryManager.filterArray[n].typeName = PhysicalMemoryManager.filterArray[n];
            PhysicalMemoryManager.filterArray[n].filter = physicalMemoryTypeFilter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return PhysicalMemoryManager.filterArray[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter dupFilter(Object object, Object object2) throws DuplicateFilterException {
        Filter[] filterArray = PhysicalMemoryManager.filterArray;
        synchronized (PhysicalMemoryManager.filterArray) {
            Filter filter = PhysicalMemoryManager.findFilterEntry(object);
            if (filter == null) {
                throw new IllegalArgumentException("Attempt to dup an unknown filter");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return PhysicalMemoryManager.addAnonymousFilter(filter.filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void removeFilter(Object object) {
        RealtimeSystem.getSecurityManager().checkRemoveFilter();
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    PhysicalMemoryManager.removeFilter(objectArray[i]);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return;
        } else {
            Filter[] filterArray = PhysicalMemoryManager.filterArray;
            synchronized (PhysicalMemoryManager.filterArray) {
                Filter filter = PhysicalMemoryManager.findFilterEntry(object);
                if (filter == null) return;
                if (filter.composedFilter != null) {
                    PhysicalMemoryManager.removeFilter(filter.composedFilter.typeName);
                }
                filter.empty();
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static boolean isRemovable(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
        int n = PhysicalMemoryManager.findRemovableFilterByAddress(l, l2);
        return n >= 0;
    }

    public static boolean isRemoved(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
        return false;
    }

    public static void onRemoval(long l, long l2, AsyncEventHandler asyncEventHandler) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
    }

    public static void onInsertion(long l, long l2, AsyncEventHandler asyncEventHandler) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
    }

    public static void onInsertion(long l, long l2, AsyncEvent asyncEvent) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
    }

    public static void onRemoval(long l, long l2, AsyncEvent asyncEvent) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
    }

    public static boolean unregisterInsertionEvent(long l, long l2, AsyncEvent asyncEvent) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
        return false;
    }

    public static boolean unregisterRemovalEvent(long l, long l2, AsyncEvent asyncEvent) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFilterIndex(Object object) {
        if (object == null) {
            return -1;
        }
        Filter[] filterArray = PhysicalMemoryManager.filterArray;
        synchronized (PhysicalMemoryManager.filterArray) {
            for (int i = 0; i < PhysicalMemoryManager.filterArray.length; ++i) {
                if (PhysicalMemoryManager.filterArray[i].isEmpty() || !object.equals(PhysicalMemoryManager.filterArray[i].typeName)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFilterIndex(Filter filter) {
        Filter[] filterArray = PhysicalMemoryManager.filterArray;
        synchronized (PhysicalMemoryManager.filterArray) {
            for (int i = 0; i < PhysicalMemoryManager.filterArray.length; ++i) {
                if (PhysicalMemoryManager.filterArray[i] != filter) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    private static Filter findFilterEntry(Object object) {
        int n = PhysicalMemoryManager.findFilterIndex(object);
        if (n < 0) {
            return null;
        }
        return filterArray[n];
    }

    private static PhysicalMemoryTypeFilter findFilter(Object object) {
        int n = PhysicalMemoryManager.findFilterIndex(object);
        if (n == -1) {
            return null;
        }
        return PhysicalMemoryManager.filterArray[n].filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findEmpty() {
        Filter[] filterArray = PhysicalMemoryManager.filterArray;
        synchronized (PhysicalMemoryManager.filterArray) {
            for (int i = 0; i < PhysicalMemoryManager.filterArray.length; ++i) {
                if (!PhysicalMemoryManager.filterArray[i].isEmpty()) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return -1;
        }
    }

    private static int findRemovableFilterByAddress(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        PhysicalMemoryManager.checkParameters(l, l2);
        for (int i = 0; i < filterArray.length; ++i) {
            if (filterArray[i].isEmpty() || !PhysicalMemoryManager.filterArray[i].filter.isRemovable() || !PhysicalMemoryManager.filterArray[i].filter.contains(l, l2)) continue;
            return i;
        }
        return -1;
    }

    private static void addrCheckIfInUse(long l, long l2) throws MemoryInUseException {
        AddressList addressList = addrInUse;
        while (addressList != null) {
            if (l + l2 > addressList.base && l < addressList.base + addressList.size) {
                throw new MemoryInUseException("Base/size pair conlicts with an already mapped memory region. From " + addressList.base + " to " + (addressList.base + addressList.size));
            }
            addressList = addressList.next;
        }
    }

    private static void addrAddToList(long l, long l2, long l3, int n, int n2) {
        AddressList addressList = new AddressList();
        addressList.base = l;
        addressList.size = l2;
        addressList.protection = n;
        addressList.flags = n2;
        addressList.virtualAddress = l3;
        PhysicalMemoryManager.addrAddToList(addressList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addrAddToList(AddressList addressList) {
        Object object = addrLock;
        synchronized (object) {
            if (addrInUse == null || PhysicalMemoryManager.addrInUse.virtualAddress > addressList.virtualAddress) {
                addressList.next = addrInUse;
                addrInUse = addressList;
            } else {
                AddressList addressList2 = addrInUse;
                AddressList addressList3 = addressList2.next;
                while (addressList3 != null) {
                    if (addressList3.virtualAddress > addressList.virtualAddress) {
                        addressList.next = addressList3;
                        addressList2.next = addressList;
                        return;
                    }
                    addressList2 = addressList3;
                    addressList3 = addressList3.next;
                }
                addressList2.next = addressList;
                addressList.next = null;
            }
        }
    }

    private static long findFreeSlot(PhysicalMemoryTypeFilter physicalMemoryTypeFilter, long l, long l2) {
        long l3 = physicalMemoryTypeFilter.find(l2, l);
        if (l3 == -1L) {
            return -1L;
        }
        long l4 = l3 + l;
        AddressList addressList = addrInUse;
        if (addressList == null) {
            return l3;
        }
        if (addressList.base > l4) {
            return l3;
        }
        AddressList addressList2 = addressList.next;
        while (addressList2 != null) {
            if (l3 < addressList.base + addressList.size) {
                l3 = physicalMemoryTypeFilter.find(addressList.base + addressList.size, l);
                if (l3 == -1L) {
                    return -1L;
                }
                l4 = l3 + l;
            }
            if (l4 > addressList2.base) {
                l3 = physicalMemoryTypeFilter.find(addressList2.base + addressList2.size, l);
                if (l3 == -1L) {
                    return -1L;
                }
            } else {
                return l3;
            }
            l4 = l3 + l;
            addressList = addressList2;
            addressList2 = addressList2.next;
        }
        l3 = physicalMemoryTypeFilter.find(addressList.base + addressList.size, l);
        return l3;
    }

    private static long mmap(long l, long l2, int n, int n2) {
        long l3 = pagesize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long l4 = l & l3;
        int n3 = (int)(l - l4);
        l2 = l2 + pagesize & l3;
        return PhysicalMemoryManager.mmap0(l4, 0L, l2, n, n2) + (long)n3;
    }

    private static long mmap(long l, long l2, long l3, int n, int n2) {
        long l4 = pagesize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        n2 &= 0xFFFFFFEF;
        long l5 = l & l4;
        int n3 = (int)(l - l5);
        long l6 = l2 & l4;
        if ((long)n3 != l2 - l6) {
            throw new IllegalArgumentException("Map() attempting to change an address's offset in the page. Old: " + n3 + " new: " + (l2 - l6));
        }
        l3 = l3 + pagesize - 1L & l4;
        return PhysicalMemoryManager.mmap0(l5, l2, l3, n, n2) + (long)n3;
    }

    private static void unmap(long l, long l2) {
        long l3 = pagesize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long l4 = l & l3;
        l2 = l2 + pagesize - 1L & l3;
        PhysicalMemoryManager.munmap0(l4, l2);
    }

    private static native void init();

    private static native long mmap0(long var0, long var2, long var4, int var6, int var7);

    private static native void munmap0(long var0, long var2);

    static {
        defaultType = null;
        addrInUse = null;
        addrLock = new Object();
        DMA = new PhysicalMemoryNameType("dma");
        SHARED = new PhysicalMemoryNameType("shared");
        ALIGNED = new PhysicalMemoryNameType("aligned");
        BYTESWAP = new PhysicalMemoryNameType("byteswap");
        IO_PAGE = new PhysicalMemoryNameType("io_page");
        DEVICE = new PhysicalMemoryNameType("device");
        int n = Integer.getInteger("javax.realtime.MAXFILTERS", 32);
        filterArray = new Filter[n];
        filterSubset = new Filter[n];
        for (int i = 0; i < n; ++i) {
            PhysicalMemoryManager.filterArray[i] = new Filter();
            PhysicalMemoryManager.filterSubset[i] = new Filter();
        }
        try {
            PhysicalMemoryManager.init();
        }
        catch (SecurityException securityException) {
            pagesize = 4096L;
        }
    }

    private static class AddressList {
        long base;
        long size;
        long virtualAddress;
        int protection;
        int flags;
        AddressList next;

        private AddressList() {
        }
    }

    private static class Filter {
        Object typeName;
        PhysicalMemoryTypeFilter filter;
        public Filter composedFilter;

        public Filter() {
        }

        public Filter(Filter filter) {
            this.typeName = filter.typeName;
            this.filter = filter.filter;
            this.composedFilter = filter.composedFilter;
        }

        public void copy(Filter filter) {
            this.typeName = filter.typeName;
            this.filter = filter.filter;
            this.composedFilter = filter.composedFilter;
        }

        public boolean isEmpty() {
            return this.typeName == null;
        }

        public void empty() {
            this.typeName = null;
            this.filter = null;
            this.composedFilter = null;
        }
    }
}

