/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.AsyncEventHandler;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.SchedRefHolder;

public class PeriodicParameters
extends ReleaseParameters {
    RelativeTime period;
    long periodMillis;
    int periodNanos;
    Clock periodClock;
    HighResolutionTime start;
    long startMillis;
    int startNanos;
    Clock startClock;
    boolean startAbsolute;
    private PeriodicParameters temporaryPP;
    private static final RelativeTime zero = new RelativeTime();
    static /* synthetic */ Class class$javax$realtime$Scheduler;

    public PeriodicParameters(HighResolutionTime highResolutionTime, RelativeTime relativeTime) {
        this(highResolutionTime, relativeTime, null, null, null, null);
    }

    public PeriodicParameters(HighResolutionTime highResolutionTime, RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this(highResolutionTime, relativeTime, relativeTime2, relativeTime3, null, asyncEventHandler, asyncEventHandler2);
    }

    public PeriodicParameters(HighResolutionTime highResolutionTime, RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, RelativeTime relativeTime4, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        if (highResolutionTime == null) {
            highResolutionTime = new RelativeTime(0L, 0);
        }
        this.init(highResolutionTime, relativeTime, relativeTime2, relativeTime3, relativeTime4, asyncEventHandler, asyncEventHandler2);
    }

    private void checkPeriod(RelativeTime relativeTime) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("null period");
        }
        if (relativeTime.compareTo(zero) <= 0) {
            throw new IllegalArgumentException("period <= 0");
        }
    }

    public PeriodicParameters(RelativeTime relativeTime) {
        this(null, relativeTime, null, null, null, null);
    }

    private void init(HighResolutionTime highResolutionTime, RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, RelativeTime relativeTime4, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        relativeTime4 = this.checkBlockingTime(relativeTime4);
        if (highResolutionTime == null) {
            highResolutionTime = new RelativeTime();
        }
        this.internalSetStartNoCheck(highResolutionTime);
        this.checkPeriod(relativeTime);
        this.internalSetPeriodNoCheck(relativeTime);
        this.defaultDeadline = relativeTime;
        if (relativeTime2 == null) {
            relativeTime2 = new RelativeTime(0L, 0);
        }
        this.internalSetCostNoCheck(relativeTime2);
        if (relativeTime3 == null) {
            relativeTime3 = relativeTime;
        }
        this.internalSetDeadlineNoCheck(relativeTime3);
        this.checkCost(this.cost);
        this.checkDeadline(this.deadline);
        this.internalSetBlockingNoCheck(relativeTime4);
        this.internalSetCostOverrunHandler(asyncEventHandler);
        this.internalSetMissHandlerUnchecked(asyncEventHandler2);
    }

    public synchronized Object clone() {
        PeriodicParameters periodicParameters = null;
        HighResolutionTime highResolutionTime = this.start;
        RelativeTime relativeTime = this.period;
        this.start = null;
        this.period = null;
        periodicParameters = (PeriodicParameters)super.clone();
        periodicParameters.start = highResolutionTime == null ? null : (HighResolutionTime)highResolutionTime.clone();
        periodicParameters.period = relativeTime == null ? null : (RelativeTime)relativeTime.clone();
        this.start = highResolutionTime;
        this.period = relativeTime;
        return periodicParameters;
    }

    public RelativeTime getPeriod() {
        return this.internalGetPeriod();
    }

    final RelativeTime internalGetPeriod() {
        return this.period;
    }

    long getPeriodMillis() {
        return this.periodMillis;
    }

    int getPeriodNanos() {
        return this.periodNanos;
    }

    Clock getPeriodClock() {
        return this.periodClock;
    }

    public HighResolutionTime getStart() {
        return this.internalGetStart();
    }

    final HighResolutionTime internalGetStart() {
        return this.start;
    }

    public boolean setIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3) {
        return this.setAllIfFeasible(relativeTime, relativeTime2, relativeTime3, this.internalGetBlocking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAllIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, RelativeTime relativeTime4) {
        boolean bl = true;
        if (relativeTime == null) {
            throw new IllegalArgumentException("null period");
        }
        this.checkPeriod(relativeTime);
        if (relativeTime3 == null) {
            relativeTime3 = new RelativeTime(relativeTime);
        }
        this.checkDeadline(relativeTime3);
        if (relativeTime2 == null) {
            relativeTime2 = new RelativeTime();
        }
        this.checkCost(relativeTime2);
        relativeTime4 = this.checkBlockingTime(relativeTime4);
        PeriodicParameters periodicParameters = this;
        synchronized (periodicParameters) {
            RelativeTime relativeTime5 = this.internalGetPeriod();
            RelativeTime relativeTime6 = this.internalGetCost();
            RelativeTime relativeTime7 = this.internalGetDeadline();
            RelativeTime relativeTime8 = this.internalGetBlocking();
            this.internalSetPeriod(relativeTime);
            this.internalSetCost(relativeTime2);
            this.internalSetDeadline(relativeTime3);
            this.internalSetBlockingNoCheck(relativeTime4);
            Class clazz = class$javax$realtime$Scheduler == null ? (class$javax$realtime$Scheduler = PeriodicParameters.class$("javax.realtime.Scheduler")) : class$javax$realtime$Scheduler;
            synchronized (clazz) {
                for (int i = 0; i < this.schedSet.size(); ++i) {
                    SchedRefHolder schedRefHolder = this.schedSet.elementAt(i);
                    if (schedRefHolder.sched.setReleaseParametersIfFeasible(this, schedRefHolder.hash)) continue;
                    this.internalSetPeriod(relativeTime5);
                    this.internalSetCost(relativeTime6);
                    this.internalSetDeadline(relativeTime7);
                    this.internalSetBlockingNoCheck(relativeTime8);
                    int n = i - 1;
                    while (i > 0) {
                        schedRefHolder = this.schedSet.elementAt(n);
                        schedRefHolder.sched.setReleaseParametersIfFeasible(this, schedRefHolder.hash);
                        --i;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public void setPeriod(RelativeTime relativeTime) {
        this.internalSetPeriod(relativeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetPeriod(RelativeTime relativeTime) {
        this.checkPeriod(relativeTime);
        PeriodicParameters periodicParameters = this;
        synchronized (periodicParameters) {
            if (this.temporaryPP == null) {
                this.temporaryPP = (PeriodicParameters)this.clone();
            }
        }
        periodicParameters = this.temporaryPP;
        synchronized (periodicParameters) {
            this.temporaryPP.internalSetPeriodNoCheck(relativeTime);
            this.temporaryPP.internalSetDeadlineNoCheck(this.deadline);
            this.temporaryPP.internalSetCostNoCheck(this.cost);
            this.temporaryPP.internalSetStartNoCheck(this.start);
            this.temporaryPP.internalSetCostOverrunHandler(this.overrunHandler);
            this.temporaryPP.internalSetMissHandlerUnchecked(this.missHandler);
            for (int i = 0; i < this.schedSet.size(); ++i) {
                SchedRefHolder schedRefHolder = this.schedSet.elementAt(i);
                if (schedRefHolder.sched.validParameters(this.temporaryPP)) continue;
                throw new IllegalArgumentException("Scheduler does not accept the changed period");
            }
        }
        periodicParameters = this;
        synchronized (periodicParameters) {
            this.internalSetPeriodNoCheck(relativeTime);
            this.defaultDeadline = relativeTime;
            this.updateSchedulables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetDeadline(RelativeTime relativeTime) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime(this.defaultDeadline);
        }
        this.checkDeadline(relativeTime);
        PeriodicParameters periodicParameters = this;
        synchronized (periodicParameters) {
            if (this.temporaryPP == null) {
                this.temporaryPP = (PeriodicParameters)this.clone();
            }
        }
        periodicParameters = this.temporaryPP;
        synchronized (periodicParameters) {
            this.temporaryPP.internalSetPeriodNoCheck(this.period);
            this.temporaryPP.internalSetDeadlineNoCheck(relativeTime);
            this.temporaryPP.internalSetCostNoCheck(this.cost);
            this.temporaryPP.internalSetStartNoCheck(this.start);
            this.temporaryPP.internalSetCostOverrunHandler(this.overrunHandler);
            this.temporaryPP.internalSetMissHandlerUnchecked(this.missHandler);
            for (int i = 0; i < this.schedSet.size(); ++i) {
                SchedRefHolder schedRefHolder = this.schedSet.elementAt(i);
                boolean bl = schedRefHolder.sched.validParameters(this.temporaryPP);
                if (bl) continue;
                throw new IllegalArgumentException("A scheduler does not accept the changed deadline");
            }
        }
        periodicParameters = this;
        synchronized (periodicParameters) {
            this.internalSetDeadlineNoCheck(relativeTime);
            this.updateSchedulables();
        }
    }

    public void setStart(HighResolutionTime highResolutionTime) {
        this.internalSetStart(highResolutionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetStart(HighResolutionTime highResolutionTime) {
        PeriodicParameters periodicParameters = this;
        synchronized (periodicParameters) {
            if (highResolutionTime == null) {
                this.internalSetStartNoCheck(new RelativeTime(0L, 0));
            } else {
                this.internalSetStartNoCheck(highResolutionTime);
            }
            this.updated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSetPeriodNoCheck(RelativeTime relativeTime) {
        PeriodicParameters periodicParameters = this;
        synchronized (periodicParameters) {
            this.periodMillis = relativeTime.getMilliseconds();
            this.periodNanos = relativeTime.getNanoseconds();
            this.periodClock = relativeTime.getClock();
            this.period = relativeTime;
            this.updated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSetStartNoCheck(HighResolutionTime highResolutionTime) {
        PeriodicParameters periodicParameters = this;
        synchronized (periodicParameters) {
            this.startMillis = highResolutionTime.getMilliseconds();
            this.startNanos = highResolutionTime.getNanoseconds();
            this.startClock = highResolutionTime.getClock();
            this.startAbsolute = highResolutionTime instanceof AbsoluteTime;
            this.start = highResolutionTime;
            this.updated();
        }
    }

    void internalSetAll(HighResolutionTime highResolutionTime, RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this.internalSetStartNoCheck(highResolutionTime);
        this.internalSetPeriodNoCheck(relativeTime);
        this.defaultDeadline = relativeTime;
        if (relativeTime2 == null) {
            relativeTime2 = new RelativeTime(0L, 0);
        }
        this.internalSetCostNoCheck(relativeTime2);
        if (relativeTime3 == null) {
            relativeTime3 = relativeTime;
        }
        this.internalSetDeadlineNoCheck(relativeTime3);
        this.internalSetCostOverrunHandler(asyncEventHandler);
        this.internalSetMissHandlerUnchecked(asyncEventHandler2);
    }

    public String toString() {
        return "PeriodicParameters Start = " + this.start + " Period = " + this.period + " Deadline = " + this.deadline + " Overrun handler = " + this.overrunHandler + " Miss handler = " + this.missHandler;
    }

    public boolean isAbsoluteStartTime() {
        return this.startAbsolute;
    }

    long getStartMs() {
        return this.startMillis;
    }

    int getStartNs() {
        return this.startNanos;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

