/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AEHImpl;
import javax.realtime.AsyncDMEvent;
import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.HeapMemory;
import javax.realtime.ImmortalMemory;
import javax.realtime.ImmortalPhysicalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.NoDeadlineParams;
import javax.realtime.PeriodicParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThread;
import javax.realtime.ReleaseParameters;
import javax.realtime.Scheduler;
import javax.realtime.SchedulingParameters;
import javax.realtime.ScopedRegion;

public class NoHeapRealtimeThread
extends RealtimeThread {
    private DeadlineMissHeapHelper missHeapHelper;
    private OverrunHeapHelper overrunHeapHelper;

    public NoHeapRealtimeThread(SchedulingParameters schedulingParameters, MemoryArea memoryArea) throws IllegalArgumentException {
        this(schedulingParameters, null, memoryArea);
    }

    public NoHeapRealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryArea memoryArea) throws IllegalArgumentException {
        this(schedulingParameters, releaseParameters, null, memoryArea, null, null);
    }

    public NoHeapRealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, Runnable runnable) throws IllegalArgumentException {
        this(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, runnable, false, null);
    }

    NoHeapRealtimeThread(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, Runnable runnable, boolean bl, AEHImpl aEHImpl) throws IllegalArgumentException {
        super(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, runnable, bl, aEHImpl);
        if (RealtimeSystem.isSoftSubsetLExcludeNhOn()) {
            throw new IllegalStateException("NoHeapRealtimeThreads cannot be created in heap-only mode.");
        }
        if (memoryArea == null || !(memoryArea instanceof ScopedRegion) && !(memoryArea instanceof ImmortalMemory) && !(memoryArea instanceof ImmortalPhysicalMemory)) {
            throw new IllegalArgumentException("Illegal MemoryArea Passed: " + memoryArea);
        }
        if (MemoryArea.getMemoryArea(memoryArea) == HeapMemory.instance()) {
            throw new IllegalArgumentException("Illegal MemoryArea Passed (allocated on heap)");
        }
        this.checkParamsForHeap();
        if (this.releaseParameters instanceof PeriodicParameters) {
            this.missHeapHelper = new DeadlineMissHeapHelper();
        }
    }

    public void start() {
        super.start();
    }

    private void checkParamsForHeap() {
        Object object = null;
        HeapMemory heapMemory = HeapMemory.instance();
        if (heapMemory.equals(MemoryArea.getMemoryArea(this))) {
            throw new IllegalArgumentException("Tried creating an NHRTT which was allocated in heap");
        }
        if (this.logic != null && heapMemory.equals(MemoryArea.getMemoryArea(this))) {
            throw new IllegalArgumentException("Tried creating an NHRTT whose Runnable was allocated in heap");
        }
        object = this.internalGetMemoryArea();
        if (object != null && heapMemory.equals(MemoryArea.getMemoryArea(object))) {
            throw new IllegalArgumentException("Tried creating an NHRTT with MemoryArea allocated in heap");
        }
        object = this.getMemoryParameters();
        if (object != null && heapMemory.equals(MemoryArea.getMemoryArea(object))) {
            throw new IllegalArgumentException("Tried creating an NHRTT with MemoryParameters allocated in heap");
        }
        object = this.getProcessingGroupParameters();
        if (object != null && heapMemory.equals(MemoryArea.getMemoryArea(object))) {
            throw new IllegalArgumentException("Tried creating an NHRTT with ProcessingGroupParameters allocated in heap");
        }
        object = this.getReleaseParameters();
        if (object != null && heapMemory.equals(MemoryArea.getMemoryArea(object))) {
            throw new IllegalArgumentException("Tried creating an NHRTT with ReleaseParameters allocated in heap");
        }
        object = this.getSchedulingParameters();
        if (object != null && heapMemory.equals(MemoryArea.getMemoryArea(object))) {
            throw new IllegalArgumentException("Tried creating an NHRTT with SchedulingParameters allocated in heap");
        }
    }

    private void checkHeap(Object object) {
        this.checkHeap(object, "NHRTT cannot reference heap object - " + object);
    }

    private void checkHeap(Object object, String string) {
        if (object != null && HeapMemory.instance().equals(MemoryArea.getMemoryArea(object))) {
            throw new IllegalArgumentException(string);
        }
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        this.checkHeap(releaseParameters);
        this.checkHeap(memoryParameters);
        return super.setIfFeasible(releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        this.checkHeap(releaseParameters);
        this.checkHeap(memoryParameters);
        this.checkHeap(processingGroupParameters);
        return super.setIfFeasible(releaseParameters, memoryParameters, processingGroupParameters);
    }

    public boolean setReleaseParametersIfFeasible(ReleaseParameters releaseParameters) {
        this.checkHeap(releaseParameters);
        return super.setReleaseParametersIfFeasible(releaseParameters);
    }

    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters processingGroupParameters) {
        this.checkHeap(processingGroupParameters);
        return super.setProcessingGroupParametersIfFeasible(processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        this.checkHeap(releaseParameters);
        this.checkHeap(processingGroupParameters);
        return super.setIfFeasible(releaseParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        this.checkHeap(schedulingParameters);
        this.checkHeap(releaseParameters);
        this.checkHeap(memoryParameters);
        return super.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        this.checkHeap(schedulingParameters);
        this.checkHeap(releaseParameters);
        this.checkHeap(memoryParameters);
        this.checkHeap(processingGroupParameters);
        return super.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public boolean setMemoryParametersIfFeasible(MemoryParameters memoryParameters) {
        this.checkHeap(memoryParameters);
        return super.setMemoryParametersIfFeasible(memoryParameters);
    }

    public void setMemoryParameters(MemoryParameters memoryParameters) {
        this.checkHeap(memoryParameters);
        super.setMemoryParameters(memoryParameters);
    }

    public void setReleaseParameters(ReleaseParameters releaseParameters) {
        this.checkHeap(releaseParameters);
        super.setReleaseParameters(releaseParameters);
    }

    public void setScheduler(Scheduler scheduler, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        this.checkHeap(scheduler);
        this.checkHeap(schedulingParameters);
        this.checkHeap(releaseParameters);
        this.checkHeap(memoryParameters);
        this.checkHeap(processingGroupParameters);
        super.setScheduler(scheduler, schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public void setScheduler(Scheduler scheduler) {
        this.checkHeap(scheduler);
        super.setScheduler(scheduler);
    }

    public void setSchedulingParameters(SchedulingParameters schedulingParameters) {
        this.checkHeap(schedulingParameters);
        super.setSchedulingParameters(schedulingParameters);
    }

    public boolean setSchedulingParametersIfFeasible(SchedulingParameters schedulingParameters) {
        this.checkHeap(schedulingParameters);
        return super.setSchedulingParametersIfFeasible(schedulingParameters);
    }

    public void setProcessingGroupParameters(ProcessingGroupParameters processingGroupParameters) {
        this.checkHeap(processingGroupParameters);
        super.setProcessingGroupParameters(processingGroupParameters);
    }

    void updateMissHandlerFromReleaseParameters() {
        if (this.releaseParameters.hasHeapMissHandler()) {
            if (this.releaseParameters.getMissHandlerHash() != this.installedMissHandlerHash) {
                if (this.deadlineEvent == null) {
                    throw new RuntimeException("deadlineEvent unexpectedly null");
                }
                this.deadlineEvent.setHandler(this.missHeapHelper);
                this.hasMissHandler = this.releaseParameters.hasMissHandler();
                this.installedMissHandlerHash = this.releaseParameters.getMissHandlerHash();
            }
        } else {
            super.updateMissHandlerFromReleaseParameters();
        }
    }

    void updateOverrunHandlerFromReleaseParameters() {
        if (this.releaseParameters.hasHeapOverrunHandler()) {
            this.hasOverrunHandler = this.releaseParameters.hasOverrunHandler();
            this.cpuTimeClock.setTimer(this.releaseParameters.getCostTotalNanos(), this.costOverrunAE);
            if (this.hasOverrunHandler && this.installedOverrunHandlerHash != this.releaseParameters.getCostOverrunHandlerHash()) {
                if (this.costOverrunAE == null) {
                    throw new RuntimeException("Overrun event unexpectedly null");
                }
                this.costOverrunAE.setHandler(this.overrunHeapHelper);
                this.installedOverrunHandlerHash = this.releaseParameters.getCostOverrunHandlerHash();
            }
        } else {
            super.updateOverrunHandlerFromReleaseParameters();
        }
    }

    void updateThresholdPriority(int n) {
        if (this.scheduler instanceof PriorityScheduler) {
            ((PriorityScheduler)this.scheduler).updateNoHeapSOThreshold(n);
        }
    }

    void finishNativeThread() {
        super.finishNativeThread();
    }

    class OverrunHeapHelper
    extends AsyncEventHandler {
        OverrunHeapHelper() {
            super((SchedulingParameters)PriorityScheduler.getMaxHeapPriorityParameters(), (ReleaseParameters)NoDeadlineParams.instance(), null, null, null, null);
        }

        public void handleAsyncEvent() {
            AsyncEvent asyncEvent;
            if (Thread.currentThread() instanceof NoHeapRealtimeThread) {
                System.err.println("Overrun helper AEH is running in no-heap mode");
            }
            if ((asyncEvent = NoHeapRealtimeThread.this.costOverrunAE) != null) {
                asyncEvent.setHandler(NoHeapRealtimeThread.this.releaseParameters.getCostOverrunHandler());
                asyncEvent.fire();
            }
        }
    }

    class DeadlineMissHeapHelper
    extends AsyncEventHandler {
        DeadlineMissHeapHelper() {
            super((SchedulingParameters)PriorityScheduler.getMaxHeapPriorityParameters(), (ReleaseParameters)NoDeadlineParams.instance(), null, null, null, null);
        }

        public void handleAsyncEvent() {
            AsyncDMEvent asyncDMEvent;
            if (Thread.currentThread() instanceof NoHeapRealtimeThread) {
                System.err.println("Heap helper AEH is running in no-heap mode");
            }
            if ((asyncDMEvent = NoHeapRealtimeThread.this.deadlineEvent) != null) {
                asyncDMEvent.setHandler(NoHeapRealtimeThread.this.releaseParameters.getDeadlineMissHandler());
                asyncDMEvent.fire();
            }
        }
    }
}

