/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.timesys.HighPriorityScheduler;
import com.timesys.IllegalDispatcherStateException;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.NoDeadlineParams;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.PriorityParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.RealtimeThread;
import javax.realtime.ReleaseParameters;
import javax.realtime.SchedulingParameters;

final class NDispatcher {
    private static boolean started = false;
    private static Object startLock = new Object();
    private static int dispPID = -1;
    private static Object dispPIDlock = new Object();
    private static RealtimeThread eventDispatcherThread = null;

    protected NDispatcher() {
    }

    static synchronized void startDispatcher() throws IllegalDispatcherStateException {
        NDispatcher.startDispatcher(new PriorityParameters(PriorityScheduler.instance().getMaxPriority()), (ReleaseParameters)NoDeadlineParams.instance(), null, MemoryArea.getEffImmortalMa(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void startDispatcher(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters) throws IllegalDispatcherStateException {
        Object object = startLock;
        synchronized (object) {
            if (started) {
                throw new IllegalDispatcherStateException();
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        NDispatcher.startDispatcher0();
                        while (true) {
                            NDispatcher.runDispatcher0();
                        }
                    }
                    catch (Throwable throwable) {
                        System.err.print("Internal dispatcher quitting.");
                        throwable.printStackTrace();
                        return;
                    }
                }
            };
            eventDispatcherThread = MemoryArea.isSoftSubsetLExcludeNhOn0() ? new RealtimeThread(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, runnable) : new NoHeapRealtimeThread(schedulingParameters, releaseParameters, memoryParameters, memoryArea, processingGroupParameters, runnable);
            eventDispatcherThread.setScheduler(HighPriorityScheduler.instance());
            eventDispatcherThread.setSchedulingParameters(new PriorityParameters(HighPriorityScheduler.instance().getMaxPriority() - 10));
            eventDispatcherThread.setName("Top-level event dispatcher");
            eventDispatcherThread.setDaemon(true);
            eventDispatcherThread.start();
            started = true;
        }
    }

    private static native void runDispatcher0();

    private static native void startDispatcher0();

    static boolean isStarted() {
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPID(int n) {
        Object object = dispPIDlock;
        synchronized (object) {
            dispPID = n;
            dispPIDlock.notifyAll();
        }
    }

    static {
        try {
            Class.forName("javax.realtime.AsyncEvent");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

