/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.realtime.HeapMemory;
import javax.realtime.ImmortalMemory;
import javax.realtime.ImmortalPhysicalMemory;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryAccessError;
import javax.realtime.MemoryRegion;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.RealtimeThread;
import javax.realtime.RealtimeThreadCNI;
import javax.realtime.ScopedCycleException;
import javax.realtime.ScopedRegion;
import javax.realtime.SizeEstimator;

public abstract class MemoryArea
implements MemoryRegion {
    private long nativeMemoryAreaInfoPtr;
    private long savedParent;
    long memorySize;
    Runnable attachedRunnable;
    private boolean objectFinalized = false;

    protected MemoryArea(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Invalid size passed:" + l);
        }
        this.memorySize = l;
    }

    protected MemoryArea(SizeEstimator sizeEstimator) {
        this(sizeEstimator, null);
    }

    protected MemoryArea(long l, Runnable runnable) {
        if (l < 0L) {
            throw new IllegalArgumentException("size < 0");
        }
        this.memorySize = l;
        this.attachedRunnable = runnable;
    }

    protected MemoryArea(SizeEstimator sizeEstimator, Runnable runnable) {
        if (sizeEstimator == null) {
            throw new IllegalArgumentException("Null size passed:");
        }
        this.memorySize = sizeEstimator.getEstimate();
        if (this.memorySize < 0L) {
            throw new IllegalArgumentException("Size < 0");
        }
        this.attachedRunnable = runnable;
    }

    public void enter() throws ScopedCycleException {
        this.enter(this.attachedRunnable);
    }

    public void enter(Runnable runnable) throws ScopedCycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushMemoryArea() {
        MemoryArea memoryArea = this;
        synchronized (memoryArea) {
            RealtimeThreadCNI.pushMemoryArea(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void popMemoryArea() {
        MemoryArea memoryArea = this;
        synchronized (memoryArea) {
            RealtimeThreadCNI.popMemoryArea();
        }
    }

    public static MemoryArea getMemoryArea(Object object) {
        if (object == null) {
            throw new NullPointerException("object passed was null");
        }
        return MemoryArea.getMemoryAreaForObject(object);
    }

    public long memoryConsumed() {
        return this.getMemoryConsumed0();
    }

    public long memoryRemaining() {
        return this.getMemoryRemaining0();
    }

    public Object newArray(Class clazz, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number less than zero");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException("type is Void.TYPE");
        }
        this.checkNHRTHeapAccess();
        return this.newArray0(clazz, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(Class clazz) throws IllegalAccessException, InstantiationException {
        this.checkNHRTHeapAccess();
        if (clazz == null) {
            throw new IllegalArgumentException("null argument passed");
        }
        Object var2_2 = null;
        long l = 0L;
        long l2 = 0L;
        Object object = this;
        synchronized (object) {
            l2 = this.executeInAreaBeginWrapper();
            l = this.getSavedParent();
        }
        try {
            object = clazz.getDeclaredConstructor(null);
            var2_2 = ((Constructor)object).newInstance(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InstantiationException(clazz.getName() + " has no appropriate constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            throw new InstantiationException(invocationTargetException.getTargetException().toString());
        }
        finally {
            MemoryArea.executeInAreaEndWrapper(l2, l);
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(Constructor constructor, Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        long l;
        long l2;
        this.checkNHRTHeapAccess();
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor object passed is null");
        }
        Object var3_3 = null;
        MemoryArea memoryArea = this;
        synchronized (memoryArea) {
            l2 = this.executeInAreaBeginWrapper();
            l = this.getSavedParent();
        }
        try {
            var3_3 = constructor.newInstance(objectArray);
        }
        finally {
            MemoryArea.executeInAreaEndWrapper(l2, l);
        }
        return var3_3;
    }

    public long size() {
        return this.memorySize;
    }

    void setSizeField(long l) {
        this.memorySize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInArea(Runnable runnable) throws InaccessibleAreaException {
        long l;
        long l2;
        if (runnable == null) {
            throw new IllegalArgumentException("logic parameters is null");
        }
        MemoryArea memoryArea = this;
        synchronized (memoryArea) {
            l2 = this.executeInAreaBeginWrapper();
            l = this.getSavedParent();
        }
        try {
            runnable.run();
        }
        finally {
            MemoryArea.executeInAreaEndWrapper(l2, l);
        }
    }

    void registerMemoryArea(long l, long l2) {
        if (this instanceof HeapMemory) {
            this.registerMemoryArea0(l, l2, 1);
        } else if (this instanceof ImmortalMemory || this instanceof ImmortalPhysicalMemory) {
            this.registerMemoryArea0(l, l2, 2);
        } else if (this instanceof ScopedRegion) {
            this.registerMemoryArea0(l, l2, 3);
        } else {
            System.out.println("Trying to register an unknown memory area " + this);
        }
    }

    void checkNHRTHeapAccess() {
        if (this instanceof HeapMemory && Thread.currentThread() instanceof NoHeapRealtimeThread) {
            throw new MemoryAccessError("NHRTT tried accessing heap");
        }
    }

    boolean reachableMemory() {
        return true;
    }

    long getNativeInfoRef() {
        return this.nativeMemoryAreaInfoPtr;
    }

    long getSavedParent() {
        return this.savedParent;
    }

    void setSavedParent(long l) {
        this.savedParent = l;
    }

    long executeInAreaBeginWrapper() {
        long l;
        Thread thread = Thread.currentThread();
        if (thread instanceof RealtimeThread) {
            RealtimeThread realtimeThread = (RealtimeThread)thread;
            this.savedParent = realtimeThread.getTopScopeRef();
            l = MemoryArea.executeInAreaBegin(this);
            realtimeThread.setTopScopeRef(0L);
        } else {
            l = MemoryArea.executeInAreaBegin(this);
        }
        return l;
    }

    static void executeInAreaEndWrapper(long l, long l2) {
        MemoryArea.executeInAreaEnd(l);
        Thread thread = Thread.currentThread();
        if (thread instanceof RealtimeThread) {
            ((RealtimeThread)thread).setTopScopeRef(l2);
        }
    }

    String getStatus() {
        return "non scoped memory";
    }

    static MemoryArea getEffImmortalMa() {
        return MemoryArea.isSoftSubsetLExcludeNhOn0() ? HeapMemory.instance() : ImmortalMemory.instance();
    }

    native boolean runAllFinalizers();

    native boolean runAEShutdowns0();

    native void runEeShutdowns0();

    native void registerMemoryArea0(long var1, long var3, int var5);

    private static native MemoryArea getMemoryAreaForObject(Object var0);

    private native Object newArray0(Class var1, int var2);

    private native long getMemoryConsumed0();

    private native long getMemoryRemaining0();

    static native long executeInAreaBegin(MemoryArea var0);

    private static native void executeInAreaEnd(long var0);

    static native boolean isSoftSubsetLExcludeNhOn0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        MemoryArea memoryArea = this;
        synchronized (memoryArea) {
            if (this.objectFinalized) {
                System.err.println("MemoryArea.finalize() trying to finalize a finalized memory area: " + this);
            }
            this.objectFinalized = true;
            return;
        }
    }
}

