/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.ScopedMemory;
import javax.realtime.SizeEstimator;

public class LTMemory
extends ScopedMemory {
    long initialSize;
    long maximumSize;
    private boolean memoryInitialized = false;

    public LTMemory(long l) {
        this(l, l);
    }

    public LTMemory(long l, Runnable runnable) {
        this(l, l, runnable);
    }

    public LTMemory(SizeEstimator sizeEstimator) {
        this(sizeEstimator, sizeEstimator);
    }

    public LTMemory(SizeEstimator sizeEstimator, Runnable runnable) {
        this(sizeEstimator, sizeEstimator, runnable);
    }

    public LTMemory(long l, long l2) {
        this(l, l2, null);
    }

    public LTMemory(long l, long l2, Runnable runnable) {
        super(l, runnable);
        this.init(l, l2, runnable);
    }

    private void init(long l, long l2, Runnable runnable) {
        if (l > l2) {
            throw new IllegalArgumentException("Initial memory size is greater than Maximum memory size");
        }
        this.initialSize = l;
        this.maximumSize = l2;
        this.memorySize = l2;
        this.initScoped(this.memorySize);
        this.memoryInitialized = true;
    }

    public LTMemory(SizeEstimator sizeEstimator, SizeEstimator sizeEstimator2) {
        this(sizeEstimator, sizeEstimator2, null);
    }

    public LTMemory(SizeEstimator sizeEstimator, SizeEstimator sizeEstimator2, Runnable runnable) {
        super(sizeEstimator, runnable);
        if (sizeEstimator2 == null) {
            throw new IllegalArgumentException("Null maximum size");
        }
        this.init(sizeEstimator.getEstimate(), sizeEstimator2.getEstimate(), runnable);
    }

    void internalResize(long l, long l2) {
        super.internalResize(l, l2);
        this.maximumSize = l2;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public String toString() {
        return "(LTMemory) " + super.toString();
    }

    protected void finalize() throws Throwable {
        if (this.memoryInitialized) {
            super.finalize();
        }
    }
}

