/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.RelativeTime;

public abstract class HighResolutionTime
implements Comparable,
Cloneable {
    static final int MAX_NANOS = 999999;
    private static RelativeTime heapModeScratch = new RelativeTime();
    private static RelativeTime nhModeScratch = new RelativeTime();
    Clock clock;
    long milliseconds;
    int nanoseconds;

    HighResolutionTime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForObject(Object object, HighResolutionTime highResolutionTime) throws InterruptedException {
        int n;
        long l;
        if (highResolutionTime instanceof RelativeTime) {
            if (RelativeTime.isNegative((RelativeTime)highResolutionTime)) {
                throw new IllegalArgumentException("Relative time less than zero");
            }
            l = highResolutionTime.getMilliseconds();
            n = highResolutionTime.getNanoseconds();
        } else {
            if (Thread.currentThread() instanceof NoHeapRealtimeThread) {
                RelativeTime relativeTime = nhModeScratch;
                synchronized (relativeTime) {
                    RelativeTime relativeTime2 = highResolutionTime.relative(Clock.getRealtimeClock(), nhModeScratch);
                    l = relativeTime2.getMilliseconds();
                    n = relativeTime2.getNanoseconds();
                }
            }
            RelativeTime relativeTime = heapModeScratch;
            synchronized (relativeTime) {
                RelativeTime relativeTime3 = highResolutionTime.relative(Clock.getRealtimeClock(), heapModeScratch);
                l = relativeTime3.getMilliseconds();
                n = relativeTime3.getNanoseconds();
            }
            if (l < 0L || l == 0L && n <= 0) {
                return;
            }
        }
        object.wait(l, n);
    }

    static boolean willOverrun(long l, long l2) {
        if (l >= 0L && l2 <= 0L) {
            return false;
        }
        if (l <= 0L && l2 >= 0L) {
            return false;
        }
        long l3 = l + l2;
        return l > 0L ? l3 < l || l3 < l2 : l3 > l || l3 > l2;
    }

    static boolean willOverrun(long l, long l2, long l3) {
        if (HighResolutionTime.willOverrun(l, l2)) {
            return true;
        }
        return HighResolutionTime.willOverrun(l + l2, l3 / 1000000L);
    }

    public abstract AbsoluteTime absolute(Clock var1);

    public abstract AbsoluteTime absolute(Clock var1, AbsoluteTime var2);

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("clone() not supported for Object class");
        }
        return object;
    }

    public int compareTo(HighResolutionTime highResolutionTime) {
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("Null time value");
        }
        if (!this.getClass().equals(highResolutionTime.getClass())) {
            throw new ClassCastException();
        }
        if (this.getClock() != highResolutionTime.getClock()) {
            throw new IllegalArgumentException("Clocks don't match");
        }
        long l = highResolutionTime.getMilliseconds();
        int n = highResolutionTime.getNanoseconds();
        long l2 = this.milliseconds - l;
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        int n2 = this.nanoseconds - n;
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 0) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.getClass().equals(object.getClass())) {
            return this.compareTo((HighResolutionTime)object);
        }
        throw new ClassCastException();
    }

    public boolean equals(HighResolutionTime highResolutionTime) {
        Class<?> clazz;
        long l = highResolutionTime.getMilliseconds();
        int n = highResolutionTime.getNanoseconds();
        long l2 = this.milliseconds - l;
        int n2 = this.nanoseconds - n;
        if (n2 != 0) {
            return false;
        }
        if (l2 != 0L) {
            return false;
        }
        if (!highResolutionTime.getClock().equals(this.clock)) {
            return false;
        }
        Class<?> clazz2 = this.getClass();
        return clazz2.equals(clazz = highResolutionTime.getClass());
    }

    public boolean equals(Object object) {
        if (object instanceof HighResolutionTime) {
            return this.equals((HighResolutionTime)object);
        }
        return false;
    }

    public Clock getClock() {
        return this.clock;
    }

    public final long getMilliseconds() {
        return this.milliseconds;
    }

    public final int getNanoseconds() {
        return this.nanoseconds;
    }

    final long getTotalNanoseconds() {
        return this.getMilliseconds() * 1000000L + (long)this.getNanoseconds();
    }

    public int hashCode() {
        int n = (int)(this.milliseconds & 0xFFFFFFFFFFFFFFFFL) | (int)(this.milliseconds >> 32 & 0xFFFFFFFFFFFFFFFFL) | this.nanoseconds;
        return n;
    }

    final void internalSet(HighResolutionTime highResolutionTime) {
        if (highResolutionTime == null || !this.getClass().isAssignableFrom(highResolutionTime.getClass())) {
            throw new IllegalArgumentException("Object types must match");
        }
        this.set(highResolutionTime.getMilliseconds(), highResolutionTime.getNanoseconds());
    }

    final boolean isMax() {
        return this.milliseconds == Long.MAX_VALUE && this.nanoseconds == 999999;
    }

    public abstract RelativeTime relative(Clock var1);

    public abstract RelativeTime relative(Clock var1, RelativeTime var2);

    public void set(HighResolutionTime highResolutionTime) {
        if (highResolutionTime == null) {
            throw new IllegalArgumentException("Null time value passed to set method in HighResolutionTime");
        }
        if (!highResolutionTime.getClass().equals(this.getClass())) {
            throw new ClassCastException("HighResolutionTime.set(HighResolutionTime time) can only operate on matching types");
        }
        this.set(highResolutionTime.getMilliseconds(), highResolutionTime.getNanoseconds());
    }

    public void set(long l) {
        this.set(l, 0);
    }

    public void set(long l, int n) {
        this.set(l, n, this.clock, true);
    }

    void set(long l, int n, Clock clock) {
        this.set(l, n);
        this.clock = clock;
    }

    void set(long l, long l2, Clock clock, boolean bl) {
        if (HighResolutionTime.willOverrun(l, l2 / 1000000L)) {
            if (bl) {
                throw new IllegalArgumentException("Arithmetic overflow");
            }
            throw new ArithmeticException();
        }
        this.milliseconds = l + l2 / 1000000L;
        this.nanoseconds = (int)(l2 % 1000000L);
        if (this.milliseconds > 0L && this.nanoseconds < 0) {
            --this.milliseconds;
            this.nanoseconds += 1000000;
        } else if (this.milliseconds < 0L && this.nanoseconds > 0) {
            ++this.milliseconds;
            this.nanoseconds -= 1000000;
        }
        this.clock = clock;
    }

    void subtract(long l, int n) {
        if (l == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        if (HighResolutionTime.willOverrun(this.milliseconds, -l)) {
            throw new ArithmeticException();
        }
        this.set(this.milliseconds - l, (long)this.nanoseconds - (long)n, this.clock, false);
    }

    boolean isZero() {
        return this.milliseconds == 0L && this.nanoseconds == 0;
    }
}

