/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.AsyncEventHandler;
import javax.realtime.HighResolutionTime;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;

public class AperiodicParameters
extends ReleaseParameters {
    public static final String arrivalTimeQueueOverflowExcept = "arrivalTimeQueueOverflowExcept";
    public static final String arrivalTimeQueueOverflowIgnore = "arrivalTimeQueueOverflowIgnore";
    public static final String arrivalTimeQueueOverflowReplace = "arrivalTimeQueueOverflowReplace";
    public static final String arrivalTimeQueueOverflowSave = "arrivalTimeQueueOverflowSave";
    static final long DEFAULT_DEADLINE_MS = Long.MAX_VALUE;
    static final int DEFAULT_DEADLINE_NS = 999999;
    private String arrivalTimeQueueOverflowBehavior = arrivalTimeQueueOverflowSave;
    private int initialArrivalTimeQueueLength = 0;

    public AperiodicParameters() {
        this(null, null, null, null);
    }

    public AperiodicParameters(RelativeTime relativeTime, RelativeTime relativeTime2, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this(relativeTime, relativeTime2, null, asyncEventHandler, asyncEventHandler2);
    }

    public AperiodicParameters(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        if (relativeTime == null) {
            relativeTime = new RelativeTime(0L, 0);
        }
        if (relativeTime2 == null) {
            relativeTime2 = new RelativeTime(Long.MAX_VALUE, 999999);
        }
        this.checkCost(relativeTime);
        this.checkDeadline(relativeTime2);
        relativeTime3 = this.checkBlockingTime(relativeTime3);
        this.internalSetCostNoCheck(relativeTime);
        this.internalSetDeadlineNoCheck(relativeTime2);
        this.internalSetBlockingNoCheck(relativeTime3);
        this.internalSetCostOverrunHandler(asyncEventHandler);
        this.internalSetMissHandlerUnchecked(asyncEventHandler2);
    }

    void internalSetAll(RelativeTime relativeTime, RelativeTime relativeTime2, AsyncEventHandler asyncEventHandler, AsyncEventHandler asyncEventHandler2) {
        this.internalSetCostNoCheck(relativeTime);
        this.internalSetDeadlineNoCheck(relativeTime2);
        this.internalSetCostOverrunHandler(asyncEventHandler);
        this.internalSetMissHandlerUnchecked(asyncEventHandler2);
    }

    public String getArrivalTimeQueueOverflowBehavior() {
        return this.arrivalTimeQueueOverflowBehavior;
    }

    public int getInitialArrivalTimeQueueLength() {
        return this.initialArrivalTimeQueueLength;
    }

    public void setArrivalTimeQueueOverflowBehavior(String string) {
        if (string != arrivalTimeQueueOverflowExcept && string != arrivalTimeQueueOverflowIgnore && string != arrivalTimeQueueOverflowReplace && string != arrivalTimeQueueOverflowSave) {
            throw new IllegalArgumentException("illegal behavior object, use one of the SporadicParameters.arrivalTimeQueueOverflow<behavior> objects");
        }
        this.arrivalTimeQueueOverflowBehavior = string;
    }

    public boolean setIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2) {
        return false;
    }

    public boolean setAllIfFeasible(RelativeTime relativeTime, RelativeTime relativeTime2, RelativeTime relativeTime3) {
        return false;
    }

    public void setInitialArrivalTimeQueueLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial queue length");
        }
        this.initialArrivalTimeQueueLength = n;
    }

    boolean isMaxDeadline() {
        return this.getDeadlineMillis() == Long.MAX_VALUE && this.getDeadlineNanos() == 999999;
    }

    public void setAbsoluteDeadline(AbsoluteTime absoluteTime, AbsoluteTime absoluteTime2) {
        if (this.isMaxDeadline()) {
            absoluteTime2.set(Long.MAX_VALUE, 999999);
        } else {
            absoluteTime.add(this.getDeadline(), absoluteTime2);
        }
    }

    static boolean isDefaultDeadline(HighResolutionTime highResolutionTime) {
        return highResolutionTime.getMilliseconds() == Long.MAX_VALUE && highResolutionTime.getNanoseconds() == 999999;
    }
}

