/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.util.BitSet;
import javax.realtime.AsyncEvent;
import javax.realtime.AtomicReference;
import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.ImmortalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.ProcessorAffinityException;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThread;

public class AffinitySet {
    final BitSet affinityBitSet = new BitSet(AffinitySet.getMaximumProcessorNumber());
    private static AtomicReference listOfAffinitySets = new AtomicReference(null);
    private AffinitySet nextAffinitySet = null;
    private static AsyncEvent processorRemoved;
    private static AsyncEvent processorAdded;
    static final int ALL_PROCESSORS_INDEX = 4;
    private static final AffinitySet[] PREDEFINED_SETS;
    private static AffinitySet nhDefault;
    private static AffinitySet hDefault;
    private static AffinitySet javaThreadDefault;
    private static AffinitySet pgDefault;
    private static final AllocateAffinitySet hAllocateAffinitySet;
    private static final AllocateAffinitySet nhAllocateAffinitySet;
    static BitSet workingBitSetForNH;
    static BitSet workingBitSetForH;

    static int bitSetCardinality(BitSet bitSet) {
        int n = bitSet.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            ++n2;
        }
        return n2;
    }

    static final boolean checkAffinitySet(BitSet bitSet) {
        if (bitSet.length() >= 64) {
            return false;
        }
        return AffinitySet.validAffinitySet(bitSet);
    }

    private static AffinitySet findAffinitySet(BitSet bitSet) {
        AffinitySet affinitySet;
        AffinitySet affinitySet2 = affinitySet = (AffinitySet)listOfAffinitySets.get();
        while (affinitySet2 != null) {
            if (affinitySet2.affinityBitSet.equals(bitSet)) {
                return affinitySet2;
            }
            if ((AffinitySet)listOfAffinitySets.get() == affinitySet) {
                affinitySet2 = affinitySet2.nextAffinitySet;
                continue;
            }
            affinitySet2 = affinitySet = (AffinitySet)listOfAffinitySets.get();
        }
        return null;
    }

    private static AffinitySet findAffinitySet(long l) {
        AffinitySet affinitySet;
        AffinitySet affinitySet2 = affinitySet = (AffinitySet)listOfAffinitySets.get();
        while (affinitySet2 != null) {
            if (affinitySet2.toLong() == l) {
                return affinitySet2;
            }
            if ((AffinitySet)listOfAffinitySets.get() == affinitySet) {
                affinitySet2 = affinitySet2.nextAffinitySet;
                continue;
            }
            affinitySet2 = affinitySet = (AffinitySet)listOfAffinitySets.get();
        }
        return null;
    }

    public static AffinitySet generate(BitSet bitSet) {
        if (bitSet == null) {
            throw new NullPointerException("Null bitSet");
        }
        if (!AffinitySet.validAffinitySet(bitSet)) {
            throw new IllegalArgumentException("Affinity set includes unavailable processors");
        }
        if (AffinitySet.bitSetCardinality(bitSet) > 1 && !AffinitySet.isPredefinedBitset(bitSet)) {
            throw new IllegalArgumentException("bitSet contains multiple processors and is not pre-registered");
        }
        return AffinitySet.generateNoCheck(bitSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AffinitySet generateNoCheck(BitSet bitSet) {
        AffinitySet affinitySet;
        AffinitySet affinitySet2 = AffinitySet.findAffinitySet(bitSet);
        if (affinitySet2 != null) {
            return affinitySet2;
        }
        AllocateAffinitySet allocateAffinitySet = Thread.currentThread() instanceof NoHeapRealtimeThread ? nhAllocateAffinitySet : hAllocateAffinitySet;
        Object object = allocateAffinitySet;
        synchronized (object) {
            allocateAffinitySet.bitSet = bitSet;
            if (MemoryArea.isSoftSubsetLExcludeNhOn0()) {
                allocateAffinitySet.run();
            } else {
                ImmortalMemory.instance().executeInArea(allocateAffinitySet);
            }
            affinitySet = allocateAffinitySet.rVal;
        }
        do {
            affinitySet.nextAffinitySet = object = (AffinitySet)listOfAffinitySets.get();
        } while (!listOfAffinitySets.compareAndSet(object, affinitySet));
        return affinitySet;
    }

    public static final AffinitySet getAffinitySet(BoundAsyncEventHandler boundAsyncEventHandler) {
        return AffinitySet.getAffinitySet(boundAsyncEventHandler.aehImpl.handlerThread);
    }

    public static final AffinitySet getAffinitySet(Thread thread) {
        if (thread instanceof RealtimeThread) {
            return ((RealtimeThread)thread).getAffinity();
        }
        long l = RealtimeSystem.getAffinityOfThread0(thread);
        AffinitySet affinitySet = AffinitySet.findAffinitySet(l);
        return affinitySet;
    }

    public static final BitSet getAvailableProcessors() {
        return AffinitySet.getAvailableProcessors(null);
    }

    public static final BitSet getAvailableProcessors(BitSet bitSet) {
        int n = RealtimeSystem.getMPCount0();
        if (bitSet == null) {
            bitSet = new BitSet(n);
        }
        for (int i = 0; i < n; ++i) {
            bitSet.set(i);
        }
        return bitSet;
    }

    static final AffinitySet getAllProcessors() {
        return AffinitySet.generateNoCheck(AffinitySet.getAvailableProcessors());
    }

    private static void initSets() {
        if (PREDEFINED_SETS[4] == null) {
            AffinitySet.PREDEFINED_SETS[4] = AffinitySet.getAllProcessors();
            nhDefault = AffinitySet.PREDEFINED_SETS[0] = PREDEFINED_SETS[4];
            hDefault = AffinitySet.PREDEFINED_SETS[1] = PREDEFINED_SETS[4];
            javaThreadDefault = AffinitySet.PREDEFINED_SETS[2] = PREDEFINED_SETS[4];
            pgDefault = AffinitySet.PREDEFINED_SETS[3] = AffinitySet.generateNoCheck(AffinitySet.getFirstProcessor());
        }
    }

    private static BitSet getFirstProcessor() {
        BitSet bitSet = null;
        int n = RealtimeSystem.getMPCount0();
        if (bitSet == null) {
            bitSet = new BitSet(n);
        }
        bitSet.set(0);
        return bitSet;
    }

    public static final AffinitySet getPGroupDefaultAffinity() {
        AffinitySet.initSets();
        return pgDefault;
    }

    public static final AffinitySet getHeapSoDefaultAffinity() {
        AffinitySet.initSets();
        return hDefault;
    }

    public static final AffinitySet getJavaThreadDefaultAffinity() {
        AffinitySet.initSets();
        return javaThreadDefault;
    }

    static int getMaximumProcessorNumber() {
        return RealtimeSystem.getMPCount0();
    }

    public static final AffinitySet getNoHeapSoDefaultAffinity() {
        AffinitySet.initSets();
        return nhDefault;
    }

    public static AsyncEvent getProcessorAddedEvent() {
        return processorAdded;
    }

    public static AsyncEvent getProcessorRemovedEvent() {
        return processorRemoved;
    }

    static boolean isPredefinedBitset(BitSet bitSet) {
        AffinitySet.initSets();
        for (int i = 0; i < PREDEFINED_SETS.length; ++i) {
            if (!AffinitySet.PREDEFINED_SETS[i].affinityBitSet.equals(bitSet)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isAffinityChangeNotificationSupported() {
        return false;
    }

    public static boolean isSetAffinitySupported() {
        return true;
    }

    static boolean setAffinity(Thread thread, AffinitySet affinitySet) {
        if (thread.isAlive()) {
            return RealtimeSystem.setAffinityOfThread0(thread, affinitySet.toLong());
        }
        return true;
    }

    static final void setHeapSoDefaultAffinity(AffinitySet affinitySet) {
        if (affinitySet == null) {
            throw new NullPointerException("Null set");
        }
        if (AffinitySet.checkAffinitySet(affinitySet.affinityBitSet)) {
            throw new IllegalArgumentException("The affinity set is not valid for this operation");
        }
        hDefault = affinitySet;
    }

    static final void setJavaThreadDefaultAffinity(AffinitySet affinitySet) {
        if (affinitySet == null) {
            throw new NullPointerException("Null set");
        }
        if (AffinitySet.checkAffinitySet(affinitySet.affinityBitSet)) {
            throw new IllegalArgumentException("The affinity set is not valid for this operation");
        }
        javaThreadDefault = affinitySet;
    }

    static final void setNoHeapSoDefaultAffinity(AffinitySet affinitySet) {
        if (affinitySet == null) {
            throw new NullPointerException("Null set");
        }
        if (AffinitySet.checkAffinitySet(affinitySet.affinityBitSet)) {
            throw new IllegalArgumentException("The affinity set is not valid for this operation");
        }
        nhDefault = affinitySet;
    }

    static final void setPGroupDefaultAffinity(AffinitySet affinitySet) {
        if (affinitySet == null) {
            throw new NullPointerException("Null set");
        }
        if (AffinitySet.checkAffinitySet(affinitySet.affinityBitSet)) {
            throw new IllegalArgumentException("The affinity set is not valid for this operation");
        }
        pgDefault = affinitySet;
    }

    public static void setProcessorAddedEvent(AsyncEvent asyncEvent) {
        if (!AffinitySet.isAffinityChangeNotificationSupported()) {
            throw new UnsupportedOperationException("Change notification is not supported");
        }
        if (asyncEvent != null && !MemoryArea.isSoftSubsetLExcludeNhOn0() && !(MemoryArea.getMemoryArea(asyncEvent) instanceof ImmortalMemory)) {
            throw new IllegalArgumentException("event must be allocated in immortal memory");
        }
        processorAdded = asyncEvent;
    }

    public static final void setProcessorAffinity(AffinitySet affinitySet, BoundAsyncEventHandler boundAsyncEventHandler) throws ProcessorAffinityException {
        affinitySet.internalAdd(boundAsyncEventHandler.aehImpl.handlerThread);
    }

    public static final void setProcessorAffinity(AffinitySet affinitySet, Thread thread) throws ProcessorAffinityException {
        affinitySet.internalAdd(thread);
    }

    public static void setProcessorRemovedEvent(AsyncEvent asyncEvent) {
        if (!AffinitySet.isAffinityChangeNotificationSupported()) {
            throw new UnsupportedOperationException("Change notification is not supported");
        }
        if (asyncEvent != null && !MemoryArea.isSoftSubsetLExcludeNhOn0() && !(MemoryArea.getMemoryArea(asyncEvent) instanceof ImmortalMemory)) {
            throw new IllegalArgumentException("event must be allocated in immortal memory");
        }
        processorRemoved = asyncEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validAffinitySet(BitSet bitSet) {
        BitSet bitSet2;
        int n = AffinitySet.bitSetCardinality(bitSet);
        if (n == 0) {
            return false;
        }
        if (n > RealtimeSystem.getMPCount0()) {
            return false;
        }
        BitSet bitSet3 = bitSet2 = Thread.currentThread() instanceof NoHeapRealtimeThread ? workingBitSetForNH : workingBitSetForH;
        synchronized (bitSet3) {
            bitSet2 = AffinitySet.getAvailableProcessors(bitSet2);
            for (int i = 0; i < bitSet.length(); ++i) {
                if (!bitSet.get(i) || bitSet2.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    private AffinitySet(BitSet bitSet) {
        this.affinityBitSet.or(bitSet);
    }

    private AffinitySet(AffinitySet affinitySet) {
        this(affinitySet.affinityBitSet);
    }

    final boolean containsTask(BoundAsyncEventHandler boundAsyncEventHandler) {
        if (boundAsyncEventHandler == null) {
            throw new NullPointerException("aeh is null");
        }
        return this.containsTask(boundAsyncEventHandler.aehImpl.handlerThread);
    }

    final boolean containsTask(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("thread is null");
        }
        if (thread instanceof RealtimeThread) {
            return ((RealtimeThread)thread).getAffinity() == this;
        }
        long l = RealtimeSystem.getAffinityOfThread0(thread);
        AffinitySet affinitySet = AffinitySet.findAffinitySet(l);
        return affinitySet != null;
    }

    public final BitSet getProcessors(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = new BitSet(this.affinityBitSet.size());
        } else {
            int n = bitSet.length();
            for (int i = 0; i < n; ++i) {
                bitSet.clear(i);
            }
        }
        bitSet.or(this.affinityBitSet);
        return bitSet;
    }

    public final BitSet getBitSet() {
        return this.getProcessors(null);
    }

    private void internalAdd(Thread thread) throws ProcessorAffinityException {
        RealtimeThread.setAffinity(thread, this);
    }

    public final boolean isProcessorInSet(int n) {
        return this.affinityBitSet.get(n);
    }

    public static AffinitySet[] getPredefinedAffinitySets(AffinitySet[] affinitySetArray) {
        if (affinitySetArray == null) {
            affinitySetArray = new AffinitySet[PREDEFINED_SETS.length];
        } else if (affinitySetArray.length < PREDEFINED_SETS.length) {
            throw new IllegalArgumentException("dest array is too short");
        }
        System.arraycopy(PREDEFINED_SETS, 0, affinitySetArray, 0, PREDEFINED_SETS.length);
        if (PREDEFINED_SETS.length < affinitySetArray.length) {
            for (int i = PREDEFINED_SETS.length; i < affinitySetArray.length; ++i) {
                affinitySetArray[i] = null;
            }
        }
        return affinitySetArray;
    }

    public static AffinitySet[] getPredefinedAffinitySets() {
        return AffinitySet.getPredefinedAffinitySets(null);
    }

    public static int getPredefinedAffinitySetCount() {
        return PREDEFINED_SETS.length;
    }

    long toLong() {
        long l = 0L;
        long l2 = 1L;
        for (int i = 0; i < 64; ++i) {
            if (this.affinityBitSet.get(i)) {
                l |= l2;
            }
            l2 <<= 1;
        }
        return l;
    }

    public String toString() {
        return "AffinitySet --" + this.affinityBitSet.toString();
    }

    static {
        PREDEFINED_SETS = new AffinitySet[5];
        hAllocateAffinitySet = new AllocateAffinitySet();
        nhAllocateAffinitySet = new AllocateAffinitySet();
        workingBitSetForNH = new BitSet(64);
        workingBitSetForH = new BitSet(64);
    }

    static class AllocateAffinitySet
    implements Runnable {
        BitSet bitSet;
        AffinitySet rVal;

        AllocateAffinitySet() {
        }

        public void run() {
            this.rVal = new AffinitySet(this.bitSet);
        }
    }
}

