/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.util.Date;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.RelativeTime;

public class AbsoluteTime
extends HighResolutionTime {
    public AbsoluteTime() {
        this(0L, 0, null);
    }

    public AbsoluteTime(Clock clock) {
        this(0L, 0, clock);
    }

    public AbsoluteTime(AbsoluteTime absoluteTime) {
        this(absoluteTime, null);
    }

    public AbsoluteTime(AbsoluteTime absoluteTime, Clock clock) {
        if (absoluteTime == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        this.clock = clock == null ? Clock.getRealtimeClock() : clock;
        this.internalSet(absoluteTime);
    }

    public AbsoluteTime(Date date, Clock clock) {
        if (date == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        this.set(date.getTime(), 0, clock == null ? Clock.getRealtimeClock() : clock);
    }

    public AbsoluteTime(Date date) {
        this(date, null);
    }

    public AbsoluteTime(long l, int n) {
        this(l, n, null);
    }

    public AbsoluteTime(long l, int n, Clock clock) {
        this.set(l, n, clock == null ? Clock.getRealtimeClock() : clock);
    }

    public AbsoluteTime absolute(Clock clock, AbsoluteTime absoluteTime) {
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        absoluteTime.set(this.getMilliseconds(), this.getNanoseconds(), clock == null ? Clock.getRealtimeClock() : clock);
        return absoluteTime;
    }

    public AbsoluteTime absolute(Clock clock) {
        return this.absolute(clock, null);
    }

    public RelativeTime relative(Clock clock, RelativeTime relativeTime) {
        if (clock == null) {
            clock = Clock.getRealtimeClock();
        }
        if (relativeTime == null) {
            relativeTime = new RelativeTime();
        }
        AbsoluteTime absoluteTime = clock.getTime();
        absoluteTime = absoluteTime.absolute(this.getClock());
        this.subtract(absoluteTime, relativeTime);
        relativeTime.clock = clock;
        return relativeTime;
    }

    public RelativeTime relative(Clock clock) {
        return this.relative(clock, null);
    }

    public AbsoluteTime add(long l, int n, AbsoluteTime absoluteTime) {
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        if (HighResolutionTime.willOverrun(this.milliseconds, l)) {
            throw new ArithmeticException("Adding " + l + " ms to " + this.toString() + " will cause an arithmetic overflow.");
        }
        absoluteTime.set(this.milliseconds + l, this.nanoseconds + n, this.clock, false);
        return absoluteTime;
    }

    public AbsoluteTime add(long l, int n) {
        return this.add(l, n, null);
    }

    public AbsoluteTime add(RelativeTime relativeTime, AbsoluteTime absoluteTime) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("null time");
        }
        if (this.clock != relativeTime.getClock()) {
            throw new IllegalArgumentException("Clocks don't match: " + this.clock + " : " + relativeTime.getClock());
        }
        return this.add(relativeTime.getMilliseconds(), relativeTime.getNanoseconds(), absoluteTime);
    }

    public AbsoluteTime add(RelativeTime relativeTime) {
        return this.add(relativeTime, null);
    }

    public Date getDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        date.setTime(this.milliseconds);
        return date;
    }

    public Date getDate() {
        return this.getDate(null);
    }

    public void set(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        this.set(date.getTime(), 0);
    }

    public RelativeTime subtract(AbsoluteTime absoluteTime, RelativeTime relativeTime) {
        if (absoluteTime == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        if (this.clock != absoluteTime.getClock()) {
            throw new IllegalArgumentException("Clocks don't match: " + this.clock + " : " + absoluteTime.getClock());
        }
        if (relativeTime == null) {
            relativeTime = new RelativeTime(this.milliseconds, this.nanoseconds, this.clock);
        } else {
            relativeTime.set(this.milliseconds, this.nanoseconds, this.clock);
        }
        relativeTime.subtract(absoluteTime.getMilliseconds(), absoluteTime.getNanoseconds());
        return relativeTime;
    }

    public RelativeTime subtract(AbsoluteTime absoluteTime) {
        return this.subtract(absoluteTime, null);
    }

    public AbsoluteTime subtract(RelativeTime relativeTime, AbsoluteTime absoluteTime) {
        if (relativeTime == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        if (this.clock != relativeTime.getClock()) {
            throw new IllegalArgumentException("Clocks don't match: " + this.clock + " : " + relativeTime.getClock());
        }
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime(this.milliseconds, this.nanoseconds, this.clock);
        } else {
            absoluteTime.set(this.milliseconds, this.nanoseconds, this.clock);
        }
        absoluteTime.subtract(relativeTime.getMilliseconds(), relativeTime.getNanoseconds());
        return absoluteTime;
    }

    AbsoluteTime subtract(long l, int n, AbsoluteTime absoluteTime) {
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime(this.milliseconds, this.nanoseconds, this.clock);
        } else {
            absoluteTime.set(this.milliseconds, this.nanoseconds, this.clock);
        }
        absoluteTime.subtract(l, n);
        return absoluteTime;
    }

    public AbsoluteTime subtract(RelativeTime relativeTime) {
        return this.subtract(relativeTime, null);
    }

    public String toString() {
        String string = "(" + this.getMilliseconds() + " ms, " + this.getNanoseconds() + " ns)";
        return string;
    }
}

