/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.lang.ref.WeakReference;
import javax.realtime.AbsoluteTime;
import javax.realtime.AffinitySet;
import javax.realtime.AperiodicParameters;
import javax.realtime.ArrivalElement;
import javax.realtime.ArrivalTimeQueueOverflowException;
import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.BoundAsyncEventHandler;
import javax.realtime.Clock;
import javax.realtime.DeadlineQueue;
import javax.realtime.HeapMemory;
import javax.realtime.HighResolutionTime;
import javax.realtime.MITViolationException;
import javax.realtime.MemoryAccessError;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryParameters;
import javax.realtime.NoDeadlineParams;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.OneShotTimer;
import javax.realtime.ProcessingGroupParameters;
import javax.realtime.ProcessorAffinityException;
import javax.realtime.RealtimeSystem;
import javax.realtime.RealtimeThread;
import javax.realtime.RelativeTime;
import javax.realtime.ReleaseParameters;
import javax.realtime.RichAsyncEventHandler;
import javax.realtime.Schedulable;
import javax.realtime.Scheduler;
import javax.realtime.SchedulingParameters;
import javax.realtime.ScopedRegion;
import javax.realtime.SporadicParameters;

class AEHImpl
implements Schedulable {
    CallHandler callHandler;
    Object countLock = new Object();
    int fireCount = 0;
    private volatile boolean becomeNfFlag = false;
    RealtimeThread handlerThread;
    MemoryArea initMa;
    volatile boolean endThreadFlag = false;
    private WeakReference peerAEH = null;
    private Runnable logic = null;
    private ArrivalTimeQueueOverflowException arrivalTimeQueueOverflowException = new ArrivalTimeQueueOverflowException("arrival time queue overvflow");
    private MITViolationException mitViolationException = new MITViolationException("mit violation");
    private AbsoluteTime mitTargetTime = new AbsoluteTime(Long.MIN_VALUE, -999999);
    private RelativeTime mitWaitTime = new RelativeTime();
    private AbsoluteTime currentTimeForAC = new AbsoluteTime();
    private AbsoluteTime currentTimeForGAD = new AbsoluteTime();
    private AbsoluteTime currentTimeForWFM = new AbsoluteTime();
    private AbsoluteTime lastArrivalTime = new AbsoluteTime(Long.MIN_VALUE, -999999);
    private RelativeTime interarivalTime = new RelativeTime();
    private DeadlineQueue deadlineQueue = new DeadlineQueue();
    private ArrivalElement currentDeadline = null;
    private AbsoluteTime currentTimeDummy = new AbsoluteTime();
    private OneShotTimer deadlineTimer = null;
    private boolean carryFireArgPayload = false;
    private boolean reenterMemory;
    private boolean enterPerHae;
    private int handlerDepth;
    private boolean associated = false;
    private Object fireabilityLock = new Object();
    private boolean running = false;
    private boolean droppedOut = false;
    private volatile int handlerState = 0;
    private static final String[] handlerStateString = new String[]{"Unstarted", "AEH run loop entered", "entered get and dec", "in get and dec after countLock.wait", "after get and dec", "finalize flag true leaving loop", "after setScopeDaemon false", "got peer aeh", "aeh == null.  Finalization is progress", "about to setScopeDaemon true after running handleAsyncEvent", "completed setScopeDaemon true after running handleAsyncEvent", "about to meet working deadline", "returned from meet working deadline", "mainScopeIsAllDaemon returned true", "about to wait for MIT", "returned from wait for MIT", "about to drop out of main loop", "about to setFireable(false) from becomeQuiet", "about to wait in get and dec"};
    private boolean shuttingDown = false;

    public AEHImpl(AsyncEventHandler asyncEventHandler, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, MemoryArea memoryArea, ProcessingGroupParameters processingGroupParameters, boolean bl, boolean bl2, Runnable runnable, boolean bl3) {
        if (bl) {
            if (memoryArea != null && memoryArea instanceof HeapMemory) {
                throw new IllegalArgumentException("Non-heap cannot run with heap area");
            }
            if (MemoryArea.getMemoryArea(this) instanceof HeapMemory) {
                throw new IllegalArgumentException("Non-heap cannot run with heap object");
            }
            if (runnable != null && MemoryArea.getMemoryArea(runnable) instanceof HeapMemory) {
                throw new IllegalArgumentException("Non-heap cannot run with heap logic");
            }
        }
        this.peerAEH = new WeakReference<AsyncEventHandler>(asyncEventHandler);
        this.carryFireArgPayload = bl3;
        this.callHandler = new CallHandler(bl3);
        this.reenterMemory = bl2;
        this.logic = runnable;
        MemoryArea memoryArea2 = RealtimeThread.getCurrentMemoryArea();
        if (memoryArea != null) {
            this.initMa = memoryArea;
            this.enterPerHae = bl2 && memoryArea != memoryArea2;
        } else {
            this.initMa = memoryArea2;
            this.enterPerHae = false;
        }
        this.handlerDepth = memoryArea2 instanceof ScopedRegion ? RealtimeThread.getMemoryAreaStackDepth() - 1 : 0;
        try {
            this.handlerThread = bl ? new NoHeapRealtimeThread(schedulingParameters, releaseParameters, memoryParameters, this.enterPerHae ? memoryArea2 : this.initMa, processingGroupParameters, this, true, this) : new RealtimeThread(schedulingParameters, releaseParameters, memoryParameters, this.enterPerHae ? memoryArea2 : this.initMa, processingGroupParameters, this, true, this);
            if (this.enterPerHae) {
                this.handlerThread.lockInitMa(this.initMa);
            }
        }
        catch (MemoryAccessError memoryAccessError) {
            throw new IllegalArgumentException("Non-heap entity using heap.");
        }
        if (!(asyncEventHandler instanceof BoundAsyncEventHandler)) {
            try {
                AffinitySet.setProcessorAffinity(bl ? AffinitySet.getNoHeapSoDefaultAffinity() : AffinitySet.getHeapSoDefaultAffinity(), this.handlerThread);
            }
            catch (ProcessorAffinityException processorAffinityException) {
                processorAffinityException.printStackTrace();
            }
        }
        this.handlerThread.setDaemon(true);
        this.handlerThread.setName("AEH_handler_thread: " + this.handlerThread.hashCode());
        if (releaseParameters instanceof NoDeadlineParams) {
            this.deadlineTimer = null;
        } else {
            this.deadlineTimer = new OneShotTimer(this.currentTimeDummy, null){

                public String toString() {
                    return "AEH_deadlineTimer " + super.toString();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                Throwable internalFire(Object object, int n, boolean bl) {
                    Throwable throwable;
                    block8: {
                        throwable = null;
                        try {
                            ArrivalElement arrivalElement;
                            if (AEHImpl.this.currentDeadline == null) {
                                System.err.println("AEH deadline timer. Null deadline");
                                break block8;
                            }
                            if (!AEHImpl.this.currentDeadline.semTryWait()) {
                                System.err.println("AEH deadline timer conflicted on semaphore");
                                break block8;
                            }
                            OneShotTimer oneShotTimer = AEHImpl.this.deadlineTimer;
                            synchronized (oneShotTimer) {
                                arrivalElement = AEHImpl.this.currentDeadline;
                                AEHImpl.this.currentDeadline = ((AEHImpl)AEHImpl.this).currentDeadline.next;
                            }
                            arrivalElement.semPost();
                            if (AEHImpl.this.currentDeadline != null) {
                                this.reschedule(((AEHImpl)AEHImpl.this).currentDeadline.time);
                                this.start();
                            }
                            AEHImpl.this.handlerThread.deadlineEvent.fire();
                        }
                        catch (Throwable throwable2) {
                            System.err.println("**** Exception in firing deadline timer for AEH");
                        }
                    }
                    return throwable;
                }
            };
            this.deadlineTimer.lockAsScopeDaemon(true);
        }
    }

    private boolean startThread() {
        if (this.handlerThread == null) {
            throw new RuntimeException("Trying to start an AEH thread that has been terminated");
        }
        if (!this.handlerThread.isAlive()) {
            this.running = false;
            this.handlerThread.start();
            try {
                this.waitForEnterRun();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associate() {
        Object object = this;
        synchronized (object) {
            if (this.associated) {
                throw new RuntimeException("AEHImpl redundant associate()");
            }
            this.associated = true;
        }
        object = this.countLock;
        synchronized (object) {
            this.endThreadFlag = false;
            this.becomeNfFlag = false;
        }
        boolean bl = this.startThread();
        if (Thread.currentThread() == this.handlerThread) {
            this.handlerThread.setFireable(true, this.reenterMemory);
        } else {
            Object object2 = this.fireabilityLock;
            synchronized (object2) {
                this.handlerThread.setFireable(true, this.reenterMemory);
                if (!bl) {
                    if (this.handlerThread.hasNonDefaultIma()) {
                        try {
                            this.waitForEnterRun();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        try {
                            this.handlerThread.waitTilFireable();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEnterRun() throws InterruptedException {
        AEHImpl aEHImpl = this;
        synchronized (aEHImpl) {
            while (!this.running) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deAssociate(boolean bl) {
        Object object = this;
        synchronized (object) {
            if (!this.associated) {
                throw new RuntimeException("redundant deAssociate ");
            }
            this.associated = false;
        }
        object = this.fireabilityLock;
        synchronized (object) {
            Object object2;
            if (this.handlerThread != null && this.handlerThread.isAlive() && !this.endThreadFlag) {
                if (!this.handlerThread.isFireable()) {
                    System.err.println("Attempt to deAssociate() a non-fireable thread");
                }
                object2 = this.countLock;
                synchronized (object2) {
                    this.becomeNfFlag = true;
                }
                if (Thread.currentThread() != this.handlerThread) {
                    if (this.handlerThread.isScopeDaemon()) {
                        this.wakeHandlerThread();
                    }
                    if (bl) {
                        while (true) {
                            try {
                                this.handlerThread.waitTilNotFireable();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            object2 = null;
            AEHImpl aEHImpl = this;
            synchronized (aEHImpl) {
                object2 = this.deadlineTimer;
            }
            if (object2 != null) {
                ((AsyncEvent)object2).internalSetHandler(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeQuiet() {
        Object object = this.countLock;
        synchronized (object) {
            if (this.fireCount > 0) {
                return;
            }
            this.becomeNfFlag = false;
        }
        if (this.handlerThread == null) {
            System.err.println("Logic error in AEHImpl.becomeQuiet()");
        } else if (!this.endThreadFlag) {
            this.handlerState = 17;
            this.handlerThread.setFireable(false, this.reenterMemory);
        } else {
            System.err.println("becomeQuiet for AEH with endThreadFlag == true");
            this.handlerState = 17;
        }
    }

    void setDaemon(boolean bl) {
        if (this.handlerThread == null) {
            System.err.println("Logic error in AEHImpl.setDaemonMode()");
        } else {
            RealtimeSystem.getSecurityManager().checkAEHSetDaemon();
            this.handlerThread.setDaemon(bl);
        }
    }

    boolean isDaemon() {
        return this.handlerThread.isDaemon();
    }

    public void handleAsyncEvent() {
        if (this.logic != null) {
            this.logic.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handle(Object object, int n) throws RuntimeException, MITViolationException {
        if (this.endThreadFlag) {
            return;
        }
        if (n > this.handlerDepth) {
            object = RichAsyncEventHandler.INACCESSIBLE_DATA;
        }
        if (this.handlerThread != null && !this.handlerThread.isAlive()) {
            this.startThread();
        }
        Object object2 = this.countLock;
        synchronized (object2) {
            if (this.admissionControl(object)) {
                ++this.fireCount;
                this.countLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean admissionControl(Object object) throws RuntimeException, MITViolationException {
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        RelativeTime relativeTime = null;
        RelativeTime relativeTime2 = null;
        ArrivalElement arrivalElement = null;
        AperiodicParameters aperiodicParameters = null;
        SporadicParameters sporadicParameters = null;
        if (this.handlerThread.getReleaseParameters() instanceof AperiodicParameters) {
            aperiodicParameters = (AperiodicParameters)this.handlerThread.getReleaseParameters();
            relativeTime = aperiodicParameters.getDeadline();
            if (aperiodicParameters.getDeadlineMissHandler() != null && relativeTime != null) {
                bl = true;
            }
        }
        if (this.handlerThread.getReleaseParameters() instanceof SporadicParameters && (relativeTime2 = (sporadicParameters = (SporadicParameters)this.handlerThread.getReleaseParameters()).getMinimumInterarrival()) != null) {
            bl2 = true;
        }
        if (bl2 || bl) {
            Clock.getRealtimeClock().getTime(this.currentTimeForAC);
        }
        if (bl2) {
            if (this.lastArrivalTime.getMilliseconds() == Long.MIN_VALUE) {
                this.interarivalTime.set(relativeTime2);
            } else {
                this.currentTimeForAC.subtract(this.lastArrivalTime, this.interarivalTime);
            }
            if (this.interarivalTime.compareTo(relativeTime2) < 0) {
                object2 = sporadicParameters.getMitViolationBehavior();
                if (object2 == SporadicParameters.mitViolationExcept) {
                    throw (MITViolationException)this.mitViolationException.fillInStackTrace();
                }
                if (object2 == SporadicParameters.mitViolationIgnore) {
                    return false;
                }
                if (object2 == SporadicParameters.mitViolationReplace) {
                    ArrivalElement arrivalElement2;
                    if ((bl || this.carryFireArgPayload) && (arrivalElement2 = this.deadlineQueue.getTail()) != null) {
                        aperiodicParameters.setAbsoluteDeadline(this.currentTimeForAC, arrivalElement2.time);
                        if (this.carryFireArgPayload) {
                            arrivalElement2.payload = object;
                        }
                        if (this.currentDeadline == arrivalElement2 && this.deadlineTimer != null) {
                            this.deadlineTimer.reschedule(arrivalElement2.time);
                        }
                    }
                    return false;
                }
            }
        }
        if (bl && this.handlerThread.getReleaseParameters() instanceof AperiodicParameters && this.deadlineQueue.size() >= aperiodicParameters.getInitialArrivalTimeQueueLength()) {
            object2 = aperiodicParameters.getArrivalTimeQueueOverflowBehavior();
            if (object2 == AperiodicParameters.arrivalTimeQueueOverflowExcept) {
                throw (RuntimeException)this.arrivalTimeQueueOverflowException.fillInStackTrace();
            }
            if (object2 == AperiodicParameters.arrivalTimeQueueOverflowIgnore) {
                return false;
            }
            if (object2 == AperiodicParameters.arrivalTimeQueueOverflowReplace) {
                ArrivalElement arrivalElement3 = this.deadlineQueue.getTail();
                if (arrivalElement3 != null) {
                    aperiodicParameters.setAbsoluteDeadline(this.currentTimeForAC, arrivalElement3.time);
                    if (this.carryFireArgPayload) {
                        arrivalElement3.payload = object;
                    }
                    if (this.currentDeadline == arrivalElement3 && this.deadlineTimer != null) {
                        this.deadlineTimer.reschedule(arrivalElement3.time);
                    }
                }
                return false;
            }
        }
        if (this.deadlineTimer != null) {
            this.handlerThread.checkForHandlerUpdates();
        } else {
            System.out.println("AEHImpl admission control not setting the miss handler because deadlineTimer is null");
        }
        if (bl || this.carryFireArgPayload) {
            arrivalElement = this.deadlineQueue.newElement();
            if (arrivalElement == null) {
                System.err.println("AdmissionControl: OBJECT REQUISITION FROM BIN FAILED!");
                return false;
            }
            arrivalElement.payload = object;
            aperiodicParameters.setAbsoluteDeadline(this.currentTimeForAC, arrivalElement.time);
            if (bl) {
                if (this.deadlineTimer == null) {
                    if (this.currentDeadline != null) {
                        this.deadlineQueue.insert(arrivalElement);
                        bl3 = false;
                    } else {
                        bl3 = true;
                    }
                } else {
                    object2 = this.deadlineTimer;
                    synchronized (object2) {
                        if (this.currentDeadline != null) {
                            this.deadlineQueue.insert(arrivalElement);
                            bl3 = false;
                        } else {
                            bl3 = true;
                        }
                    }
                }
                if (bl3) {
                    this.currentDeadline = arrivalElement;
                    this.deadlineQueue.insert(this.currentDeadline);
                    if (this.deadlineTimer != null) {
                        this.deadlineTimer.reschedule(this.currentDeadline.time);
                        this.deadlineTimer.start();
                    }
                }
            } else {
                this.deadlineQueue.insert(arrivalElement);
            }
        }
        if (bl2) {
            this.lastArrivalTime.set(this.currentTimeForAC);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.announceEnteredRun();
        try {
            this.runHandler();
        }
        finally {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceEnteredRun() {
        AEHImpl aEHImpl = this;
        synchronized (aEHImpl) {
            this.running = true;
            this.notifyAll();
        }
    }

    final void simpleRun() {
        while (this.getAndDecrementPendingFireCount() > 0) {
            try {
                AsyncEventHandler asyncEventHandler = (AsyncEventHandler)this.peerAEH.get();
                if (asyncEventHandler == null) break;
                asyncEventHandler.handleAsyncEvent();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    final String getHandlerState() {
        return handlerStateString[this.handlerState];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHandler() {
        this.handlerState = 1;
        while (this.getAndDecrementPendingFireCount(true) > 0) {
            block12: {
                this.handlerState = 4;
                if (this.endThreadFlag) {
                    this.handlerState = 5;
                    break;
                }
                this.handlerThread.setScopeDaemon(false);
                this.handlerState = 6;
                try {
                    AsyncEventHandler asyncEventHandler = (AsyncEventHandler)this.peerAEH.get();
                    this.handlerState = 7;
                    if (this.endThreadFlag) {
                        System.err.println("Logic error.  About to run handleAEH for an AEH that's supposed to be finalizing");
                    }
                    Object object = this.carryFireArgPayload ? this.deadlineQueue.workingDeadline.payload : null;
                    if (asyncEventHandler != null) {
                        this.callHandler.aeh = asyncEventHandler;
                        this.callHandler.arg = object;
                        if (this.enterPerHae) {
                            this.initMa.enter(this.callHandler);
                        } else {
                            this.callHandler.run();
                        }
                        this.handlerThread.measureCpuTime();
                        break block12;
                    }
                    this.handlerState = 8;
                    break;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                finally {
                    this.handlerState = 9;
                    this.handlerThread.setScopeDaemon(true);
                    this.handlerState = 10;
                }
            }
            this.handlerState = 11;
            this.meetWorkingDeadline();
            this.deadlineQueue.consumeWorking();
            this.handlerState = 12;
            if (this.handlerThread.mainScopeIsAllDaemon()) {
                this.handlerState = 13;
                break;
            }
            this.handlerState = 14;
            this.waitForMIT();
            this.handlerState = 15;
        }
        this.handlerState = 16;
        this.droppedOut = true;
    }

    private void consumeFromArrivalQueue() {
        if (this.deadlineQueue.workingDeadline == null) {
            this.deadlineQueue.moveHeadToWorking();
        }
    }

    private void meetWorkingDeadline() {
        ArrivalElement arrivalElement = null;
        arrivalElement = this.deadlineQueue.workingDeadline;
        if (arrivalElement != null) {
            arrivalElement.semWait();
            if (this.currentDeadline == arrivalElement) {
                if (this.deadlineTimer != null) {
                    this.deadlineTimer.stop();
                }
                this.currentDeadline = this.currentDeadline.next;
                if (this.currentDeadline != null && this.deadlineTimer != null) {
                    this.deadlineTimer.reschedule(this.currentDeadline.time);
                    this.deadlineTimer.start();
                }
            }
            arrivalElement.semPost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMIT() {
        ReleaseParameters releaseParameters = this.handlerThread.getReleaseParameters();
        if (releaseParameters instanceof SporadicParameters) {
            SporadicParameters sporadicParameters = (SporadicParameters)releaseParameters;
            Clock.getRealtimeClock().getTime(this.currentTimeForWFM);
            if (this.mitTargetTime.getMilliseconds() == Long.MIN_VALUE) {
                this.mitTargetTime.set(this.currentTimeForWFM);
                this.mitTargetTime.add(sporadicParameters.getMinimumInterarrival(), this.mitTargetTime);
            }
            this.mitTargetTime.subtract(this.currentTimeForWFM, this.mitWaitTime);
            if (this.mitWaitTime.getTotalNanoseconds() > 0L) {
                RelativeTime relativeTime = this.mitWaitTime;
                synchronized (relativeTime) {
                    while (this.mitWaitTime.getTotalNanoseconds() > 0L && !this.endThreadFlag & !this.becomeNfFlag) {
                        try {
                            HighResolutionTime.waitForObject(this.mitWaitTime, this.mitWaitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Clock.getRealtimeClock().getTime(this.currentTimeForWFM);
                        this.mitTargetTime.subtract(this.currentTimeForWFM, this.mitWaitTime);
                    }
                }
            }
            this.mitTargetTime.add(sporadicParameters.getMinimumInterarrival(), this.mitTargetTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getAndDecrementPendingFireCount(boolean bl) {
        int n;
        this.handlerState = 2;
        if (bl && Thread.currentThread() != this.handlerThread) {
            System.err.println("getAndDec(true) from thread != handlerThread");
        }
        Object object = this.countLock;
        synchronized (object) {
            if (bl) {
                if (this.endThreadFlag) {
                    return 0;
                }
                if (this.becomeNfFlag) {
                    this.becomeQuiet();
                }
                while (this.fireCount <= 0) {
                    try {
                        this.handlerState = 18;
                        this.countLock.wait();
                        if (this.becomeNfFlag) {
                            this.becomeQuiet();
                        }
                        if (!this.endThreadFlag) continue;
                        return 0;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
                this.handlerState = 3;
                ReleaseParameters releaseParameters = this.handlerThread.getReleaseParameters();
                if (releaseParameters instanceof SporadicParameters) {
                    SporadicParameters sporadicParameters = (SporadicParameters)releaseParameters;
                    Clock.getRealtimeClock().getTime(this.currentTimeForGAD);
                    this.currentTimeForGAD.add(sporadicParameters.getMinimumInterarrival(), this.mitTargetTime);
                } else {
                    this.mitTargetTime.set(Long.MIN_VALUE, -999999);
                }
            }
            n = this.fireCount;
            if (this.fireCount > 0) {
                --this.fireCount;
            } else if (bl) {
                // empty if block
            }
            this.consumeFromArrivalQueue();
        }
        return n;
    }

    protected int getAndDecrementPendingFireCount() {
        this.meetWorkingDeadline();
        return this.getAndDecrementPendingFireCount(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int getAndClearPendingFireCount() {
        int n;
        ArrivalElement arrivalElement = null;
        Object object = this.countLock;
        synchronized (object) {
            arrivalElement = this.deadlineQueue.workingDeadline;
            if (this.deadlineTimer != null) {
                this.deadlineTimer.stop();
            }
            if (arrivalElement == null) {
                this.deadlineQueue.moveHeadToWorking();
                arrivalElement = this.deadlineQueue.workingDeadline;
            }
            while (arrivalElement != null) {
                arrivalElement = this.deadlineQueue.moveHeadToWorking();
                this.deadlineQueue.recycleElement(arrivalElement);
                arrivalElement = this.deadlineQueue.workingDeadline;
            }
            n = this.fireCount;
            this.fireCount = 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAndIncrementPendingFireCount() throws MITViolationException, ArrivalTimeQueueOverflowException {
        int n;
        Object object = this.countLock;
        synchronized (object) {
            n = this.fireCount;
        }
        if (this.carryFireArgPayload) {
            this.handle(null, 0);
        } else {
            this.handle(RichAsyncEventHandler.NO_DATA, 0);
        }
        return n;
    }

    protected final int getPendingFireCount() {
        return this.fireCount;
    }

    public boolean addToFeasibility() {
        return this.handlerThread.addIfFeasible();
    }

    public boolean addIfFeasible() {
        return this.handlerThread.addIfFeasible();
    }

    public boolean removeFromFeasibility() {
        return this.handlerThread.removeFromFeasibility();
    }

    public void setSchedulingParameters(SchedulingParameters schedulingParameters) {
        this.handlerThread.setSchedulingParameters(schedulingParameters);
    }

    public boolean setSchedulingParametersIfFeasible(SchedulingParameters schedulingParameters) {
        return this.handlerThread.setSchedulingParametersIfFeasible(schedulingParameters);
    }

    public void setReleaseParameters(ReleaseParameters releaseParameters) {
        this.handlerThread.setReleaseParameters(releaseParameters);
    }

    public boolean setReleaseParametersIfFeasible(ReleaseParameters releaseParameters) {
        return this.handlerThread.setReleaseParametersIfFeasible(releaseParameters);
    }

    public void setMemoryParameters(MemoryParameters memoryParameters) {
        this.handlerThread.setMemoryParameters(memoryParameters);
    }

    public boolean setMemoryParametersIfFeasible(MemoryParameters memoryParameters) {
        return this.handlerThread.setMemoryParametersIfFeasible(memoryParameters);
    }

    public void setProcessingGroupParameters(ProcessingGroupParameters processingGroupParameters) {
        this.handlerThread.setProcessingGroupParameters(processingGroupParameters);
    }

    public boolean setProcessingGroupParametersIfFeasible(ProcessingGroupParameters processingGroupParameters) {
        return this.handlerThread.setProcessingGroupParametersIfFeasible(processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.handlerThread.setIfFeasible(releaseParameters, memoryParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.handlerThread.setIfFeasible(releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(ReleaseParameters releaseParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.handlerThread.setIfFeasible(releaseParameters, processingGroupParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters) {
        return this.handlerThread.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters);
    }

    public boolean setIfFeasible(SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) {
        return this.handlerThread.setIfFeasible(schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public void setScheduler(Scheduler scheduler, SchedulingParameters schedulingParameters, ReleaseParameters releaseParameters, MemoryParameters memoryParameters, ProcessingGroupParameters processingGroupParameters) throws IllegalThreadStateException {
        this.handlerThread.setScheduler(scheduler, schedulingParameters, releaseParameters, memoryParameters, processingGroupParameters);
    }

    public void setScheduler(Scheduler scheduler) {
        this.handlerThread.setScheduler(scheduler);
    }

    public MemoryArea getMemoryArea() {
        return this.initMa;
    }

    public MemoryParameters getMemoryParameters() {
        return this.handlerThread.getMemoryParameters();
    }

    public ProcessingGroupParameters getProcessingGroupParameters() {
        return this.handlerThread.getProcessingGroupParameters();
    }

    public ReleaseParameters getReleaseParameters() {
        return this.handlerThread.getReleaseParameters();
    }

    public Scheduler getScheduler() {
        return this.handlerThread.getScheduler();
    }

    public SchedulingParameters getSchedulingParameters() {
        return this.handlerThread.getSchedulingParameters();
    }

    public final RelativeTime getMinConsumption(RelativeTime relativeTime) {
        return this.handlerThread.getMinConsumption(relativeTime);
    }

    public final RelativeTime getMinConsumption() {
        return this.getMinConsumption(null);
    }

    public final RelativeTime getMaxConsumption(RelativeTime relativeTime) {
        return this.handlerThread.getMaxConsumption(relativeTime);
    }

    public final RelativeTime getMaxConsumption() {
        return this.getMaxConsumption(null);
    }

    public static RelativeTime getCurrentConsumption(RelativeTime relativeTime) {
        return RealtimeThread.getCurrentConsumption(relativeTime);
    }

    public static RelativeTime getCurrentConsumption() {
        return RealtimeThread.getCurrentConsumption();
    }

    AsyncEventHandler getPeer() {
        return (AsyncEventHandler)this.peerAEH.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownFromFinishRtt() {
        try {
            AEHImpl aEHImpl = this;
            synchronized (aEHImpl) {
                if (this.shuttingDown) {
                    return;
                }
                this.shuttingDown = true;
            }
            this.shutdownPhase2();
            this.shuttingDown = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        try {
            AEHImpl aEHImpl = this;
            synchronized (aEHImpl) {
                if (this.shuttingDown) {
                    return;
                }
                this.shuttingDown = true;
            }
            this.endHandlerThread();
            this.shutdownPhase2();
            this.shuttingDown = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownPhase2() {
        if (this.deadlineTimer != null) {
            OneShotTimer oneShotTimer = null;
            AEHImpl aEHImpl = this;
            synchronized (aEHImpl) {
                oneShotTimer = this.deadlineTimer;
                this.deadlineTimer = null;
            }
            if (oneShotTimer != null) {
                oneShotTimer.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeHandlerThread() {
        if (this.handlerThread == Thread.currentThread()) {
            return;
        }
        if (this.handlerThread != null && this.handlerThread.isAlive()) {
            Object object;
            if (this.mitWaitTime != null) {
                object = this.mitWaitTime;
                synchronized (object) {
                    this.mitWaitTime.notify();
                }
            }
            object = this.countLock;
            synchronized (object) {
                this.countLock.notify();
            }
        }
        if (this.handlerThread == null) {
            System.err.println("AEHimpl.wakeHandlerThread for null handle thread");
        } else if (!this.handlerThread.isAlive()) {
            System.err.println("AEHimpl.wakeHandlerThread for non-alive handle thread");
        } else {
            System.err.println("AEHimpl.wakeHandlerThread logic error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endHandlerThread() {
        Object object = this.countLock;
        synchronized (object) {
            this.endThreadFlag = true;
        }
        if (this.handlerThread == Thread.currentThread()) {
            return;
        }
        if (this.handlerThread == null || !this.handlerThread.isAlive()) {
            return;
        }
        boolean bl = this.handlerThread.endAEHandlerThread();
        if (!bl && this.handlerThread.isFireable()) {
            this.wakeHandlerThread();
        }
        try {
            long l = System.currentTimeMillis();
            this.handlerThread.join(2000L);
            long l2 = System.currentTimeMillis();
            if (l + 2000L <= l2) {
                System.out.println("****Warning:  AEHImpl endHandlerThread. AEH handler thread join timed out. " + this.handlerThread);
                System.out.println("Handler state: " + this.getHandlerState());
                System.out.println("Handler thread alive: " + this.handlerThread.isAlive());
                System.out.println("Handler thread fireable: " + this.handlerThread.isFireable());
                System.out.println("Handler Thread scoped daemon: " + this.handlerThread.isScopeDaemon());
                System.out.println("Handler thread is interrupted: " + this.handlerThread.isInterrupted());
                System.out.println("Dropped out : " + this.droppedOut);
            }
            this.handlerThread = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static class CallHandler
    implements Runnable {
        boolean carryFireArgPayload;
        AsyncEventHandler aeh;
        Object arg;

        CallHandler(boolean bl) {
            this.carryFireArgPayload = bl;
        }

        public void run() {
            if (this.carryFireArgPayload) {
                if (this.arg == RichAsyncEventHandler.NULL_DATA) {
                    ((RichAsyncEventHandler)this.aeh).handleAsyncEvent(null);
                } else {
                    ((RichAsyncEventHandler)this.aeh).handleAsyncEvent(this.arg);
                }
            } else {
                this.aeh.handleAsyncEvent();
            }
        }
    }
}

