/*
 * Decompiled with CFR 0.152.
 */
package com.timesys;

import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.OffsetOutOfBoundsException;
import javax.realtime.PhysicalMemoryTypeFilter;
import javax.realtime.SizeOutOfBoundsException;

public class DefaultPhysicalMemoryFilter
implements PhysicalMemoryTypeFilter {
    private long base;
    private long size;
    static final int PROT_READ = 1;
    static final int PROT_WRITE = 2;
    static final int PROT_EXEC = 4;
    static final int PROT_NONE = 0;
    static final int MAP_SHARED = 1;
    static final int MAP_PRIVATE = 2;
    static final int MAP_FIXED = 16;
    static final long MAX_ADDRESS = 0xFFFFFFFFL;

    public DefaultPhysicalMemoryFilter(long l, long l2) {
        this.checkBaseAndSize(l, l2);
        this.base = l;
        this.size = l2;
    }

    private void checkBaseAndSize(long l, long l2) {
        if (l < 0L) {
            throw new OffsetOutOfBoundsException("base < 0");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("size < 0");
        }
        if (l > 0xFFFFFFFFL || l2 > 0xFFFFFFFFL || l + l2 > 0xFFFFFFFFL) {
            throw new SizeOutOfBoundsException("End of extent passes memory bound");
        }
    }

    public long find(long l, long l2) {
        this.checkBaseAndSize(l, l2);
        long l3 = l + l2;
        long l4 = this.base + this.size;
        this.checkBaseAndSize(l, l2);
        if (this.size < l2) {
            return -1L;
        }
        if (l >= this.base && l3 <= l4) {
            return l;
        }
        return this.base;
    }

    public long vFind(long l, long l2) {
        this.checkBaseAndSize(l, l2);
        return l;
    }

    public void initialize(long l, long l2, long l3) {
        this.checkBaseAndSize(l, l3);
    }

    public boolean isRemovable() {
        return false;
    }

    public boolean contains(long l, long l2) {
        this.checkBaseAndSize(l, l2);
        return true;
    }

    public void onRemoval(long l, long l2, AsyncEventHandler asyncEventHandler) {
        this.checkBaseAndSize(l, l2);
    }

    public void onInsertion(long l, long l2, AsyncEventHandler asyncEventHandler) {
        this.checkBaseAndSize(l, l2);
    }

    public void onInsertion(long l, long l2, AsyncEvent asyncEvent) {
        this.checkBaseAndSize(l, l2);
    }

    public void onRemoval(long l, long l2, AsyncEvent asyncEvent) {
        this.checkBaseAndSize(l, l2);
    }

    public boolean unregisterInsertionEvent(long l, long l2, AsyncEvent asyncEvent) {
        this.checkBaseAndSize(l, l2);
        return false;
    }

    public boolean unregisterRemovalEvent(long l, long l2, AsyncEvent asyncEvent) {
        this.checkBaseAndSize(l, l2);
        return false;
    }

    public boolean isPresent(long l, long l2) {
        this.checkBaseAndSize(l, l2);
        return true;
    }

    public int getVMAttributes() {
        return 3;
    }

    public int getVMFlags() {
        return 1;
    }
}

