/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.datagram;

import com.sun.cdc.io.j2me.UniversalOutputStream;
import com.sun.cdc.io.j2me.datagram.Protocol;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.microedition.io.Datagram;

public class DatagramObject
extends UniversalOutputStream
implements Datagram {
    DatagramPacket dgram;
    String host;
    int port;
    int pointer = 0;

    public DatagramObject(DatagramPacket datagramPacket) {
        this.dgram = datagramPacket;
    }

    public DatagramObject(int n) {
        this.port = n;
        this.host = "localhost";
    }

    public String getAddress() {
        InetAddress inetAddress = this.dgram.getAddress();
        if (inetAddress == null) {
            return null;
        }
        return "datagram://" + inetAddress.getHostAddress() + ":" + this.port;
    }

    public byte[] getData() {
        return this.dgram.getData();
    }

    public int getOffset() {
        return this.dgram.getOffset();
    }

    public int getLength() {
        return this.dgram.getLength();
    }

    public void setAddress(String string) throws IOException {
        if (!string.startsWith("datagram://")) {
            throw new IllegalArgumentException("Invalid datagram address" + string);
        }
        String string2 = string.substring(11);
        try {
            this.host = Protocol.getAddress(string2);
            this.port = Protocol.getPort(string2);
            this.dgram.setAddress(InetAddress.getByName(this.host));
            this.dgram.setPort(this.port);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid datagram address" + string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unknown host " + string);
        }
    }

    public void setAddress(Datagram datagram) {
        DatagramObject datagramObject = (DatagramObject)datagram;
        this.host = datagramObject.host;
        this.port = datagramObject.port;
        this.dgram.setAddress(datagramObject.dgram.getAddress());
        this.dgram.setPort(this.port);
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.dgram.setData(byArray, n, n2);
        this.pointer = 0;
    }

    public void setLength(int n) {
        this.dgram.setLength(n);
    }

    public void reset() {
        byte[] byArray = this.dgram.getData();
        this.dgram.setData(byArray, 0, 0);
        this.pointer = 0;
    }

    public long skip(long l) throws EOFException {
        int n = this.dgram.getLength();
        if (l > (long)(n - this.pointer)) {
            throw new EOFException();
        }
        this.pointer = (int)((long)this.pointer + l);
        return l;
    }

    public int read() throws IOException {
        byte[] byArray = this.dgram.getData();
        if (this.pointer >= this.dgram.getLength()) {
            return -1;
        }
        return byArray[this.dgram.getOffset() + this.pointer++] & 0xFF;
    }

    public void write(int n) throws IOException {
        byte[] byArray = this.dgram.getData();
        if (this.pointer >= this.dgram.getLength()) {
            throw new IOException();
        }
        byArray[this.dgram.getOffset() + this.pointer++] = (byte)n;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        this.pointer = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 < 0) {
                throw new EOFException();
            }
            byArray[n + n3++] = (byte)n4;
        }
    }

    public final int skipBytes(int n) throws IOException {
        int n2 = this.dgram.getLength();
        if (n > n2 - this.pointer) {
            throw new EOFException();
        }
        this.pointer += n;
        return n;
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final float readFloat() throws IOException {
        int n = this.readInt();
        float f = Float.intBitsToFloat(n);
        return f;
    }

    public final double readDouble() throws IOException {
        long l = this.readLong();
        double d = Double.longBitsToDouble(l);
        return d;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final String readLine() throws IOException {
        throw new RuntimeException("Function not supported");
    }
}

