/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.provider.KeyProtector;

public final class JavaKeyStore
extends KeyStoreSpi {
    public static final int MAGIC = -17957139;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private Hashtable entries = new Hashtable();

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object v = this.entries.get(string.toLowerCase());
        if (v == null || !(v instanceof KeyEntry)) {
            return null;
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        byte[] byArray = ((KeyEntry)v).protectedPrivKey;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
        }
        return keyProtector.recover(encryptedPrivateKeyInfo);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)v).chain.clone();
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)v).cert;
            }
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return ((KeyEntry)v).chain[0];
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)v).date.getTime());
            }
            return new Date(((KeyEntry)v).date.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        KeyProtector keyProtector = null;
        try {
            Hashtable hashtable = this.entries;
            synchronized (hashtable) {
                KeyEntry keyEntry = new KeyEntry();
                keyEntry.date = new Date();
                keyProtector = new KeyProtector(cArray);
                keyEntry.protectedPrivKey = keyProtector.protect(key);
                if (certificateArray != null) {
                    keyEntry.chain = (Certificate[])certificateArray.clone();
                }
                this.entries.put(string.toLowerCase(), keyEntry);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
        finally {
            keyProtector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            try {
                new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new KeyStoreException("key is not encoded as EncryptedPrivateKeyInfo");
            }
            KeyEntry keyEntry = new KeyEntry();
            keyEntry.date = new Date();
            keyEntry.protectedPrivKey = (byte[])byArray.clone();
            if (certificateArray != null) {
                keyEntry.chain = (Certificate[])certificateArray.clone();
            }
            this.entries.put(string.toLowerCase(), keyEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && v instanceof KeyEntry) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            this.entries.put(string.toLowerCase(), trustedCertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(string.toLowerCase());
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof KeyEntry;
    }

    public boolean engineIsCertificateEntry(String string) {
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof TrustedCertEntry;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (((KeyEntry)v).chain == null) continue;
                certificate2 = ((KeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (cArray == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest messageDigest = this.getPreKeyedHash(cArray);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
            dataOutputStream.writeInt(-17957139);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(this.entries.size());
            Object object = this.entries.keys();
            while (object.hasMoreElements()) {
                byte[] byArray;
                String string = (String)object.nextElement();
                Object v = this.entries.get(string);
                if (v instanceof KeyEntry) {
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeLong(((KeyEntry)v).date.getTime());
                    dataOutputStream.writeInt(((KeyEntry)v).protectedPrivKey.length);
                    dataOutputStream.write(((KeyEntry)v).protectedPrivKey);
                    int n = ((KeyEntry)v).chain == null ? 0 : ((KeyEntry)v).chain.length;
                    dataOutputStream.writeInt(n);
                    for (int i = 0; i < n; ++i) {
                        byArray = ((KeyEntry)v).chain[i].getEncoded();
                        dataOutputStream.writeUTF(((KeyEntry)v).chain[i].getType());
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                    }
                    continue;
                }
                dataOutputStream.writeInt(2);
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeLong(((TrustedCertEntry)v).date.getTime());
                byArray = ((TrustedCertEntry)v).cert.getEncoded();
                dataOutputStream.writeUTF(((TrustedCertEntry)v).cert.getType());
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
            object = messageDigest.digest();
            dataOutputStream.write((byte[])object);
            dataOutputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            DataInputStream dataInputStream;
            MessageDigest messageDigest = null;
            CertificateFactory certificateFactory = null;
            Hashtable<String, CertificateFactory> hashtable2 = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = null;
            if (inputStream == null) {
                return;
            }
            if (cArray != null) {
                messageDigest = this.getPreKeyedHash(cArray);
                dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
            } else {
                dataInputStream = new DataInputStream(inputStream);
            }
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n != -17957139 || n2 != 1 && n2 != 2) {
                throw new IOException("Invalid keystore format");
            }
            if (n2 == 1) {
                certificateFactory = CertificateFactory.getInstance("X509");
            } else {
                hashtable2 = new Hashtable<String, CertificateFactory>(3);
            }
            this.entries.clear();
            int n3 = dataInputStream.readInt();
            for (int i = 0; i < n3; ++i) {
                String string;
                Object object;
                int n4 = dataInputStream.readInt();
                if (n4 == 1) {
                    object = new KeyEntry();
                    string = dataInputStream.readUTF();
                    ((KeyEntry)object).date = new Date(dataInputStream.readLong());
                    try {
                        ((KeyEntry)object).protectedPrivKey = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Keysize too big");
                    }
                    dataInputStream.readFully(((KeyEntry)object).protectedPrivKey);
                    try {
                        ((KeyEntry)object).chain = new Certificate[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Too many certificates in chain");
                    }
                    for (int j = 0; j < ((KeyEntry)object).chain.length; ++j) {
                        if (n2 == 2) {
                            String string2 = dataInputStream.readUTF();
                            if (hashtable2.containsKey(string2)) {
                                certificateFactory = (CertificateFactory)hashtable2.get(string2);
                            } else {
                                certificateFactory = CertificateFactory.getInstance(string2);
                                hashtable2.put(string2, certificateFactory);
                            }
                        }
                        try {
                            byArray = new byte[dataInputStream.readInt()];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Certificate too big");
                        }
                        dataInputStream.readFully(byArray);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ((KeyEntry)object).chain[j] = certificateFactory.generateCertificate(byteArrayInputStream);
                        byteArrayInputStream.close();
                    }
                    this.entries.put(string, object);
                    continue;
                }
                if (n4 == 2) {
                    object = new TrustedCertEntry();
                    string = dataInputStream.readUTF();
                    ((TrustedCertEntry)object).date = new Date(dataInputStream.readLong());
                    if (n2 == 2) {
                        String string3 = dataInputStream.readUTF();
                        if (hashtable2.containsKey(string3)) {
                            certificateFactory = (CertificateFactory)hashtable2.get(string3);
                        } else {
                            certificateFactory = CertificateFactory.getInstance(string3);
                            hashtable2.put(string3, certificateFactory);
                        }
                    }
                    try {
                        byArray = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Certificate too big");
                    }
                    dataInputStream.readFully(byArray);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ((TrustedCertEntry)object).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                    byteArrayInputStream.close();
                    this.entries.put(string, object);
                    continue;
                }
                throw new IOException("Unrecognized keystore entry");
            }
            if (cArray != null) {
                byte[] byArray2 = messageDigest.digest();
                byte[] byArray3 = new byte[byArray2.length];
                dataInputStream.readFully(byArray3);
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray3[i]) continue;
                    throw new IOException("Keystore was tampered with, or password was incorrect");
                }
            }
        }
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
        }
        messageDigest.update(byArray);
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    class TrustedCertEntry {
        Date date;
        Certificate cert;

        TrustedCertEntry() {
        }
    }

    class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;

        KeyEntry() {
        }
    }
}

