/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.timesys.AddEventHandler;
import com.timesys.SemHolder;
import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.HeapMemory;
import javax.realtime.ImmortalMemory;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.MemoryArea;
import javax.realtime.MemoryScopeException;

public class WaitFreeReadQueue {
    private Object[] theQueue;
    private int head = 0;
    private int tail = 0;
    private int queueSize = 0;
    private MemoryArea memArea;
    private boolean notify;
    private AsyncEvent addedEvent = null;
    private SemHolder fullSem;
    private SemHolder emptySem;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$realtime$AsyncEvent;
    static /* synthetic */ Class class$com$timesys$AddEventHandler;

    WaitFreeReadQueue(int n) throws IllegalArgumentException {
        this(n, MemoryArea.getEffImmortalMa());
    }

    WaitFreeReadQueue(int n, MemoryArea memoryArea) throws IllegalArgumentException {
        this(null, null, n, memoryArea);
    }

    public WaitFreeReadQueue(Runnable runnable, Runnable runnable2, int n, MemoryArea memoryArea) throws IllegalArgumentException {
        this(runnable, runnable2, n, memoryArea, false);
    }

    public WaitFreeReadQueue(int n, boolean bl) throws IllegalArgumentException {
        this(n, MemoryArea.getEffImmortalMa(), bl);
    }

    public WaitFreeReadQueue(int n, MemoryArea memoryArea, boolean bl) throws IllegalArgumentException {
        if (memoryArea == null) {
            throw new IllegalArgumentException("Null memory area");
        }
        this.init(null, null, n, memoryArea, bl);
    }

    public WaitFreeReadQueue(Runnable runnable, Runnable runnable2, int n, MemoryArea memoryArea, boolean bl) throws IllegalArgumentException {
        this.init(runnable, runnable2, n, memoryArea, bl);
    }

    private void init(Runnable runnable, Runnable runnable2, int n, MemoryArea memoryArea, boolean bl) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("maximum cannot be less than or equal to 0");
        }
        if (runnable != null && !(runnable instanceof Thread) && !(runnable instanceof AsyncEventHandler)) {
            throw new IllegalArgumentException("writer is not a Thread or Schedulable Object");
        }
        if (runnable2 != null && !(runnable2 instanceof Thread) && !(runnable2 instanceof AsyncEventHandler)) {
            throw new IllegalArgumentException("reader is not a Thread or Schedulable Object");
        }
        this.emptySem = new SemHolder(n);
        this.fullSem = new SemHolder(0);
        if (memoryArea == null) {
            if (runnable != null && runnable2 != null) {
                this.memArea = WaitFreeReadQueue.getCommonMemoryArea(runnable instanceof AsyncEventHandler ? ((AsyncEventHandler)runnable).aehImpl.handlerThread : (Thread)runnable, runnable2 instanceof AsyncEventHandler ? ((AsyncEventHandler)runnable2).aehImpl.handlerThread : (Thread)runnable2);
            }
            if (this.memArea == null) {
                this.memArea = MemoryArea.getEffImmortalMa();
            }
        } else if (memoryArea.reachableMemory()) {
            this.memArea = memoryArea;
        } else {
            throw new InaccessibleAreaException(memoryArea.toString() + " is not available for the queue memory");
        }
        try {
            this.theQueue = (Object[])this.memArea.newArray(class$java$lang$Object == null ? (class$java$lang$Object = WaitFreeReadQueue.class$("java.lang.Object")) : class$java$lang$Object, n + 1);
            if (this.theQueue != null) {
                this.queueSize = n + 1;
            }
            this.notify = bl;
            if (bl) {
                MemoryArea memoryArea2 = this.memArea;
                if (memoryArea2 instanceof HeapMemory) {
                    memoryArea2 = ImmortalMemory.instance();
                }
                this.addedEvent = (AsyncEvent)memoryArea2.newInstance(class$javax$realtime$AsyncEvent == null ? (class$javax$realtime$AsyncEvent = WaitFreeReadQueue.class$("javax.realtime.AsyncEvent")) : class$javax$realtime$AsyncEvent);
                AddEventHandler addEventHandler = (AddEventHandler)memoryArea2.newInstance(class$com$timesys$AddEventHandler == null ? (class$com$timesys$AddEventHandler = WaitFreeReadQueue.class$("com.timesys.AddEventHandler")) : class$com$timesys$AddEventHandler);
                addEventHandler.setEvent(this.addedEvent);
                this.addedEvent.addHandler(addEventHandler);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException.getMessage());
        }
    }

    public void clear() {
        this.tail = 0;
        this.head = 0;
        while (this.fullSem.tryDown()) {
            this.emptySem.up();
        }
    }

    public boolean isEmpty() {
        return this.fullSem.getCount() == 0;
    }

    public boolean isFull() {
        return this.emptySem.getCount() == 0;
    }

    public Object read() {
        Object object = null;
        if (this.fullSem.tryDown()) {
            object = this.theQueue[this.head];
            this.head = (this.head + 1) % this.queueSize;
            this.emptySem.up();
        }
        return object;
    }

    public int size() {
        if (this.head == this.tail) {
            if (this.isEmpty()) {
                return 0;
            }
            return this.queueSize;
        }
        if (this.head > this.tail) {
            return this.queueSize - (this.head - this.tail);
        }
        return this.tail - this.head;
    }

    public void waitForData() throws InterruptedException {
        if (!this.notify) {
            throw new UnsupportedOperationException("notify was not set to true");
        }
        this.fullSem.down();
        this.fullSem.up();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object) throws InterruptedException, MemoryScopeException {
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        WaitFreeReadQueue waitFreeReadQueue = this;
        synchronized (waitFreeReadQueue) {
            this.emptySem.down();
            try {
                this.theQueue[this.tail] = object;
                this.tail = (this.tail + 1) % this.queueSize;
            }
            catch (Throwable throwable) {
                this.emptySem.up();
                throw new MemoryScopeException("The caller may not store in the memory area containing the queue.");
            }
        }
        this.fullSem.up();
    }

    static native MemoryArea getCommonMemoryArea(Thread var0, Thread var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

