/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.AbsoluteTime;
import javax.realtime.AsyncEvent;
import javax.realtime.AsyncEventHandler;
import javax.realtime.Clock;
import javax.realtime.HeapMemory;
import javax.realtime.HighResolutionTime;
import javax.realtime.MemoryArea;
import javax.realtime.RelativeTime;
import javax.realtime.ResourceLimitError;
import javax.realtime.RichAsyncEventHandler;

public abstract class Timer
extends AsyncEvent {
    int jtimerNativeData = 0;
    AbsoluteTime startTime = new AbsoluteTime();
    Clock clock;
    boolean hasFired = false;
    private boolean lockedSd = false;
    boolean started = false;
    boolean isAbsolute = false;
    AbsoluteTime absfireTime = new AbsoluteTime();
    RelativeTime relfireTime = new RelativeTime();
    HighResolutionTime fireTimeParam;
    HighResolutionTime actualFireTimeParam;
    private boolean isAlive = false;
    private boolean isEnabled = true;
    boolean isRunning = false;
    Object timerLock = new Object();
    int lockCode = 0;

    Timer(HighResolutionTime highResolutionTime, Clock clock, AsyncEventHandler asyncEventHandler) {
        this.actualFireTimeParam = highResolutionTime;
        if (highResolutionTime == null) {
            this.isAbsolute = false;
            this.relfireTime.set(0L, 0);
        } else if (highResolutionTime instanceof AbsoluteTime) {
            this.isAbsolute = true;
            this.absfireTime.set(highResolutionTime);
        } else {
            this.isAbsolute = false;
            this.relfireTime.set(highResolutionTime);
            if (this.relfireTime.getMilliseconds() < 0L || this.relfireTime.getNanoseconds() < 0) {
                throw new IllegalArgumentException("negative relative start time");
            }
        }
        this.fireTimeParam = highResolutionTime;
        if (clock == null) {
            clock = Clock.getRealtimeClock();
        }
        this.clock = clock;
        if (asyncEventHandler != null) {
            this.internalAddHandler(asyncEventHandler);
        }
        boolean bl = false;
        if (MemoryArea.getMemoryArea(this) instanceof HeapMemory) {
            bl = true;
        }
        this.jtimerNativeData = this.newTimer0(this.getEventDispatcherID(), bl);
        if (this.jtimerNativeData == 0) {
            throw new ResourceLimitError("unable to create new timer");
        }
        this.isAlive = true;
    }

    void lockAsScopeDaemon(boolean bl) {
        if (this.started) {
            throw new RuntimeException("Timer.lockAsScopeDaemon() must be called before the Timer is started");
        }
        this.lockedSd = bl;
    }

    public void start() {
    }

    public void start(boolean bl) {
        this.checkAlive();
        this.started = true;
        if (!this.lockedSd) {
            this.makeDispatcherBeExContext(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.timerLock;
        synchronized (object) {
            this.lockCode = 1;
            this.checkAlive();
            if (!this.isRunning) {
                this.lockCode = 0;
                return false;
            }
            this.stopTimer();
            this.setIsRunning(false);
            this.lockCode = 0;
            return this.isEnabled;
        }
    }

    void stopTimer() {
        if (this.setTimer(this.jtimerNativeData, false, 0L, 0, 0L, 0) == 0) {
            this.lockCode = 0;
            System.err.println("internal timer error");
            throw new RuntimeException("internal timer error");
        }
        if (this.flushTimer(this.jtimerNativeData) == 0) {
            this.lockCode = 0;
            throw new RuntimeException("internal timer error");
        }
    }

    void reschedule(HighResolutionTime highResolutionTime, RelativeTime relativeTime) {
        this.reschedule(highResolutionTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(HighResolutionTime highResolutionTime) {
        Object object = this.timerLock;
        synchronized (object) {
            this.lockCode = 2;
            this.checkAlive();
            if (highResolutionTime == null) {
                return;
            }
            if (highResolutionTime instanceof AbsoluteTime) {
                this.isAbsolute = true;
                this.absfireTime.set(highResolutionTime);
            } else {
                this.isAbsolute = false;
                this.relfireTime.set(highResolutionTime);
            }
            if (this.isRunning && !this.hasFired) {
                this.stopTimer();
                if (this.isRunning && !this.hasFired) {
                    this.reStartInternal();
                    this.lockCode = 2;
                }
            }
            this.lockCode = 0;
        }
    }

    void reStartInternal() {
    }

    void tick() {
        this.setIsRunning(false);
        this.hasFired = true;
        if (this.isEnabled()) {
            this.internalFire(RichAsyncEventHandler.NO_DATA, 0, false);
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    void setEnabled(boolean bl) {
        this.checkAlive();
        this.isEnabled = bl;
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    public Clock getClock() {
        this.checkAlive();
        return this.clock;
    }

    public HighResolutionTime getStartTime() {
        return this.fireTimeParam;
    }

    public AbsoluteTime getLastReleaseTime() {
        return this.internalGetLastReleaseTime(null);
    }

    public AbsoluteTime getLastReleaseTime(AbsoluteTime absoluteTime) {
        return this.internalGetLastReleaseTime(absoluteTime);
    }

    AbsoluteTime internalGetLastReleaseTime(AbsoluteTime absoluteTime) {
        if (!this.started) {
            return null;
        }
        if (absoluteTime == null) {
            absoluteTime = new AbsoluteTime();
        }
        if (this.isAbsolute) {
            absoluteTime.set(this.absfireTime);
        } else {
            this.startTime.add(this.relfireTime, absoluteTime);
        }
        return absoluteTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsoluteTime getFireTime(AbsoluteTime absoluteTime) {
        Object object = this.timerLock;
        synchronized (object) {
            this.lockCode = 8;
            this.checkAlive();
            if (this.isRunning) {
                if (this.isAbsolute) {
                    if (absoluteTime == null) {
                        absoluteTime = new AbsoluteTime();
                    }
                    absoluteTime.set(this.absfireTime);
                } else {
                    if (absoluteTime == null) {
                        absoluteTime = new AbsoluteTime();
                    }
                    this.startTime.add(this.relfireTime, absoluteTime);
                }
            } else {
                this.lockCode = 0;
                throw new IllegalStateException("Cannot get fire time until the timer is started.");
            }
            this.lockCode = 0;
            return absoluteTime;
        }
    }

    AbsoluteTime getLastFireTime(AbsoluteTime absoluteTime) {
        if (absoluteTime == null) {
            throw new IllegalArgumentException("Null destination");
        }
        if (!this.started) {
            throw new IllegalStateException("Timer has not been started");
        }
        if (this.isAbsolute) {
            absoluteTime.set(this.absfireTime);
        } else {
            this.startTime.add(this.relfireTime, absoluteTime);
        }
        return absoluteTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HighResolutionTime getFireTimeValue() {
        Object object = this.timerLock;
        synchronized (object) {
            this.lockCode = 3;
            if (this.isAbsolute) {
                this.lockCode = 0;
                return (HighResolutionTime)this.absfireTime.clone();
            }
            this.lockCode = 0;
            return (HighResolutionTime)this.relfireTime.clone();
        }
    }

    public AbsoluteTime getFireTime() {
        this.checkAlive();
        return this.getFireTime(null);
    }

    void checkAlive() {
        if (!this.isAlive) {
            throw new IllegalStateException("illegal operation, timer destroyed");
        }
    }

    public void destroy() {
        this.internalDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalDestroy() {
        Object object = this.timerLock;
        synchronized (object) {
            this.lockCode = 4;
            this.checkAlive();
            this.noFaultDestroy();
        }
        super.shutdown();
        this.lockCode = 4;
        this.lockCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noFaultDestroy() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.isAlive) {
                this.stop();
                this.lockCode = 4;
                if (this.freeTimer(this.jtimerNativeData) == 0) {
                    this.lockCode = 0;
                }
                this.isAlive = false;
            }
        }
    }

    public boolean isRunning() {
        this.checkAlive();
        return this.isRunning && this.isEnabled;
    }

    void setIsRunning(boolean bl) {
        this.isRunning = bl;
    }

    public void bindTo(String string) {
        throw new UnsupportedOperationException("bindTo in timer instances should not be used");
    }

    public void fire() {
        throw new UnsupportedOperationException("fire() in timer instances should not be used");
    }

    void shutdown() {
        this.lockCode = 5;
        this.noFaultDestroy();
        this.lockCode = 0;
        super.shutdown();
        this.lockCode = 5;
    }

    protected void finalize() throws Throwable {
        if (MemoryArea.getMemoryArea(this) instanceof HeapMemory) {
            this.destroy();
        } else if (this.isAlive && this.started && !this.lockedSd) {
            System.err.println("finalize called on a timer that has been started and not destroyed.");
            System.err.println("The AE's dispatcher threads are: " + this.dispatcherState());
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            System.out.println("Exception thrown from Timer's super.finalize: " + throwable);
        }
    }

    int setTimer(int n, boolean bl, long l, int n2, long l2, int n3) {
        return this.setTimer0(n, bl, l, n2, l2, n3);
    }

    native int setTimer0(int var1, boolean var2, long var3, int var5, long var6, int var8);

    private native int newTimer0(long var1, boolean var3);

    private native int flushTimer(int var1);

    private native int freeTimer(int var1);

    static native void fireTimersDispatcher(long var0);
}

