/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.util.Vector;
import javax.realtime.MonitorControl;
import javax.realtime.PriorityScheduler;

public class PriorityCeilingEmulation
extends MonitorControl {
    private int ceiling;
    private static Vector instances = new Vector(32, 32);
    private static final PriorityCeilingEmulation maxCeiling = PriorityCeilingEmulation.instance(PriorityScheduler.instance().getMaxPriority());

    private PriorityCeilingEmulation(int n) {
        this.ceiling = n;
    }

    public static PriorityCeilingEmulation instance(int n) {
        PriorityCeilingEmulation priorityCeilingEmulation;
        if (n < PriorityScheduler.getMinPriority(null)) {
            throw new IllegalArgumentException("ceiling too small: " + n + " < " + PriorityScheduler.getMinPriority(null));
        }
        if (n > PriorityScheduler.getMaxPriority(null)) {
            throw new IllegalArgumentException("ceiling too large: " + n + " > " + PriorityScheduler.getMaxPriority(null));
        }
        for (int i = 0; i < instances.size(); ++i) {
            priorityCeilingEmulation = (PriorityCeilingEmulation)instances.get(i);
            if (priorityCeilingEmulation.getDefaultCeiling() != n) continue;
            return priorityCeilingEmulation;
        }
        priorityCeilingEmulation = new PriorityCeilingEmulation(n);
        instances.add(priorityCeilingEmulation);
        return priorityCeilingEmulation;
    }

    public int getDefaultCeiling() {
        return this.ceiling;
    }

    public int getCeiling() {
        return this.internalGetCeiling();
    }

    int internalGetCeiling() {
        return this.ceiling;
    }

    static boolean isKnownInstance(MonitorControl monitorControl) {
        if (monitorControl instanceof PriorityCeilingEmulation) {
            for (int i = 0; i < instances.size(); ++i) {
                PriorityCeilingEmulation priorityCeilingEmulation = (PriorityCeilingEmulation)instances.get(i);
                if (priorityCeilingEmulation != monitorControl) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static PriorityCeilingEmulation getMaxCeiling() {
        return maxCeiling;
    }
}

