/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import java.io.IOException;
import javax.realtime.OffsetOutOfBoundsException;
import javax.realtime.RawScalarAccess;
import javax.realtime.RealtimeSystem;
import javax.realtime.SizeOutOfBoundsException;

class PhysicalMemAccess
implements RawScalarAccess {
    private static int SIZEOF_BYTE = 1;
    private static int SIZEOF_SHORT = 2;
    private static int SIZEOF_INT = 4;
    private static int SIZEOF_LONG = 8;
    private int base;
    private int size;
    boolean memOpen = false;
    private int fd;

    public PhysicalMemAccess(int n, int n2) throws SecurityException, OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative base");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Non-positive size");
        }
        this.fd = PhysicalMemAccess.openMemory0();
        if (this.fd < 0) {
            throw new SecurityException("Cannot open memory file");
        }
        try {
            PhysicalMemAccess.seek0(this.fd, n);
        }
        catch (Throwable throwable) {
            PhysicalMemAccess.close0(this.fd);
            throw new IllegalArgumentException("Cannot access base address");
        }
        try {
            PhysicalMemAccess.seek0(this.fd, n + n2 - 1);
        }
        catch (Throwable throwable) {
            PhysicalMemAccess.close0(this.fd);
            throw new IllegalArgumentException("Cannot access end address");
        }
        this.base = n;
        this.size = n2;
        this.memOpen = true;
    }

    private static native int openMemory0();

    public byte getByte(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_BYTE);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        return PhysicalMemAccess.readByte0(this.fd);
    }

    private static native void seek0(int var0, long var1);

    private static native byte readByte0(int var0);

    public void getBytes(long l, byte[] byArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_BYTE, byArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = this.getByte(l + (long)i);
        }
    }

    public int getInt(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_INT);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        return PhysicalMemAccess.readInt0(this.fd);
    }

    private static native int readInt0(int var0);

    public void getInts(long l, int[] nArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_INT, nArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.getInt(l + (long)(i * SIZEOF_INT));
        }
    }

    public long getLong(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_LONG);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        return PhysicalMemAccess.readLong0(this.fd);
    }

    private static native long readLong0(int var0);

    public void getLongs(long l, long[] lArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_LONG, lArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = this.getLong(l + (long)(i * SIZEOF_LONG));
        }
    }

    public short getShort(long l) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_SHORT);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        return PhysicalMemAccess.readShort0(this.fd);
    }

    private static native short readShort0(int var0);

    public void getShorts(long l, short[] sArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_SHORT, sArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            sArray[i + n] = this.getShort(l + (long)(i * SIZEOF_SHORT));
        }
    }

    public void setByte(long l, byte by) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_BYTE);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        PhysicalMemAccess.writeByte0(this.fd, by);
    }

    private static native void writeByte0(int var0, byte var1);

    public void setBytes(long l, byte[] byArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_BYTE, byArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setByte(l + (long)i, byArray[i + n]);
        }
    }

    public void setInt(long l, int n) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_INT);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        PhysicalMemAccess.writeInt0(this.fd, n);
    }

    private static native void writeInt0(int var0, int var1);

    public void setInts(long l, int[] nArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_INT, nArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setInt(l + (long)(i * SIZEOF_INT), nArray[i + n]);
        }
    }

    public void setLong(long l, long l2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_LONG);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        PhysicalMemAccess.writeLong0(this.fd, l2);
    }

    private static native void writeLong0(int var0, long var1);

    public void setLongs(long l, long[] lArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_LONG, lArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setLong(l + (long)(i * SIZEOF_LONG), lArray[i + n]);
        }
    }

    public void setShort(long l, short s) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.standardChecks(l, SIZEOF_SHORT);
        PhysicalMemAccess.seek0(this.fd, (long)this.base + l);
        PhysicalMemAccess.writeShort0(this.fd, s);
    }

    private static native void writeShort0(int var0, short var1);

    public void setShorts(long l, short[] sArray, int n, int n2) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        this.arrayChecks(l, SIZEOF_SHORT, sArray.length, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.setShort(l + (long)(i * SIZEOF_SHORT), sArray[i + n]);
        }
    }

    void standardChecks(long l, int n) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (!this.memOpen) {
            int n2 = PhysicalMemAccess.openMemory0();
            if (n2 < 0) {
                throw new SecurityException("Cannot open memory file");
            }
            this.memOpen = true;
        }
        RealtimeSystem.getSecurityManager().checkAccessPhysical();
        if (l >= (long)this.size || l < 0L) {
            throw new OffsetOutOfBoundsException("Offset passed is less than 0 or greater than size");
        }
        if (l + (long)n > (long)this.size) {
            throw new SizeOutOfBoundsException();
        }
    }

    void arrayChecks(long l, int n, int n2, int n3, int n4) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (n4 + n3 > n2) {
            throw new ArrayIndexOutOfBoundsException("Array passed is not big enough");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative starting index");
        }
        if (l < 0L) {
            throw new OffsetOutOfBoundsException("offset is negative");
        }
        if (n4 < 0) {
            throw new OffsetOutOfBoundsException("'number' is negative");
        }
        this.standardChecks(l, n * n4);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        PhysicalMemAccess.close0(this.fd);
        this.memOpen = false;
    }

    private static native void close0(int var0);

    private static void generateIoException() throws IOException {
        throw new IOException();
    }

    private static void generateSizeException() {
        throw new SizeOutOfBoundsException();
    }
}

