/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.timesys.HighPriorityScheduler;
import com.timesys.SemHolder;
import javax.realtime.AperiodicParameters;
import javax.realtime.AsyncEventHandler;
import javax.realtime.EventDispatcherLogic;
import javax.realtime.EventDispatcherSet;
import javax.realtime.HandlerSet;
import javax.realtime.HeapMemory;
import javax.realtime.ImmortalMemory;
import javax.realtime.MemoryArea;
import javax.realtime.NoDeadlineParams;
import javax.realtime.NoHeapRealtimeThread;
import javax.realtime.PriorityParameters;
import javax.realtime.PriorityScheduler;
import javax.realtime.RealtimeThread;
import javax.realtime.ReleaseParameters;
import javax.realtime.RichAsyncEventHandler;
import javax.realtime.SchedulingParameters;
import javax.realtime.UnknownHappeningException;

public class AsyncEvent {
    static final int NUM_HAPPENINGS = 64;
    static final int ACTION_FIRE = 0;
    static final int ACTION_TICK = 1;
    static final int ACTION_MAINTANANCE = 2;
    static final int ACTION_TERMINATE = 5;
    private static final int[] HAPPENING_RESERVED = new int[]{1, 4, 7, 8, 9, 10, 11, 17, 19, 32, 34, 64};
    private int[] boundEventDispatcherKey = new int[64];
    private HandlerSet handlerSet = new HandlerSet();
    private EventDispatcherLogic eventDispatcherLogic;
    private EventDispatcherLogic heapEventDispatcherLogic;
    private boolean nonHeapInitialDispatcher;
    private MemoryArea eventDispatcherArea = MemoryArea.getEffImmortalMa();
    private RealtimeThread heapEventDispatcher;
    private NoHeapRealtimeThread nhEventDispatcher;
    private Throwable returnedException;
    private SemHolder returnedExceptionSem = new SemHolder(0);
    private Object secondDispatcherLock = new Object();
    private boolean finalizing = false;
    private MakeDispatcherInInstanceMem makeDispatcherInInstanceMem;
    private boolean recursionDetector = false;
    private int exContextCount = 0;
    private boolean shuttingDown = false;
    private int shutdownThreadCode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncEvent() {
        Object object;
        if (this.defaultToHeapDispatcher()) {
            this.makeHeapEventDispatcher();
            this.eventDispatcherLogic = this.heapEventDispatcherLogic;
            this.nonHeapInitialDispatcher = false;
        } else {
            try {
                this.eventDispatcherLogic = new EventDispatcherLogic(this);
            }
            catch (Error error) {
                System.err.println("Error creating event dispatcher logic.");
                throw error;
            }
            object = NoDeadlineParams.instance();
            try {
                this.nhEventDispatcher = new NoHeapRealtimeThread(null, (ReleaseParameters)object, null, this.eventDispatcherArea, null, this.eventDispatcherLogic, true, null);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Exception creating event dispatcher thread");
                throw runtimeException;
            }
            this.nhEventDispatcher.setName("NHEventDispatcher-" + this);
            this.nhEventDispatcher.setDaemon(true);
            this.eventDispatcherLogic.setRtt(this.nhEventDispatcher);
            PriorityParameters priorityParameters = new PriorityParameters(HighPriorityScheduler.instance().getMaxPriority() - 11);
            try {
                this.nhEventDispatcher.internalSetScheduler(HighPriorityScheduler.instance(), priorityParameters, (ReleaseParameters)object, null, null);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Exception setting event dispatcher scheduler");
                throw runtimeException;
            }
            this.nonHeapInitialDispatcher = true;
            this.nhEventDispatcher.start();
        }
        object = this.eventDispatcherLogic;
        synchronized (object) {
            try {
                while (!this.eventDispatcherLogic.running) {
                    this.eventDispatcherLogic.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean defaultToHeapDispatcher() {
        Thread thread = Thread.currentThread();
        if (thread instanceof NoHeapRealtimeThread) {
            return false;
        }
        if (thread instanceof RealtimeThread) {
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            if (memoryArea instanceof HeapMemory) {
                return true;
            }
            return MemoryArea.getMemoryArea(memoryArea) instanceof HeapMemory;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeHeapEventDispatcher() {
        try {
            this.heapEventDispatcherLogic = new EventDispatcherLogic(this);
        }
        catch (Error error) {
            System.err.println("Error creating event dispatcher logic.");
            throw error;
        }
        PriorityParameters priorityParameters = PriorityScheduler.getMaxHeapPriorityParameters();
        NoDeadlineParams noDeadlineParams = NoDeadlineParams.instance();
        try {
            this.heapEventDispatcher = new RealtimeThread(priorityParameters, (ReleaseParameters)noDeadlineParams, null, null, null, this.heapEventDispatcherLogic, this.exContextCount == 0, null);
            this.heapEventDispatcher.setName("EventDispatcher-" + this);
            this.heapEventDispatcher.setDaemon(true);
            this.heapEventDispatcherLogic.setRtt(this.heapEventDispatcher);
            this.heapEventDispatcher.start();
            EventDispatcherLogic eventDispatcherLogic = this.heapEventDispatcherLogic;
            synchronized (eventDispatcherLogic) {
                try {
                    while (!this.heapEventDispatcherLogic.running) {
                        this.heapEventDispatcherLogic.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Exception creating event dispatcher scheduler 2");
            throw runtimeException;
        }
    }

    final long getEventDispatcherID() {
        return this.eventDispatcherLogic.getID();
    }

    public void addHandler(AsyncEventHandler asyncEventHandler) {
        this.internalAddHandler(asyncEventHandler);
    }

    final void internalAddHandler(AsyncEventHandler asyncEventHandler) {
        if (asyncEventHandler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        this.secondDispatcherIfNeeded(asyncEventHandler);
        this.handlerSet.addHandler(asyncEventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secondDispatcherIfNeeded(AsyncEventHandler asyncEventHandler) {
        if (this.nonHeapInitialDispatcher) {
            Object object = this.secondDispatcherLock;
            synchronized (object) {
                if (this.heapDispatcherRequired(asyncEventHandler)) {
                    this.secondDispatcherNeeded();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secondDispatcherNeeded() {
        Object object = this.secondDispatcherLock;
        synchronized (object) {
            if (this.heapEventDispatcher == null) {
                if (this.makeDispatcherInInstanceMem == null) {
                    this.makeDispatcherInInstanceMem = new MakeDispatcherInInstanceMem(this);
                }
                MemoryArea.getMemoryArea(this).executeInArea(this.makeDispatcherInInstanceMem);
                for (int i = 0; i < this.boundEventDispatcherKey.length; ++i) {
                    if (this.boundEventDispatcherKey[i] == 0) continue;
                    this.internalUnbindTo(i);
                    this.bindToCommonCode(i);
                }
            }
        }
    }

    private boolean heapDispatcherRequired(AsyncEventHandler asyncEventHandler) {
        return asyncEventHandler != null && (!asyncEventHandler.isNoHeap() || MemoryArea.getMemoryArea(asyncEventHandler) == HeapMemory.instance());
    }

    public void removeHandler(AsyncEventHandler asyncEventHandler) {
        this.internalRemoveHandler(asyncEventHandler);
    }

    final boolean internalRemoveHandler(AsyncEventHandler asyncEventHandler) {
        if (asyncEventHandler != null) {
            if (this.handlerSet.removeHandler(asyncEventHandler)) {
                return this.handlerSet.isEmpty();
            }
            return false;
        }
        return false;
    }

    public void setHandler(AsyncEventHandler asyncEventHandler) {
        this.internalSetHandler(asyncEventHandler);
    }

    final void internalSetHandler(AsyncEventHandler asyncEventHandler) {
        this.internalSetHandler(asyncEventHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalSetHandler(AsyncEventHandler asyncEventHandler, boolean bl) {
        boolean bl2;
        if (asyncEventHandler == null) {
            if (this.recursionDetector) {
                return;
            }
            this.recursionDetector = true;
        }
        HandlerSet handlerSet = this.handlerSet;
        synchronized (handlerSet) {
            bl2 = this.handlerSet.removeContents(bl);
            if (asyncEventHandler != null) {
                this.secondDispatcherIfNeeded(asyncEventHandler);
                this.handlerSet.setHandler(asyncEventHandler);
            }
        }
        if (bl2) {
            this.secondDispatcherNeeded();
            this.heapEventDispatcherLogic.setExecuteDeferredAction(true);
            this.handlerSet.waitForDeferredDone();
        }
        this.recursionDetector = false;
    }

    final void deferredActions() {
        this.handlerSet.clearDeferredList();
    }

    private void setScopeDaemon(boolean bl) {
        if (this.eventDispatcherLogic == null || !this.eventDispatcherLogic.running) {
            throw new RuntimeException("Trying to setScopeDaemon on a dispatcher that isn't running");
        }
        this.eventDispatcherLogic.setScopeDaemon(bl);
        if (this.nonHeapInitialDispatcher && this.heapEventDispatcherLogic != null) {
            if (!this.heapEventDispatcherLogic.running) {
                throw new RuntimeException("Trying to setScopeDaemon on a heap dispatcher that isn't running");
            }
            this.heapEventDispatcherLogic.setScopeDaemon(bl);
        }
    }

    public boolean handledBy(AsyncEventHandler asyncEventHandler) {
        return this.internalHandledBy(asyncEventHandler);
    }

    final boolean internalHandledBy(AsyncEventHandler asyncEventHandler) {
        if (asyncEventHandler == null) {
            return false;
        }
        return this.handlerSet.handledBy(asyncEventHandler);
    }

    public ReleaseParameters createReleaseParameters() {
        return this.createReleaseParameters(null);
    }

    ReleaseParameters createReleaseParameters(ReleaseParameters releaseParameters) {
        if (releaseParameters == null) {
            return new AperiodicParameters();
        }
        if (releaseParameters instanceof AperiodicParameters) {
            return releaseParameters;
        }
        throw new IllegalArgumentException("dest not an instance of AperiodicParameters");
    }

    public void bindTo(String string) throws UnknownHappeningException {
        this.internalBindTo(string);
    }

    public SchedulingParameters bindTo(String string, SchedulingParameters schedulingParameters) {
        if (schedulingParameters == null) {
            throw new IllegalArgumentException("Null eligibility");
        }
        if (!MemoryArea.isSoftSubsetLExcludeNhOn0() && !(MemoryArea.getMemoryArea(schedulingParameters) instanceof ImmortalMemory)) {
            throw new IllegalArgumentException("eligibility parameter is not in immortal memory");
        }
        this.bindTo(string);
        if (this.nhEventDispatcher != null) {
            this.nhEventDispatcher.setSchedulingParameters(schedulingParameters);
        } else if (this.heapEventDispatcher != null) {
            this.heapEventDispatcher.setSchedulingParameters(schedulingParameters);
        }
        return schedulingParameters;
    }

    final synchronized void internalBindTo(String string) throws UnknownHappeningException {
        if (string == null) {
            throw new IllegalArgumentException("happening argument is null");
        }
        int n = this.translateHappening(string);
        this.bindToCommonCode(n);
    }

    private boolean bindToCommonCode(int n) {
        if (this.boundEventDispatcherKey[n] != 0) {
            return false;
        }
        long l = this.heapEventDispatcherLogic == null ? this.eventDispatcherLogic.getID() : this.heapEventDispatcherLogic.getID();
        this.boundEventDispatcherKey[n] = EventDispatcherSet.addEventDispatcher(n, l);
        this.makeDispatcherBeExContext(true);
        return true;
    }

    public void unbindTo(String string) throws UnknownHappeningException {
        this.internalUnbindTo(string);
    }

    final int getHeapReahCount() {
        return this.handlerSet.getHeapReahCount();
    }

    final int getMaxRaehScopeDepth() {
        return this.handlerSet.getMaxReahScopeDepth();
    }

    final int getHeapModeReahCount() {
        return this.handlerSet.getHeapModeReahCount();
    }

    final boolean isAllRich() {
        int n = this.handlerSet.size();
        return n > 0 && n == this.handlerSet.getRaehCount();
    }

    final void internalUnbindTo(String string) throws UnknownHappeningException {
        if (string == null) {
            throw new IllegalArgumentException("happening argument is null");
        }
        int n = this.translateHappening(string);
        this.internalUnbindTo(n);
    }

    final synchronized boolean isBound(int n) {
        return this.boundEventDispatcherKey[n] != 0;
    }

    final synchronized boolean isBound(String string) {
        if (string == null) {
            throw new IllegalArgumentException("happening argument is null");
        }
        return this.isBound(this.translateHappening(string));
    }

    final synchronized void internalUnbindTo(int n) {
        if (this.boundEventDispatcherKey[n] == 0) {
            throw new UnknownHappeningException("AsyncEvent not bound to this happening");
        }
        EventDispatcherSet.removeEventDispatcher(n, this.boundEventDispatcherKey[n]);
        this.boundEventDispatcherKey[n] = 0;
        this.makeDispatcherBeExContext(false);
    }

    private int translateHappening(String string) throws UnknownHappeningException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownHappeningException("Unsupported happening");
        }
        this.checkHappening(n);
        return n;
    }

    private void checkHappening(int n) throws UnknownHappeningException {
        if (n < 1 || n >= 64) {
            throw new UnknownHappeningException("Unsupported happening");
        }
        if (AsyncEvent.isReserved(n)) {
            throw new UnknownHappeningException("System reserved happening");
        }
    }

    static boolean isReserved(int n) {
        for (int i = 0; i < HAPPENING_RESERVED.length; ++i) {
            if (HAPPENING_RESERVED[i] != n) continue;
            return true;
        }
        return false;
    }

    public void fire() {
        this.realFire(RichAsyncEventHandler.NO_DATA, 0, false);
    }

    void realFire(Object object, int n, boolean bl) {
        Thread thread = Thread.currentThread();
        if (thread instanceof RealtimeThread && ((RealtimeThread)thread == this.nhEventDispatcher || (RealtimeThread)thread == this.heapEventDispatcher)) {
            System.err.println("AE fire recursion in realFire.");
            throw new RuntimeException("Fire recursion.");
        }
        if (n > 0 && MemoryArea.getMemoryArea(this.eventDispatcherLogic) instanceof HeapMemory) {
            this.eventDispatcherLogic.setArgument(RichAsyncEventHandler.INACCESSIBLE_DATA, 0, bl);
        } else {
            this.eventDispatcherLogic.setArgument(object, n, bl);
        }
        this.eventDispatcherLogic.fireEventDispatcher(0);
        this.returnedExceptionSem.down();
        if (this.nonHeapInitialDispatcher && this.heapEventDispatcherLogic != null && this.heapEventDispatcherLogic.running) {
            if (n > 0 && MemoryArea.getMemoryArea(this.heapEventDispatcherLogic) instanceof HeapMemory) {
                this.heapEventDispatcherLogic.setArgument(RichAsyncEventHandler.INACCESSIBLE_DATA, 0, bl);
            } else {
                this.heapEventDispatcherLogic.setArgument(object, n, bl);
            }
            this.heapEventDispatcherLogic.fireEventDispatcher(0);
            this.returnedExceptionSem.down();
        }
        if (this.returnedException != null) {
            if (this.returnedException instanceof RuntimeException) {
                throw (RuntimeException)this.returnedException;
            }
            if (this.returnedException instanceof Error) {
                throw (Error)this.returnedException;
            }
        }
    }

    void returnException(Throwable throwable) {
        this.returnedException = throwable;
        this.returnedExceptionSem.up();
    }

    Throwable internalFire(Object object, int n, boolean bl) {
        RuntimeException runtimeException = null;
        boolean bl2 = this.nhEventDispatcher != null;
        runtimeException = this.handlerSet.fireHandlers(bl2, object, n, bl);
        return runtimeException;
    }

    final void makeDispatcherBeExContext(boolean bl) {
        if (!bl) {
            if (this.exContextCount <= 0) {
                throw new RuntimeException("makeDispatcherBeExContext(false) with count <= 0");
            }
            if (--this.exContextCount == 0) {
                this.setScopeDaemon(true);
            }
        } else if (this.exContextCount++ == 0) {
            this.setScopeDaemon(false);
        }
    }

    final String dispatcherState() {
        String string = null;
        string = this.nhEventDispatcher != null ? (this.nhEventDispatcher.getScopeDaemon() ? "NH dispatcher is a daemon" : "NH dispatcher is not a daemon") : "No NH dispatcher";
        string = this.heapEventDispatcher != null ? string + (this.heapEventDispatcher.getScopeDaemon() ? "/ heap dispatcher is a daemon" : "/ heap dispatcher is not a daemon") : string + "/ no heap dispatcher";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        try {
            AsyncEvent asyncEvent = this;
            synchronized (asyncEvent) {
                if (this.shuttingDown) {
                    if (Thread.currentThread().hashCode() == this.shutdownThreadCode) {
                        return;
                    }
                    while (this.shuttingDown) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return;
                }
                this.shuttingDown = true;
                this.shutdownThreadCode = Thread.currentThread().hashCode();
            }
            if (!this.handlerSet.isEmpty()) {
                this.internalSetHandler(null, !this.finalizing);
            }
            try {
                for (int i = 0; i < 64; ++i) {
                    if (this.boundEventDispatcherKey[i] == 0) continue;
                    EventDispatcherSet.removeEventDispatcher(i, this.boundEventDispatcherKey[i]);
                    this.boundEventDispatcherKey[i] = 0;
                }
            }
            catch (Throwable throwable) {
                System.err.println("AsyncEvent.shutdown() exception in removeEventDispatcher loop");
            }
            if (this.eventDispatcherLogic != null) {
                try {
                    this.eventDispatcherLogic.fireEventDispatcher(5);
                    this.eventDispatcherLogic = null;
                }
                catch (Throwable throwable) {
                    System.err.println("Exception from fireEventDispatcher 1");
                }
            }
            if (this.nonHeapInitialDispatcher && this.heapEventDispatcherLogic != null) {
                try {
                    this.heapEventDispatcherLogic.fireEventDispatcher(5);
                    this.heapEventDispatcherLogic = null;
                }
                catch (Throwable throwable) {
                    System.err.println("Exception from fireEventDispatcher 2");
                }
            }
            try {
                if (this.nhEventDispatcher != null) {
                    long l = System.currentTimeMillis();
                    this.nhEventDispatcher.join(500L);
                    long l2 = System.currentTimeMillis();
                    if (l + 500L < l2) {
                        System.err.println("Warning: AsyncEvent.eventDispatcher thread did not terminate when expected");
                        try {
                            this.nhEventDispatcher.interrupt();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.nhEventDispatcher = null;
                }
                Object object = this.secondDispatcherLock;
                synchronized (object) {
                    if (this.heapEventDispatcher != null) {
                        long l = System.currentTimeMillis();
                        try {
                            this.heapEventDispatcher.join(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.heapEventDispatcher.join(500L);
                        }
                        long l3 = System.currentTimeMillis();
                        if (l + 500L < l3) {
                            System.err.println("Warning: AsyncEvent.eventDispatcher thread did not terminate when expected");
                            try {
                                this.heapEventDispatcher.interrupt();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        this.heapEventDispatcher = null;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("AE shutdown interrupted");
                exception.printStackTrace();
            }
            finally {
                AsyncEvent asyncEvent2 = this;
                synchronized (asyncEvent2) {
                    this.shuttingDown = false;
                    this.shutdownThreadCode = 0;
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Exception in AsyncEvent.shutdown().");
            System.err.println(throwable);
            throwable.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        if (MemoryArea.getMemoryArea(this) == HeapMemory.instance()) {
            this.finalizing = true;
            this.shutdown();
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            System.err.println("AsyncEvent.finalize() exception in super.finalize()");
        }
        this.finalizing = false;
    }

    static {
        try {
            Class.forName("javax.realtime.EventDispatcherSet");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class MakeDispatcherInInstanceMem
    implements Runnable {
        final AsyncEvent goHere;

        MakeDispatcherInInstanceMem(AsyncEvent asyncEvent2) {
            this.goHere = asyncEvent2;
        }

        public void run() {
            this.goHere.makeHeapEventDispatcher();
        }
    }
}

