/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javax.safetycritical.ManagedMemory;
import javax.safetycritical.MissionManager;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public class PrivateMemory
extends ManagedMemory {
    private MissionManager _manager;
    private ManagedMemory _resideInScope;

    @SCJAllowed
    public PrivateMemory(long l) {
        super(l);
        MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
        if (memoryArea instanceof ManagedMemory) {
            this._resideInScope = (ManagedMemory)memoryArea;
        }
        this._manager = this._resideInScope.getManager();
    }

    @SCJAllowed
    public MissionManager getManager() {
        return this._manager;
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public void enter(Runnable runnable) {
        if (this._resideInScope != RealtimeThread.getCurrentMemoryArea()) {
            String string = "Attempt to enter private memory from the memory area other than where it is created";
            string = string + "\nPrivate Memory: " + this;
            string = string + "\n Current Area: " + RealtimeThread.getCurrentMemoryArea();
            string = string + "\n Expected Current Area: " + this._resideInScope;
        }
        super.enter(runnable);
    }
}

