/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import com.fiji.fivm.r1.NoScopeChecks;
import edu.purdue.scj.BackingStoreID;
import edu.purdue.scj.VMSupport;
import java.lang.reflect.Array;
import javax.realtime.AllocationContext;
import javax.realtime.ImmortalMemory;
import javax.realtime.InaccessibleAreaException;
import javax.realtime.RealtimeThread;
import javax.realtime.ScopeStack;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public abstract class MemoryArea
implements AllocationContext {
    static final long _TEMPSIZE = ScopeStack._BASE_SIZE;
    private BackingStoreID _scopeID;
    long _size;

    protected MemoryArea(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        this._size = l;
    }

    protected MemoryArea(BackingStoreID backingStoreID) {
        this._scopeID = backingStoreID;
        this._size = VMSupport.getScopeSize(this._scopeID);
        VMSupport.setNote(this._scopeID, this);
    }

    @SCJAllowed
    public static MemoryArea getMemoryArea(Object object) {
        return MemoryArea.getMemoryAreaObject(VMSupport.areaOf(object));
    }

    @SCJAllowed
    public void enter(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("null logic not permitted");
        }
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        this.enterImpl(realtimeThread, runnable);
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public void executeInArea(Runnable runnable) throws InaccessibleAreaException {
        if (runnable == null) {
            throw new IllegalArgumentException("null logic not permitted");
        }
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        this.execInAreaImpl(realtimeThread, runnable);
    }

    @SCJAllowed
    public Object newInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        return this.newInstanceImpl(realtimeThread, clazz);
    }

    @SCJAllowed
    public Object newArray(Class clazz, int n) throws NegativeArraySizeException, IllegalAccessException {
        RealtimeThread realtimeThread = RealtimeThread.currentRealtimeThread();
        return this.newArrayImpl(realtimeThread, clazz, n);
    }

    @SCJAllowed
    public static Object newArrayInArea(Object object, Class clazz, int n) throws IllegalAccessException {
        return MemoryArea.getMemoryArea(object).newArray(clazz, n);
    }

    @SCJAllowed
    public static Object newInstanceInArea(Object object, Class clazz) throws InstantiationException, IllegalAccessException {
        return MemoryArea.getMemoryArea(object).newInstance(clazz);
    }

    @SCJAllowed
    public long memoryConsumed() {
        return VMSupport.memoryConsumed(this.get_scopeID());
    }

    @SCJAllowed
    public long memoryRemaining() {
        return VMSupport.memoryRemaining(this.get_scopeID());
    }

    @SCJAllowed
    public long size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enterImpl(RealtimeThread realtimeThread, Runnable runnable) {
        this.preScopeEnter(realtimeThread);
        this.allocBackingStore();
        realtimeThread.getScopeStack().push(this);
        try {
            VMSupport.enter(this.get_scopeID(), runnable);
        }
        finally {
            realtimeThread.getScopeStack().pop();
            this.freeBackingStore();
            this.postScopeEnter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void execInAreaImpl(RealtimeThread realtimeThread, Runnable runnable) {
        ScopeStack scopeStack = realtimeThread.getScopeStack();
        int n = scopeStack.getDepth(true);
        int n2 = scopeStack.getIndex(this, true);
        scopeStack.setActivePointer(n2);
        BackingStoreID backingStoreID = VMSupport.setCurrentArea(this.get_scopeID());
        try {
            runnable.run();
        }
        finally {
            VMSupport.setCurrentArea(backingStoreID);
            scopeStack.setActivePointer(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object newArrayImpl(RealtimeThread realtimeThread, Class clazz, int n) throws IllegalAccessException, NegativeArraySizeException {
        ScopeStack scopeStack = realtimeThread.getScopeStack();
        int n2 = scopeStack.getDepth(true);
        int n3 = scopeStack.getIndex(this, true);
        scopeStack.setActivePointer(n3);
        BackingStoreID backingStoreID = VMSupport.setCurrentArea(this.get_scopeID());
        try {
            Object object = Array.newInstance(clazz, n);
            return object;
        }
        finally {
            VMSupport.setCurrentArea(backingStoreID);
            scopeStack.setActivePointer(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object newInstanceImpl(RealtimeThread realtimeThread, Class clazz) throws InstantiationException, IllegalAccessException {
        ScopeStack scopeStack = realtimeThread.getScopeStack();
        int n = scopeStack.getDepth(true);
        int n2 = scopeStack.getIndex(this, true);
        scopeStack.setActivePointer(n2);
        BackingStoreID backingStoreID = VMSupport.setCurrentArea(this.get_scopeID());
        try {
            Object t = clazz.newInstance();
            return t;
        }
        finally {
            VMSupport.setCurrentArea(backingStoreID);
            scopeStack.setActivePointer(n);
        }
    }

    static MemoryArea getMemoryAreaObject(BackingStoreID backingStoreID) {
        if (backingStoreID == ImmortalMemory.instance().get_scopeID()) {
            return ImmortalMemory.instance();
        }
        return (MemoryArea)VMSupport.getNote(backingStoreID);
    }

    @NoScopeChecks
    BackingStoreID get_scopeID() {
        return this._scopeID;
    }

    @NoScopeChecks
    void set_scopeID(BackingStoreID backingStoreID) {
        this._scopeID = backingStoreID;
    }

    protected void preScopeEnter(RealtimeThread realtimeThread) {
    }

    protected void postScopeEnter() {
    }

    protected void setSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Mission memory size must be non-negative");
        }
        this._size = l;
    }

    private void allocBackingStore() {
        if (this.get_scopeID() == null) {
            this.set_scopeID(VMSupport.pushScope(this._size));
            VMSupport.setNote(this.get_scopeID(), this);
        }
    }

    private void freeBackingStore() {
        if (this.get_scopeID() != ImmortalMemory.instance().get_scopeID()) {
            VMSupport.popScope();
            this.set_scopeID(null);
        }
    }
}

